/***********************************************************************/
/*!
* \file  spi_tclCalibrationReaderBase.h
* \brief  Implementation of the Class spi_tclCalibrationReaderBase
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    To read static configurations from KDS...
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018    kmo6kor			    Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLCALIBRATIONREADERBASE_
#define SPI_TCLCALIBRATIONREADERBASE_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

class spi_tclCalibrationReaderBase
{

public:

   /***************************************************************************
    ****************************PUBLIC *********************************
    ***************************************************************************/

	/***************************************************************************
	 ** FUNCTION: spi_tclCalibrationReaderBase::spi_tclCalibrationReaderBase()
	 ***************************************************************************/
	/*!
	 * \fn      spi_tclCalibrationReaderBase()
	 * \brief   Constructor
	 * \param   None
	 **************************************************************************/
    spi_tclCalibrationReaderBase(){};

	/***************************************************************************
	 ** FUNCTION: spi_tclCalibrationReaderBase::~spi_tclCalibrationReaderBase()
	 ***************************************************************************/
	/*!
	 * \fn      ~spi_tclCalibrationReaderBase()
	 * \brief   Destructor
	 * \param   None
	 **************************************************************************/
	virtual ~spi_tclCalibrationReaderBase(){};

    /***************************************************************************
    ** FUNCTION: tBool spi_tclCalibrationReaderBase::bReadData(tU16 u16KdsKey, tU16 u16DataLen, tU8* pu8DataBuffer)
    ***************************************************************************/
    /*!
    * \fn      bReadData(tU16 u16KdsKey, tU16 u16DataLen, tU8* pu8DataBuffer)
    * \brief   Interface to read data using a Key in KDS.
    * \param   u16KdsKey [IN] : Key address at which data is stored in KDS
    * \param   u16DataLen [IN] : Total size of the data, stored at u16KdsKey
    * \param   pu8DataBuffer [OUT] : Pointer to buffer, to which read data should be copied.
    * \retval  tBool: TRUE - if read is successful, else FALSE.
    ***************************************************************************/
    virtual tBool bReadData(tU16 /*u16KdsKey*/, tU16 /*u16DataLen*/, tVoid* /*pu8DataBuffer*/) { return false; };

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/

};
#endif //SPI_TCLCALIBRATIONREADERBASE_
