/***********************************************************************/
/*!
 * \file  spi_tclDiscovererSettings.h
 * \brief Class to read the settings from SPISettings.xml
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Project specific settings for Device discovery
 AUTHOR:         Noopur R Kalawatia
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                   | Modification
 19.01.2017  | Noopur R Kalawatia       | Initial Version
 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLDISCOVERERSETTINGS_H_
#define SPI_TCLDISCOVERERSETTINGS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include <map>
#include <set>
#include "BaseTypes.h"
#include "GenericSingleton.h"
#include "Xmlable.h"
#include "SPITypes.h"
#include "Lock.h"
/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclConnSettings
 * \brief Project specific settings for Connection Management
 */
class spi_tclDiscovererSettings: public shl::xml::tclXmlReadable
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscovererSettings::spi_tclDiscovererSettings
       ***************************************************************************/
      /*!
       * \fn     spi_tclDiscovererSettings()
       * \brief  Default Constructor
       * \sa     spi_tclDiscovererSettings()
       **************************************************************************/
      spi_tclDiscovererSettings();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscovererSettings::~spi_tclDiscovererSettings
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclDiscovererSettings()
       * \brief  Destructor
       * \sa     spi_tclDiscovererSettings()
       **************************************************************************/
      ~spi_tclDiscovererSettings();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiscovererSettings::vIntializeSPISettings
       ***************************************************************************/
      /*!
       * \fn     t_Void vIntializeSPISettings()
       * \brief  Reads settings from xml file and store it internally
       **************************************************************************/
      t_Void vIntializeSPISettings();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiscovererSettings::bIsDeviceBlacklisted
       ***************************************************************************/
      /*!
       * \fn     t_Void bIsDeviceBlacklisted()
       * \brief  to check whether  the dvice is blacklisted.
       **************************************************************************/
      t_Bool bIsDeviceBlacklisted(t_S32 s32ProductID, t_S32 s32VendorID, tenDeviceCategory enDeviceCtegory =
               e8DEV_TYPE_DEFAULT);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiscovererSettings::vIsDeviceWhitelisted(...
       ***************************************************************************/
      /*!
       * \fn     t_Void vIsDeviceWhitelisted()
       * \brief  to check whether the connected device is whitelisted or not and return category
       **************************************************************************/
      t_Void vIsDeviceWhitelisted(t_S32 s32ProductID, t_S32 s32VendorID, tenDeviceCategory &rfenDevCat);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDiscovererSettings::bIsDeviceWhitelistingEnabled(...
       ***************************************************************************/
      /*!
       * \fn     t_Bool bIsDeviceWhitelistingEnabled()
       * \brief  to check whether the whitelisting is enabled for a project or not
       **************************************************************************/
      t_Bool bIsDeviceWhitelistingEnabled();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDiscovererSettings::bIsWhitelistEnabledCat(...
       ***************************************************************************/
      /*!
       * \fn     t_Bool bIsWhitelistEnabledCat()
       * \brief  to set the category for which whitelisting is enabled
       **************************************************************************/
      t_Bool bIsWhitelistEnabledCat(tenDeviceCategory enChosenDeviceCategory);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclConnSettings::vGetDeviceInclusionListPath
       ***************************************************************************/
      /*!
       * \fn     t_Bool vGetDeviceInclusionListPath(t_String &rfszDeviceInclusionListPath)
       * \brief  Method to device inclusion list storage path
       * \param  rfszDeviceInclusionListPath:[IN]Path to store the path
       * \retval t_Void
       **************************************************************************/
      t_Void vSetDeviceListPath(t_String rfszDeviceInclusionListPath, t_String rfszDeviceExclusionListPath);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDeviceDiscoverer::bIsDeviceWhitelisted
       ***************************************************************************/
      /*!
       * \brief  check if the device is whitelisted based on VID and PID of device
       * \param  [IN] u32ProductID :Product ID
       * \param  [IN] u32VendorID : Vendor ID
       * \param  [IN] enReqDevCat : Device Category
       ***************************************************************************/
      t_Bool bIsDeviceWhitelisted(t_U32 u32ProductID, t_U32 u32VendorID, tenDeviceCategory enReqDevCat);

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/
   private:
      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclVncSettings::vDisplayVncSettings
       ***************************************************************************/
      /*!
       * \fn     t_Void vDisplayVncSettings()
       * \brief  Displays Vnc wrapper settings from xml file
       **************************************************************************/
      t_Void vDisplaySPISettings();

      /*************************************************************************
       ** FUNCTION:  virtual bXmlReadNode(xmlNode *poNode)
       *************************************************************************/
      /*!
       * \fn     virtual bool bXmlReadNode(xmlNode *poNode)
       * \brief  virtual function to read data from a xml node
       * \param  poNode : [IN] pointer to xml node
       * \retval bool : true if success, false otherwise.
       *************************************************************************/
      virtual t_Bool bXmlReadNode(xmlNodePtr poNode);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiscovererSettings::vSetWhitelistEnabledCat(...
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetWhitelistEnabledCat()
       * \brief  to set the category for which whitelisting is enabled
       **************************************************************************/
      t_Void vSetWhitelistEnabledCat(tenDeviceCategory enDevCat);

      //! Following member variables store the settings read from xml file

      //!Device exclusion list
      std::multimap<t_S32, t_S32> m_mapAAPDevExclusionList;

      //!ML device white list
      std::map<std::pair<t_S32, t_S32>, tenDeviceCategory> m_mapMLDevInclusionList;

      t_Bool m_bUSBPort1;

      t_Bool m_bUSBPort2;

      t_Bool m_bUSBPort3;

      //! Is whitelisting enabled for current project
      t_Bool m_bIsDeviceWhitelistingEnabled;

      //! Store device categories for which whitelisting is enabled
      std::set<tenDeviceCategory> m_setDevCat;

      //! Lock for m_setDevCat
      Lock m_oLocksetDevCat;

      t_String m_szDeviceExclusionListPath;
      t_String m_szDeviceInclusionListPath;
};
#endif // spi_tclDiscovererSettings_H_
