/***********************************************************************/
/*!
 * \file  spi_tclDataServiceSettings.h
 * \brief Class to get the DataService Settings
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Class to get the DataService Settings
 AUTHOR:         Ramya Murthy
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 26.05.2015  | Ramya Murthy          | Initial Version
 10.01.2017  | Noopur R Kalawatia    | Added speed frequency field.

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLDATASERVICESETTINGS_H_
#define _SPI_TCLDATASERVICESETTINGS_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "Xmlable.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class spi_tclDataServiceSettings
 * \brief Class to get the Bluetooth and Telephone services Info
 ****************************************************************************/
class spi_tclDataServiceSettings: public shl::xml::tclXmlReadable
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDataServiceSettings::spi_tclDataServiceSettings()
       ***************************************************************************/
      /*!
       * \fn      spi_tclDataServiceSettings()
       * \brief   Default Constructor
       * \sa      ~spi_tclDataServiceSettings()
       **************************************************************************/
      spi_tclDataServiceSettings();

      /***************************************************************************
       ** FUNCTION:  spi_tclDataServiceSettings::~spi_tclDataServiceSettings()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDataServiceSettings()
       * \brief   Destructor
       * \sa      spi_tclDataServiceSettings()
       **************************************************************************/
      ~spi_tclDataServiceSettings();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbGPSSeviceEnabled()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetCdbGPSSeviceEnabled()
       * \brief  Interface to read whether GPS CDB service is enabled
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetCdbGPSSeviceEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbLocationSeviceEnabled()
       ***************************************************************************/
      /*!
       * \fn     bGetCdbLocationSeviceEnabled()
       * \brief  Interface to read whether Location CDB service is enabled
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetCdbLocationSeviceEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbPrivateSeviceEnabled()
       ***************************************************************************/
      /*!
       * \fn     bGetCdbPrivateSeviceEnabled()
       * \brief  Interface to read whether Private CDB service is enabled
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetCdbPrivateSeviceEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbMediaMetadataSinkEnabled()
       ***************************************************************************/
      /*!
       * \fn     bGetCdbMediaMetadataSinkEnabled()
       * \brief  Interface to read whether CDB Sink Media Metadata sink is enabled
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetCdbMediaMetadataSinkEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbMediaMetadataSeviceEnabled()
       ***************************************************************************/
      /*!
       * \fn     bGetCdbNaviMetadataSinkEnabled()
       * \brief  Interface to read whether CDB Navigation Metadata sink is enabled
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetCdbNaviMetadataSinkEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDataServiceSettings::vReadDataServiceSettings()
       ***************************************************************************/
      /*!
       * \fn     t_Void vReadDataServiceSettings()
       * \brief  To read the settings from XML
       * \retval t_Void
       **************************************************************************/
      t_Void vReadDataServiceSettings();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetEnvDataSubEnabled()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetEnvDataSubEnabled() const
       * \brief  Interface to get whether to subscribe for Environment data or not
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetEnvDataSubEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetGearStatusEnabled()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetGearStatusEnabled() const
       * \brief  Interface to get whether to subscribe for Gear Status data or not
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetGearStatusEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetAccelerometerDataEnabled()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetAccelerometerDataDisable() const
       * \brief  Interface to get whether to subscribe for Accelerometer data or not
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetAccelerometerDataEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetGyroDataEnabled()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetGyroDataEnabled() const
       * \brief  Interface to get whether to subscribe for Gyroscope data or not
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetGyroDataEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetParkBrakeDataEnabled()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetParkBrakeDataEnabled() const
       * \brief  Interface to get whether to subscribe for park brake data or not
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetParkBrakeDataEnabled() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bIsBochNavigation()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bIsBochNavigation() const
       * \brief  Interface to get the type of navigation used.
       * \retval t_Bool
       **************************************************************************/
      t_Bool bIsBochNavigation() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings:: u32GetSpeedTimerInterval()
       ***************************************************************************/
      /*!
       * \fn     t_Bool u32GetSpeedTimerInterval() const
       * \brief  Interface to get the Speed timer interval in ms.
       * \retval t_Bool
       **************************************************************************/
      t_U32 u32GetSpeedTimerInterval() const;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetLocDataEnabled()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetLocDataEnabled() const
       * \brief  Interface to get location data enabled setting
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetLocDataEnabled() const;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCarlifeGPSDataSupportflag()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetCarlifeGPSDataSupportflag() const
   * \brief  Interface to get location data enabled setting for carlfie
   * \retval t_Bool
   **************************************************************************/
   t_Bool bGetCarlifeGPSDataSupportflag() const;

protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /*************************************************************************
       ** FUNCTION:  virtual bXmlReadNode(xmlNode *poNode)
       *************************************************************************/
      /*!
       * \fn     virtual bool bXmlReadNode(xmlNode *poNode)
       * \brief  virtual function to read data from a xml node
       * \param  poNode : [IN] pointer to xml node
       * \retval bool : true if success, false otherwise.
       *************************************************************************/
      virtual t_Bool bXmlReadNode(xmlNodePtr poNode);

      /*************************************************************************
       ** Data Members
       *************************************************************************/

      /*
       * \brief   GPS service info
       */
      t_Bool m_bCdbGPSSeviceEnabled;

      /*
       * \brief   Location service info
       */
      t_Bool m_bCdbLocationSeviceEnabled;
      /*
       * \brief   Media Sink info
       */
      t_Bool m_bCdbMediaSinkEnabled;
      /*
       * \brief   Navi Sink info
       */
      t_Bool m_bCdbNaviSinkEnabled;

      t_Bool m_bSubForEnvData;

      t_Bool m_bSubForGearStatus;

      t_Bool m_bSubForAcclData;

      t_Bool m_bSubForGyroData;

      t_Bool m_bSubForParkBrakeData;

      t_Bool m_bIsBoschNavi;

      t_U32 m_u32SpeedTimerIntervalInMs;

      t_Bool m_bLocDataEnabled;

      /* Private CDB Service Info */
      t_Bool m_bCdbPrivateSeviceEnabled;
   t_Bool   m_bCarlifeGPSSupportflag;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

};
//spi_tclDataServiceSettings

#endif //_SPI_TCLDATASERVICESETTINGS_H_
