/*!
 *******************************************************************************
 * \file             spi_tclConnSettings.h
 * \brief            Project specific settings for Connection Management
 * \addtogroup       Connectivity
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Project specific settings for Connection Management
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 11.01.2014 |  Pruthvi Thej Nagaraju       | Initial Version
 24.11.2014 | Shiva Kumar Gurija           | XML Validation
 08.11.2016 |  Noopur R K                  | Session Configuration for AAP
 17.02.2017 | Noopur R K                   | Changes for Blacklisting of devices

 \endverbatim
 ******************************************************************************/

#ifndef SPI_CONNSETTINGS_H_
#define SPI_CONNSETTINGS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "Xmlable.h"
#include "spi_ConnMngrTypeDefines.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclConnSettings
 * \brief Project specific settings for Connection Management
 */
class spi_tclConnSettings: public shl::xml::tclXmlReadable
{
      public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclConnSettings::spi_tclConnSettings
       ***************************************************************************/
      /*!
       * \fn     spi_tclConnSettings()
       * \brief  Default Constructor
       * \sa      ~spi_tclConnSettings()
       **************************************************************************/
       spi_tclConnSettings();

      /***************************************************************************
       ** FUNCTION:  spi_tclConnSettings::~spi_tclConnSettings
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclConnSettings()
       * \brief  Destructor
       * \sa     spi_tclConnSettings()
       **************************************************************************/
      ~spi_tclConnSettings();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::bIntializeConnSettings
       ***************************************************************************/
      /*!
       * \fn     t_Void vIntializeConnSettings()
       * \brief  Reads settings from xml file and store it internally
       **************************************************************************/
      t_Void vIntializeConnSettings();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vDisplayConnSettings
       ***************************************************************************/
      /*!
       * \fn     t_Void vDisplayConnSettings()
       * \brief  Displays Connection settings from xml file
       **************************************************************************/
      t_Void vDisplayConnSettings();

      /***************************************************************************
       ** FUNCTION:  tenDeviceSelectionMode spi_tclConnSettings::enGetDeviceSelectionMode
       ***************************************************************************/
      /*!
       * \fn     tenDeviceSelectionMode enGetDeviceSelectionMode()
       * \brief  returns Device Selection Mode
       **************************************************************************/
      tenDeviceSelectionMode enGetDeviceSelectionMode(tenDeviceCategory enTechnologyType);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetDeviceSelectionMode()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetDeviceSelectionMode(
       * \brief   Method to set the device selection mode to automatic/manual. Changes
       *          will take into effect on successive connection
       * \param   enSelectionMode : Device selection mode @see tenDeviceSelectionMode
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetDeviceSelectionMode(tenDeviceSelectionMode enSelectionMode, tenDeviceCategory enTechnologyType);

      /***************************************************************************
       ** FUNCTION:  tenDeviceCategory spi_tclConnSettings::enGetTechnologyPreference
       ***************************************************************************/
      /*!
       * \fn     tenDeviceCategory enGetTechnologyPreference()
       * \brief  returns Device type preference
       **************************************************************************/
      tenDeviceCategory enGetTechnologyPreference(tenDeviceType enDeviceType) const;

      /***************************************************************************
       ** FUNCTION:  tenEnabledInfo spi_tclConnSettings::enGetCertificateType
       ***************************************************************************/
      /*!
       * \fn     tenEnabledInfo enGetCertificateType()
       * \brief  returns Certificate type
       **************************************************************************/
      tenCertificateType enGetCertificateType() const;

      /***************************************************************************
       ** FUNCTION:  tenSelModePriority spi_tclConnSettings::enGetSelectionModePriority
       ***************************************************************************/
      /*!
       * \fn     tenSelModePriority enGetSelectionModePriority()
       * \brief  returns Priority of selection mode
       **************************************************************************/
      tenSelModePriority enGetSelectionModePriority();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vGetPersistentStoragePath
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetPersistentStoragePath()
       * \brief  returns path for persistent Storage
       **************************************************************************/
      t_Void vGetPersistentStoragePath(t_String &rfszPersStoragePath);

      /***************************************************************************
       ** FUNCTION:  t_U32 spi_tclConnSettings::u32GetDeviceHistorySize
       ***************************************************************************/
      /*!
       * \fn     t_U32 u32GetDeviceHistorySize()
       * \brief  returns the Maximum size of Device History Database
       **************************************************************************/
      t_U32 u32GetDeviceHistorySize();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclConnSettings::bIsXMLValidationEnabled
       ***************************************************************************/
      /*!
       * \fn     t_Bool bIsXMLValidationEnabled()
       * \brief  Method to check whether the XML validation is enabled or not
       * \retval t_Bool
       **************************************************************************/
      t_Bool bIsXMLValidationEnabled() const;
	  
	  /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vGetHeadUnitInfo
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetHeadUnitInfo()
       * \brief  Method to retrieve head unit information
       * \retval t_Void
       **************************************************************************/
      t_Void vGetMySPINIapAppInfo(trMySPINIapAppInfo& rMySPINIapAppInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vGetMySPINAoapAppInfo
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetMySPINAoapAppInfo(trMySPINAoapAppInfo& rfrMySPINAoapAppInfo)
       * \brief  Method to retrieve head unit information
       * \param  rfrMySPINAoapAppInfo:[IN]Aoap application information
       * \retval t_Void
       **************************************************************************/
      t_Void vGetMySPINAoapAppInfo(trMySPINAoapAppInfo& rfrMySPINAoapAppInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vGetDeviceExclusionListPath
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetDeviceExclusionListPath(t_String &rfszDeviceExclusionListPath)
       * \brief  Method to device exclusion list storage path
       * \param  rfszDeviceExclusionListPath:[IN]Path to store the path
       * \retval t_Void
       **************************************************************************/
      t_Void vGetDeviceExclusionListPath(t_String &rfszDeviceExclusionListPath);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vGetDeviceInclusionListPath
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetDeviceInclusionListPath(t_String &rfszDeviceInclusionListPath)
       * \brief  Method to device inclusion list storage path
       * \param  rfszDeviceInclusionListPath:[IN]Path to store the path
       * \retval t_Void
       **************************************************************************/
      t_Void vGetDeviceInclusionListPath(t_String &rfszDeviceInclusionListPath);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vStoreSelectionModefromDatapool
       ***************************************************************************/
      /*!
       * \fn     t_Void vStoreSelectionModefromDatapool(tenDeviceSelectionMode enStoredSelectionMode)
       * \brief  Method to get the selection mode stored in datapool
       * \param  enStoredSelectionMode:[IN]Selection mode stored in datapool
       * \retval t_Void
       **************************************************************************/
      t_Void vStoreSelectionModefromDatapool(tenDeviceSelectionMode enStoredSelectionMode);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclConnSettings::vStoreDevicePreferencefromDatapool
       ***************************************************************************/
      /*!
       * \fn     t_Void vStoreDevicePreferencefromDatapool(tenDeviceCategory enAndroidDevicePreferencefromDatapool..)
       * \brief  Method to store device preference from datapool
       * \param  enAndroidDevicePreferencefromDatapool:[IN]Android device preference
       * \param  enAppleDevicePreferencefromDatapool:[IN]Apple device preference
       * \retval t_Void
       **************************************************************************/
      t_Void vStoreDevicePreferencefromDatapool(tenDeviceCategory enAndroidDevicePreferencefromDatapool,
             tenDeviceCategory enAppleDevicePreferencefromDatapool);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclConnSettings::bGetCarlifeIOSFeatureSupport
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetCarlifeIOSFeatureSupport()
       * \brief  Method to retrieve Carlife Ios enable info from policy
       * \retval t_Bool
       **************************************************************************/
       t_Bool bGetCarlifeIOSFeatureSupport();

      private:

      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/

      /*************************************************************************
       ** FUNCTION:  virtual bXmlReadNode(xmlNode *poNode)
       *************************************************************************/
      /*!
       * \fn     virtual bool bXmlReadNode(xmlNode *poNode)
       * \brief  virtual function to read data from a xml node
       * \param  poNode : [IN] pointer to xml node
       * \retval bool : true if success, false otherwise.
       *************************************************************************/
      virtual t_Bool bXmlReadNode(xmlNodePtr poNode);

      //! Following member variables store the settings read from xml file
      //! Selection mode for automatic device selection
      std::map<tenDeviceCategory, tenDeviceSelectionMode>  m_mapenSelMode;

      //! Selection mode Priority
      tenSelModePriority m_enSelPrority;

      //! Storage path for Device History
      t_String m_szPerStoragePath;

      //! Size of Device History
      t_U32 m_u32DevHistorySize;

      //! XML validation 
      t_Bool m_bXMLValidationEnabled;

      //! Certificate type
      tenCertificateType m_enCertificateType;

      //! mySPIN App Info
      trMySPINAppInfo m_rMySPINAppInfo;

      //!technology preference
      tenDeviceCategory m_enAndroidDevicePreference;
      tenDeviceCategory m_enAppleDevicePreference;

      //!String to store the path to the device exclusion list
      t_String m_szDeviceExclusionListPath;

      //!String to store the path to the device inclusion list
      t_String m_szDeviceInclusionListPath;

      tenDeviceSelectionMode m_enStoredSelectionMode;

      tenDeviceCategory m_enAndroidDevicePreferencefromDatapool;
      tenDeviceCategory m_enAppleDevicePreferencefromDatapool;

      t_Bool m_bIsCarlifeIOSEnabled;

};
/*! } */
#endif // SPI_CONNSETTINGS_H_
