/***********************************************************************/
/*!
* \file  spi_tclAppSettings.h
* \brief Class to get the App Mngr Settings
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class to get the App Mngr Settings
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
16.02.2014  | Shiva Kumar Gurija    | Initial Version
23.04.2014  | Shiva Kumar Gurija    | Updated with the elements for Notifications&
                                       CTS Testing
29.04.2014  | Shiva Kumar Gurija    | Changes for Locale Mapping
13.05.2014  | Ramya Murthy          | Implemented persistent Notification on/off 
                                      setting using Datapool.

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLAPPMNGRSETTINGS_H_
#define _SPI_TCLAPPMNGRSETTINGS_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "Xmlable.h"
#include "Lock.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/*!
* \typedef struct rLocaleMap
* \brief This is used to map the Region enumeration value to the respective 
* string that we need to look for in the Application certification locale lists
*/
typedef struct rLocaleMap
{
   //! Internally defined ID to map the Enum value to the county code.
   tenRegion enRegion;
   //! Region name which is a part of Restricted/Non restricted list
   t_String szRegion;
}trLocaleMap;


/****************************************************************************/
/*!
* \class spi_tclAppSettings
* \brief Class to get the Video Layer Info
****************************************************************************/
class spi_tclAppSettings: public shl::xml::tclXmlReadable
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAppSettings::spi_tclAppSettings()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAppSettings()
   * \brief   Default Constructor
   * \sa      ~spi_tclAppSettings()
   **************************************************************************/
   spi_tclAppSettings();

   /***************************************************************************
   ** FUNCTION:  spi_tclAppSettings::~spi_tclAppSettings()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclAppSettings()
   * \brief   Destructor
   * \sa      spi_tclAppSettings()
   **************************************************************************/
   ~spi_tclAppSettings();



   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclAppSettings::bNonCertAppsReq()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bNonCertAppsReq()
   * \brief  To get whether the Non certified Applications are required  
   *          when the application certification is enabled for the
   *          particular version of the device.
   * \retval t_Bool
   **************************************************************************/
   t_Bool bNonCertAppsReq();




   /***************************************************************************
   ** FUNCTION:  t_String spi_tclAppSettings::szGetRegion()
   ***************************************************************************/
   /*!
   * \fn     t_String szGetRegion()
   * \brief  To Get the which regions CCC guidelines should be followed for the
   *          Application certification.
   * \retval t_String
   **************************************************************************/
   t_String szGetRegion();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppSettings::vReadAppSettings()
   ***************************************************************************/
   /*!
   * \fn     t_Void vReadAppSettings()
   * \brief  To read the settings from XML
   * \retval t_Void
   **************************************************************************/
   t_Void vReadAppSettings();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppSettings::vDisplayAppSettings()
   ***************************************************************************/
   /*!
   * \fn     t_Void vDisplayAppSettings()
   * \brief  To print the settings
   * \retval t_Void
   **************************************************************************/
   t_Void vDisplayAppSettings();

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettings::bEnableCTSTest()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bEnableCTSTest()
   * \brief  To get whether the CTS test is enabled.
   * \retval t_Bool  TRUE- Enabled FALSE-Disabled
   **************************************************************************/
   t_Bool bEnableCTSTest();

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppSettings::vSetRegion(.)
   ***************************************************************************/
   /*!
   * \fn     t_Void vSetRegion(tenRegion enRegion)
   * \brief  Interface to set the region for application certification.
   *         It gives the info of which region CCC Guidelines should be followed
   *         for the Application Certification Filtering
   * \param  [IN] enRegion : Region enumeration
   * \sa
   **************************************************************************/
   t_Void vSetRegion(tenRegion enRegion);


   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettings::bEnableAAPNotification()()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bEnableAAPNotification(t_Bool bEnable)
   * \brief  method to enable notification updates for AAP.
   * \param  bEnable       : [IN] TRUE-allows to display notification updates
   *                         for AAP
   *                         FALSE - doesn't allow
   * \retval t_Void
   **************************************************************************/
   t_Bool bEnableAAPNotification(); //bGetAAPNotificationUpdatesEnabledInfo

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettings::bEnableAAPNavigation()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bEnableAAPNavigation(t_Bool bEnable)
   * \brief  method to enable navigation updates for AAP.
   * \param  bEnable       : [IN] TRUE-allows to display navigation updates
   *                         for AAP
   *                         FALSE - doesn't allow
   * \retval t_Void
   **************************************************************************/
   t_Bool bEnableAAPNavigation();//bGetAAPNavigationEnabledInfo

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettings::bEnableAAPMediaPlayback()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bEnableAAPMediaPlayback(t_Bool bEnable)
   * \brief  method to enable mediaplayback updates for AAP.
   * \param  bEnable       : [IN] TRUE-allows to display mediaplayback updates
   *                         for AAP
   *                         FALSE - doesn't allow
   * \retval t_Void
   **************************************************************************/
   t_Bool bEnableAAPMediaPlayback();//bGetAAPMediaPlaybackEnabledInfo

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettings::bGetTBTUpdatesEnabledInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetTBTUpdatesEnabledInfo()
   * \brief  Provides information on whether TBT updates are enabled or disabled.
   * \retval t_Bool TRUE- Enabled FALSE-Disabled
   **************************************************************************/
   t_Bool bGetTBTUpdatesEnabledInfo();

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettings::bGetAssisstantGuideUpdatesEnabledInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetAssisstantGuideUpdatesEnabledInfo()
   * \brief  Provides information on whether Assisstant Guide updates are enabled
   *         or disabled.
   * \retval t_Bool TRUE- Enabled FALSE-Disabled
   **************************************************************************/
   t_Bool bGetAssisstantGuideUpdatesEnabledInfo();

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettings::bGetNonCertAppAllowedInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetNonCertAppAllowedInfo()
   * \brief  Provides information on whether non certified ML apps are allowed 
   *         in all modes(drive/park)
   * \retval t_Bool TRUE- Allowed FALSE-Not allowed
   **************************************************************************/
   t_Bool bGetNonCertAppAllowedInfo();   

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/



   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

private:
   /*************************************************************************
   ** FUNCTION:  virtual bXmlReadNode(xmlNode *poNode)
   *************************************************************************/
   /*!
   * \fn     virtual bool bXmlReadNode(xmlNode *poNode)
   * \brief  virtual function to read data from a xml node
   * \param  poNode : [IN] pointer to xml node
   * \retval bool : true if success, false otherwise.
   *************************************************************************/
   virtual t_Bool bXmlReadNode(xmlNodePtr poNode);

   //! Region - It specifies, which regions guidelines should be followed for the 
   //  App certification
   t_String m_szRegion;

   //Lock object for Region
   Lock m_oRegionLock;



   //! FilterNonCertApps
   t_Bool m_bNonCertAppsReq;
   //! To set the whether the CTS Testing is required or project setup
   t_Bool m_bEnableCTSTest;


   //! To enable navigation updates for Android Auto
   t_Bool m_bEnableAAPNavigation;

   //! To enable notification for Android Auto
   t_Bool m_bEnableAAPNotification;

   //! To enable mediaplayback updates for Android Auto
   t_Bool m_bEnableAAPMediaPlayback;

   //! To enable TurnByTurn updates for CP, AA, BDCL
   t_Bool m_bEnableTBTUpdates;

   //! To enable Assistant Guide updates for BDCL
   t_Bool m_bEnableAssistantGuideUpdates;
   
   //! To allow non certified ML apps in all modes(drive/park)
   t_Bool m_bAllowAllMLApps;

   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

}; //spi_tclAppSettings

#endif //_SPI_TCLAPPMNGRSETTINGS_H_
