/***********************************************************************/
/*!
* \file   spi_tclDynamicConfigurationReaderBase.h
* \brief  Implementation of the Class spi_tclDynamicConfigurationReaderBase
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    To read dynamic configurations from datapool...
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
             kmo6kor			    Initial Version                                               
\endverbatim
*************************************************************************/

#include <set>
#include "SPITypes.h"
#include "BaseTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLDYNAMICCONFIGURATIONREADERINTF_
#define SPI_TCLDYNAMICCONFIGURATIONREADERINTF_

class spi_tclDynamicConfigurationReaderBase
{
      /***************************************************************************
      *********************************PUBLIC*************************************
      ***************************************************************************/
public:
   /***************************************************************************
	** FUNCTION:spi_tclDynamicConfigurationReaderBase::spi_tclDynamicConfigurationReaderBase()
	***************************************************************************/
   /*!
	* \fn      spi_tclDynamicConfigurationReaderBase()
	* \brief   Constructor
	* \param   None
	**************************************************************************/
   spi_tclDynamicConfigurationReaderBase(){};

   /***************************************************************************
	** FUNCTION:spi_tclDatapoolReaderIntf::~spi_tclDynamicConfigurationReaderBase()
	***************************************************************************/
   /*!
	* \fn      ~spi_tclDynamicConfigurationReaderBase()
	* \brief   Destructor
	* \param   None
	**************************************************************************/
   virtual ~spi_tclDynamicConfigurationReaderBase(){};

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDynamicConfigurationReaderBase::bReadMLEnableSetting()
   ***************************************************************************/
   /*!
   * \fn      bReadMLEnableSetting
   * \brief   Provides MirrorLink On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo bReadMLEnableSetting() const { return e8USAGE_UNKNOWN; } ;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDynamicConfigurationReaderBase::bReadDipoEnableSetting()
   ***************************************************************************/
   /*!
   * \fn      bReadDipoEnableSetting
   * \brief   Provides DiPO On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo bReadDipoEnableSetting() const { return e8USAGE_UNKNOWN;};

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDynamicConfigurationReaderBase::bReadAAPEnableSetting()
   ***************************************************************************/
   /*!
   * \fn      bReadAAPEnableSetting
   * \brief   Provides AAP On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo bReadAAPEnableSetting() const {return e8USAGE_UNKNOWN; };

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDynamicConfigurationReaderBase::bReadmySPINEnableSetting()
   ***************************************************************************/
   /*!
   * \fn      bReadmySPINEnableSetting
   * \brief   Provides mySPIN On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo bReadmySPINEnableSetting()const { return e8USAGE_UNKNOWN; };

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDynamicConfigurationReaderBase::bReadCarlifeEnableSetting()
   ***************************************************************************/
   /*!
   * \fn      bReadCarlifeEnableSetting
   * \brief   Provides Carlife On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo bReadCarlifeEnableSetting() const { return e8USAGE_UNKNOWN; };

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDynamicConfigurationReaderBase::enReadOnCarEnableSetting()
   ***************************************************************************/
   /*!
   * \fn      enReadOnCarEnableSetting
   * \brief   Provides OnCar On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo enReadOnCarEnableSetting() const { return e8USAGE_UNKNOWN; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadMLNotificationSetting()
   ***************************************************************************/
   /*!
   * \fn      bReadMLNotificationSetting
   * \brief   Provides MirrorLink Notification On/Off setting value
   *          stored in Datapool.
   * \param   None
   * \retval  t_Bool: true if enabled
   ***************************************************************************/
   virtual t_Bool bReadMLNotificationSetting() const { return false; };

   /***************************************************************************
   ** FUNCTION:  t_U8 spi_tclDynamicConfigurationReaderBase::u8ReadVirginStartSetting()
   ***************************************************************************/
   /*!
   * \fn      u8ReadVirginStartSetting
   * \brief   Provides Virgin start setting values
   *          stored in Datapool.
   * \param   None
   * \retval  t_U8
   ***************************************************************************/
   virtual t_U8 u8ReadVirginStartSetting() const { return 0;};

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteMLEnableSetting
   ***************************************************************************/
   /*!
   * \fn      bWriteMLEnableSetting
   * \brief   Sets the MirrorLink On/Off setting value in datapool.
   * \param   [IN] enMirrorLinkEnable :
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteMLEnableSetting(tenEnabledInfo /*enMirrorLinkEnable*/) { return false; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteDipoEnableSetting
   ***************************************************************************/
   /*!
   * \fn      bWriteDipoEnableSetting(t_Bool bDipoEnable)
   * \brief   Sets the DiPO On/Off setting value in datapool.
   *          (True - if enabled, else False)
   * \param   [IN] enDipoLinkEnable :
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteDipoEnableSetting(tenEnabledInfo /*enDipoLinkEnable*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteAAPEnableSetting
   ***************************************************************************/
   /*!
   * \fn      bWriteAAPEnableSetting(t_Bool bAAPEnable)
   * \brief   Sets the DiPO On/Off setting value in datapool.
   *          (True - if enabled, else False)
   * \param   [IN] enAAPLinkEnable :
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteAAPEnableSetting(tenEnabledInfo /*enAAPLinkEnable*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWritemySPINEnableSetting
   ***************************************************************************/
   /*!
   * \fn      bWritemySPINEnableSetting(t_Bool bmySPINEnable)
   * \brief   Sets the mySPIN On/Off setting value in datapool.
   *          (True - if enabled, else False)
   * \param   [IN] enmySPINLinkEnable :
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWritemySPINEnableSetting(tenEnabledInfo /*enmySPINLinkEnable*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteCarlifeEnableSetting
   ***************************************************************************/
   /*!
   * \fn      bWriteCarlifeEnableSetting(t_Bool bCarlifeEnable)
   * \brief   Sets the Carlife On/Off setting value in datapool.
   *          (True - if enabled, else False)
   * \param   [IN] enCarlifeLinkEnable :
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteCarlifeEnableSetting(tenEnabledInfo /*enCarlifeLinkEnable*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteMLNotificationSetting(t_Bool...)
   ***************************************************************************/
   /*!
   * \fn      bWriteMLNotificationSetting
   * \brief   Sets the MirrorLink Notification On/Off setting value in datapool.
   *          (True - if enabled, else False)
   * \param   [IN] bNotificationEnabled :
   *               True - to set Notfications as enabled
   *               False - to set Notfications as disabled
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteMLNotificationSetting(t_Bool /*bNotificationEnabled*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_U8 spi_tclDynamicConfigurationReaderBase::u8WriteVirginStartSetting(t_Bool...)
   ***************************************************************************/
   /*!
   * \fn      u8WriteVirginStartSetting
   * \brief   Sets the default value at Virgin Start in datapool.
   * \param   [IN] u8VirginStart : Default value to be set at Virgin Start
   * \retval  t_U8
   ***************************************************************************/
   virtual t_U8 u8WriteVirginStartSetting(t_U8 /*u8VirginStart*/) { return 0 ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteBluetoothMacAddress(t_String...)
   ***************************************************************************/
   /*!
   * \fn      bWriteBluetoothMacAddress
   * \brief   Set the accessory bluetooth statck MAC address
   * \param   [IN] szBluetoothMacAddr : Bluetooth MAC address.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteBluetoothMacAddress(t_String & /*szBluetoothMacAddr*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadBluetoothMacAddress(t_String...)
   ***************************************************************************/
   /*!
   * \fn      bReadBluetoothMacAddress
   * \brief   To read the accessory bluetooth statck MAC address
   * \param   [OUT] szBluetoothMacAddr : Bluetooth MAC address.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bReadBluetoothMacAddress(t_String & /*szBluetoothMacAddr*/){ return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteScreenAttributes()
   ***************************************************************************/
   /*!
   * \fn      bWriteScreenAttributes(const trDisplayAttributes& corfrDispAttr)
   * \brief   To write screen attributes to data pool
   * \param   [IN] corfrDispAttr : Screen Attributes
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteScreenAttributes(const trDisplayAttributes& /*corfrDispAttr*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadScreenAttributes()
   ***************************************************************************/
   /*!
   * \fn      bReadScreenAttributes(trDisplayAttributes& rfrDispAttr)
   * \brief   To read screen attributes from data pool
   * \param   [IN] rfrDispAttr : Screen Attributes
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bReadScreenAttributes(trDisplayAttributes& /*rfrDispAttr*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadDiPODriveRestrictionInfo()
   ***************************************************************************/
   /*!
   * \fn      bReadDiPODriveRestrictionInfo(t_U8 &cu8DiPORestrictionInfo)
   * \brief   To read DiPO drive restriction info from data pool
   * \param   [OUT] cu8DiPORestrictionInfo : Restriction info.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bReadDiPODriveRestrictionInfo(t_U8 & /*cu8DiPORestrictionInfo*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteDiPODriveRestrictionInfo()
   ***************************************************************************/
   /*!
   * \fn      bWriteDiPODriveRestrictionInfo(trDisplayAttributes& rfrDispAttr)
   * \brief   To write DiPO drive restriction info from data pool
   * \param   [IN] cu8DiPORestrictionInfo : Restriction info.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteDiPODriveRestrictionInfo(t_U8 /*cu8DiPORestrictionInfo*/){ return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadAAPGeneralRestrictionInfo()
   ***************************************************************************/
   /*!
   * \fn      bReadAAPGeneralRestrictionInfo(t_U16 u16GeneralRestrictionInfo)
   * \brief   To read AAP general restriction info from data pool
   * \param   [IN] cu8DiPOGeneralRestrictionInfo : AAP General Restriction info.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bReadAAPGeneralRestrictionInfo(t_U16 & /*cu8DiPOGeneralRestrictionInfo*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteGeneralRestrictionInfo()
   ***************************************************************************/
   /*!
   * \fn      bWriteGeneralRestrictionInfo(t_U16 u16GeneralRestrictionInfo)
   * \brief   To write AAP general restriction info from data pool
   * \param   [IN] u16GeneralRestrictionInfo : General Restriction info.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteAAPGeneralRestrictionInfo(t_U16 /*u16GeneralRestrictionInfo*/){ return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadDipoGeneralRestrictionInfo()
   ***************************************************************************/
   /*!
   * \fn      bReadDipoGeneralRestrictionInfo(t_U16 &cu8DipoGeneralRestrictionInfo)
   * \brief   To read Dipo general restriction info from data pool
   * \param   [IN] cu8DipoGeneralRestrictionInfo : Dipo General Restriction info.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bReadDipoGeneralRestrictionInfo(t_U16 & /*cu8DipoGeneralRestrictionInfo*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteDipoGeneralRestrictionInfo()
   ***************************************************************************/
   /*!
   * \fn      bWriteDipoGeneralRestrictionInfo(t_U16 u16DipoGeneralRestrictionInfo)
   * \brief   To write Dipo general restriction info from data pool
   * \param   [IN] u16DipoGeneralRestrictionInfo : Dipo General Restriction info.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteDipoGeneralRestrictionInfo(t_U16 /*u16DipoGeneralRestrictionInfo*/) { return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadDriveSideInfo()
   ***************************************************************************/
   /*!
   * \fn      bReadDriveSideInfo(tenDriveSideInfo &rfenDriveSideInfo)
   * \brief   To read drive side position information.
   * \param   [OUT] rfenDriveSideInfo : Drive side information.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bReadDriveSideInfo(tenDriveSideInfo & /*rfenDriveSideInfo*/){ return false ; };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteDriveSideInfo()
   ***************************************************************************/
   /*!
   * \fn      bWriteDriveSideInfo(tenDriveSideInfo enDriveSideInfo)
   * \brief   Function to write the drive side information
   * \param   [IN] enDriveSideInfo : Drive side information.
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteDriveSideInfo(const tenDriveSideInfo /*enDriveSideInfo*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadVehicleId()
    ***************************************************************************/
   /*!
    * \fn      bReadVehicleId()
    * \brief   Function to read the Vehicle Id information
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadVehicleId(t_String & /*szVehicleIdentifierentifier*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteVehicleId()
    ***************************************************************************/
   /*!
    * \fn      bWriteVehicleId()
    * \brief   Function to write the Vehicle Id information
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteVehicleId(t_String & /*szVehicleIdentifierentifier*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteSelectionMode()
    ***************************************************************************/
   /*!
    * \fn      bWriteSelectionMode()
    * \brief   Function to write the SelectionMode
    * \param   [IN] enSelectionMode : Device selection mode
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteSelectionMode(tenDeviceSelectionMode /*enSelectionMode*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadSelectionMode()
    ***************************************************************************/
   /*!
    * \fn      bReadSelectionMode()
    * \brief   Function to write the SelectionMode
    * \param   [OUT] enSelectionMode : Device selection mode
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadSelectionMode(tenDeviceSelectionMode & /*enSelectionMode*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadSPIVersion()
    ***************************************************************************/
   /*!
    * \fn      bReadSPIVersion()
    * \brief   Function to read the SPI Version information
    * \param   [OUT] szSPIVersion : SPI Version
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadSPIVersion(t_String & /*szSPIVersion*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteSPIVersion()
    ***************************************************************************/
   /*!
    * \fn      bWriteSPIVersion()
    * \brief   Function to write the SPI Version information
    * \param   [IN] szSPIVersion : SPI Version
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteSPIVersion(t_String /*szSPIVersion*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteVehicleManufacturerInformation()
    ***************************************************************************/
   /*!
    * \fn      bWriteVehicleManufacturerInformation()
    * \brief   Function to write Vehicle Manufacturer information
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteVehicleManufacturerInformation(const trVehicleManufacturerInformation& /*corfrVehicleManufacturerInformation*/)
   { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadVehicleManufacturerInformation()
    ***************************************************************************/
   /*!
    * \fn      bReadVehicleManufacturerInformation()
    * \brief   Function to Read Vehicle Manufacturer information
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadVehicleManufacturerInformation(trVehicleManufacturerInformation& /*rfrVehicleManufacturerInformation*/)
   { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteDisplayLastMode()
    ***************************************************************************/
   /*!
    * \fn      bWriteDisplayLastMode()
    * \brief   Function to write display last mode before ignition cycle
    * \param   corfbDispLastMode: [IN] display last mode before ignition off
    *                                  true: Projection, false: Native
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteDisplayLastMode(const t_Bool& /*corfbDispLastMode*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDynamicConfigurationReaderBase::vReadDisplayLastMode()
    ***************************************************************************/
   /*!
    * \fn      vReadDisplayLastMode(t_Bool& rbDispLastMode)
    * \brief   Function to read display last mode before ignition cycle
    * \retval  t_Void
    ***************************************************************************/
   virtual t_Void vReadDisplayLastMode(t_Bool& /*rbDispLastMode*/) {};

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteAudioLastMode()
    ***************************************************************************/
   /*!
    * \fn      bWriteAudioLastMode()
    * \brief   Function to write audio last mode before ignition cycle
    * \param   corfbAudioLastMode: [IN] audio last mode before ignition off
    *                                   true: Projection, false: Native
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteAudioLastMode(const t_Bool& /*corfbAudioLastMode*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDynamicConfigurationReaderBase::vReadAudioLastMode()
    ***************************************************************************/
   /*!
    * \fn      vReadAudioLastMode(t_Bool& rbAudioLastMode)
    * \brief   Function to read audio last mode before ignition cycle
    * \retval  t_Void
    ***************************************************************************/
   virtual t_Void vReadAudioLastMode(t_Bool& /*rbAudioLastMode*/) {};

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteAndroidDeviceTechnologyPreference()
    ***************************************************************************/
   /*!
    * \fn      bWriteAndroidDeviceTechnologyPreference()
    * \brief   Function to write the Android Device TechnologyPreference
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteAndroidDeviceTechnologyPreference(const tenDeviceCategory /*coenTechnologyPreference*/) {{ return false ; }};

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadAndroidDeviceTechnologyPreference()
    ***************************************************************************/
   /*!
    * \fn      bReadAndroidDeviceTechnologyPreference()
    * \brief   Function to read Android Device the TechnologyPreference
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadAndroidDeviceTechnologyPreference(tenDeviceCategory & /*enTechnologyPreference*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteAppleDeviceTechnologyPreference()
    ***************************************************************************/
   /*!
    * \fn      bWriteAppleDeviceTechnologyPreference()
    * \brief   Function to write the Apple Device TechnologyPreference
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bWriteAppleDeviceTechnologyPreference(const tenDeviceCategory /*coenTechnologyPreference*/) { return false ; };

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bReadAppleDeviceTechnologyPreference()
    ***************************************************************************/
   /*!
    * \fn      bReadAppleDeviceTechnologyPreference()
    * \brief   Function to read Apple Device the TechnologyPreference
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadAppleDeviceTechnologyPreference(tenDeviceCategory & /*enTechnologyPreference*/) { return false ; };


   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteOnCarEnableSetting
   ***************************************************************************/
   /*!
   * \fn      bWriteOnCarEnableSetting(tenEnabledInfo enOnCarLinkEnable)
   * \brief   Sets the OnCar On/Off setting value in datapool.
   *          (True - if enabled, else False)
   * \param   [IN] enOnCarLinkEnable :
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteOnCarEnableSetting(tenEnabledInfo /*enOnCarLinkEnable*/){return false ;};
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDynamicConfigurationBase::szGetSoftwareVersion()
   ***************************************************************************/
      /*!
       * \fn      szGetSoftwareVersion()
       * \brief   Function to get software version
       * \retval  t_String
   **************************************************************************/
   virtual t_String szGetSoftwareVersion()
   {
      t_String swVersion= "XXX";
      return swVersion; //Returning a dummy swVersion, to avoid Coverity Warning.
   };

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationReaderBase::bWriteHardKeyInfo()
   ***************************************************************************/
   /*!
   * \fn     bWriteHardKeyInfo()
   * \brief  Function to Write hard keyinfo for technology
   * \param  corfrsetSuppHardKeys:[IN] Keys Supported
   * \param  enDeviceCategory:[IN] Device Category
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bWriteHardKeyInfo(const std::set<tenKeyCode>& corfrsetSuppHardKeys,
                                    tenDeviceCategory enDeviceCategory) 
   {
      SPI_INTENTIONALLY_UNUSED(corfrsetSuppHardKeys);
      SPI_INTENTIONALLY_UNUSED(enDeviceCategory);
      return false;
   }

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDynamicConfigurationBase::bWriteSoftKeyInfo()
   ***************************************************************************/
   /*!
   * \fn      bWriteSoftKeyInfo()
   * \brief   Function to Write Soft Key Info into data pool
   * \param  corfrsetSuppSoftKeys:[IN] Keys Supported
   * \param  enDeviceCategory:[IN] Device Category
   * \retval  t_Bool
   ***************************************************************************/
   virtual t_Bool bWriteSoftKeyInfo(const std::set<tenKeyCode>& corfrsetSuppSoftKeys,
                               tenDeviceCategory enDeviceCategory)
   {
      SPI_INTENTIONALLY_UNUSED(corfrsetSuppSoftKeys);
      SPI_INTENTIONALLY_UNUSED(enDeviceCategory);
      return false;
   }

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDynamicConfigurationReaderBase::vReadKeyCodeInfo()
   ***************************************************************************/
   /*!
   * \fn     vReadKeyCodeInfo()
   *\brief  Function to Read the KeyInfo.
   * \param  rfrsetKeyCodes:[OUT] Keys supported
   * \param  enCategory:[IN] For Which Technology
   * \retval  None
   **************************************************************************/
   virtual t_Bool bReadKeyCodeInfo(std::set<tenKeyCode>& rfrsetKeyCodes,tenDeviceCategory enCategory)
   {
      SPI_INTENTIONALLY_UNUSED(rfrsetKeyCodes);
      SPI_INTENTIONALLY_UNUSED(enCategory); 
      return false;
   }

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDynamicConfigurationReaderBase::vReadSoftKeyInfo()
   ***************************************************************************/
   /*!
   * \fn     vReadSoftKeyCodeInfo()
   *\brief  Function to Read Soft KeyInfo.
   * \param  rfrsetKeyCodes:[OUT] Keys supported
   * \param  enCategory:[IN] For Which Technology
   * \retval  None
   **************************************************************************/
   virtual t_Bool bReadSoftKeyInfo(std::set<tenKeyCode>& rfrsetKeyCodes,tenDeviceCategory enCategory)
   { 
      SPI_INTENTIONALLY_UNUSED(rfrsetKeyCodes);
      SPI_INTENTIONALLY_UNUSED(enCategory);
      return false;
   }

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/


protected:
      /***************************************************************************
      *********************************PROTECTED**********************************
      ***************************************************************************/



      /***************************************************************************
      ****************************END OF PROTECTED********************************
      ***************************************************************************/
private:
      /***************************************************************************
      *********************************PRIVATE************************************
      ***************************************************************************/
      /***************************************************************************
      ****************************END OF PRIVATE *********************************
      ***************************************************************************/

};
#endif //SPI_TCLDYNAMICCONFIGURATIONREADERINTF_
