/*!
 *******************************************************************************
 * \file             spi_tclFactory.h
 * \brief            Object Factory class responsible for creation of SPI Objects
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Object Factory class responsible for creation of SPI Objects
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 17.01.2014 |  Pruthvi Thej Nagaraju       | Initial Version
 13.02.2014 |  Shihabudheen P M            | Added 1.poGetMainAppInstance().
 2.vInitialize()
 04.03.2014 |  Shihabudheen P M            | Added    1.poGetIPCMsgQInstance()
 Modified 1.spi_tclFactory()
 06.04.2014 |  Ramya Murthy                | Initialisation sequence implementation  
 31.07.2014 |  Ramya Murthy                | SPI feature configuration via LoadSettings()   

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLMANAGER_H_
#define SPI_TCLMANAGER_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"
//@todo - Issue - bpstl ambiguous usage should be removed

#include "GenericSingleton.h"
#include "spi_tclConnMngr.h"
#include "spi_tclAppMngr.h"
#include "spi_tclVideo.h"
#include "spi_tclAudio.h"
#include "spi_tclInputHandler.h"
#include "spi_tclBluetooth.h"
#include "spi_tclDataService.h"
#include "spi_tclLifeCycleIntf.h"
#include "spi_tclResourceMngr.h"
#include "spi_tclLegalDisclaimer.h"
#include "spi_tclTechnologySelector.h"
#include "spi_tclDeviceListHandler.h"
#include "spi_tclWiFi.h"
#include "spi_tclDeviceDiscoverer.h"
#include "SPIDatabaseSQLite3.h"
#include "spi_tclConfigurationManager.h"
#include "spi_tclUSBDiscovererIntf.h"
#include "spi_tclCommonSettingsIntf.h"
#include "spi_tclDevHistory.h"

#include "spi_tclDiagnosis.h"
class spi_tclDeviceSelector;

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

//!Forward declaration
class spi_tclRespInterface;
class spi_tclDefSetLoader;
class spi_tclWiFiSetupHndlr;
class spi_tclAppLauncher;

/*!
 * \class spi_tclConnSettings
 * \brief Response  to HMI  from ConnMngr class
 */

class spi_tclFactory: public GenericSingleton<spi_tclFactory>, public spi_tclLifeCycleIntf
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclFactory::~spi_tclFactory
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclFactory()
       * \brief  Destructor
       **************************************************************************/
      ~spi_tclFactory();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclFactory::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Method to Initialize
       * \sa      bUnInitialize()
       **************************************************************************/
      virtual t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclFactory::bUnInitialize()
       ***************************************************************************/
      /*!
       * \fn      bUnInitialize()
       * \brief   Method to UnInitialize
       * \sa      bInitialize()
       **************************************************************************/
      virtual t_Bool bUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclFactory::vLoadSettings()
       ***************************************************************************/
      /*!
       * \fn      vLoadSettings()
       * \brief   vLoadSettings Method. Invoked during OFF->NORMAL state transition.
       * \sa      vSaveSettings()
       **************************************************************************/
      virtual t_Void vLoadSettings();

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclFactory::vSaveSettings()
       ***************************************************************************/
      /*!
       * \fn      vSaveSettings()
       * \brief   vSaveSettings Method. Invoked during  NORMAL->OFF state transition.
       * \sa      vLoadSettings()
       **************************************************************************/
      virtual t_Void vSaveSettings();

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclFactory::vRestoreSettings()
       ***************************************************************************/
      /*!
       * \fn      vRestoreSettings()
       * \brief   vRestoreSettings Method to restore settings in SPI..
       * \sa      vLoadSettings()
       **************************************************************************/
      virtual t_Void vRestoreSettings();

      /***************************************************************************
       ** FUNCTION:  spi_tclFactory::vRegisterCommonSettingCallbacks
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks()
       * \brief  interface for the creator class to register for the required
       *        callbacks.
       * \param rfrConnCallbacks : reference to the callback structure
       *        populated by the caller
       **************************************************************************/
      t_Void vRegisterCommonSettingCallbacks(trCmdInterfaceCallback &rfrCmdInterfaceCallback);

      /***************************************************************************
       ** FUNCTION:  spi_tclConnMngr* spi_tclFactory::poGetConnMngrInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclConnMngr* poGetConnMngrInstance()
       * \brief  returns connection manager instance
       **************************************************************************/
      spi_tclConnMngr* poGetConnMngrInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclVideo* spi_tclFactory::poGetVideoInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclVideo* poGetVideoInstance()
       * \brief  returns Video instance
       **************************************************************************/
      spi_tclVideo* poGetVideoInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclMLAppMngr* spi_tclFactory::poGetAppManagerInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclMLAppMngr* poGetAppManagerInstance()
       * \brief  returns appmanager instance
       **************************************************************************/
      spi_tclAppMngr* poGetAppManagerInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclAudio* spi_tclFactory::poGetAudioInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclAudio* poGetAudioInstance()
       * \brief   returns audio instance
       **************************************************************************/
      spi_tclAudio* poGetAudioInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclInputHandler* spi_tclFactory::poGetInputHandlerInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclInputHandler* poGetInputHandlerInstance()
       * \brief  returns Input Handler instance
       **************************************************************************/
      spi_tclInputHandler* poGetInputHandlerInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclBluetooth* spi_tclFactory::poGetBluetoothInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclBluetooth* poGetBluetoothInstance()
       * \brief   returns Bluetooth instance
       **************************************************************************/
      spi_tclBluetooth* poGetBluetoothInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclDataService* spi_tclFactory::poGetDataServiceInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclDataService* poGetDataServiceInstance()
       * \brief   returns Data Service instance
       **************************************************************************/
      spi_tclDataService* poGetDataServiceInstance();

      /***************************************************************************
       ** FUNCTION:  ahl_tclBaseOneThreadApp* spi_tclFactory::poGetMainAppInstance
       ***************************************************************************/
      /*!
       * \fn     ahl_tclBaseOneThreadApp* poGetMainAppInstance()
       * \brief  returns Main application instance.
       **************************************************************************/
      ahl_tclBaseOneThreadApp* poGetMainAppInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclResourceMngr* spi_tclFactory::poGetRsrcMngrInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclResourceMngr* poGetRsrcMngrInstance()
       * \brief  returns Resource manager instance
       **************************************************************************/
      spi_tclResourceMngr* poGetRsrcMngrInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer* spi_tclFactory::poGetLegalDiscInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclLegalDisclaimer* poGetLegalDiscInstance()
       * \brief  returns Legal disclaimer instance
       **************************************************************************/
      spi_tclLegalDisclaimer* poGetLegalDiscInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclTechnologySelector* spi_tclFactory::poGetTechnologySelectorInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclTechnologySelector* poGetTechnologySelectorInstance()
       * \brief  returns Technology Selector instance
       **************************************************************************/
      spi_tclTechnologySelector* poGetTechnologySelectorInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSelector* spi_tclFactory::poGetDeviceSelector
       ***************************************************************************/
      /*!
       * \fn     spi_tclDeviceSelector* poGetDeviceSelector()
       * \brief  returns deviceselector instance
       **************************************************************************/
      spi_tclDeviceSelector* poGetDeviceSelector();

      /***************************************************************************
       ** FUNCTION:  spi_tclWiFi* spi_tclFactory::poGetWiFiInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclWiFi* poGetWiFiInstance()
       * \brief   returns WiFi instance
       **************************************************************************/
      spi_tclWiFi* poGetWiFiInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceDiscoverer* spi_tclFactory::poGetDeviceDiscoverer
       ***************************************************************************/
      /*!
       * \fn     spi_tclDeviceDiscoverer* poGetDeviceDiscoverer()
       * \brief  returns DeviceDiscoverer instance
       **************************************************************************/
      spi_tclDeviceDiscoverer* poGetDeviceDiscoverer();

      /***************************************************************************
       ** FUNCTION:  spi_tclAppLauncher* spi_tclFactory::poGetAppLauncherInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclAppLauncher* poGetAppLauncherInstance()
       * \brief   returns AppLauncher instance
       **************************************************************************/
      spi_tclAppLauncher* poGetAppLauncherInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclWiFiSetupHndlr* spi_tclFactory::poGetWiFiSetupHndlrInstance
       ***************************************************************************/
      /*!
       * \fn     spi_tclWiFiSetupHndlr* poGetWiFiSetupHndlrInstance()
       * \brief   returns AppLauncher instance
       **************************************************************************/
      spi_tclWiFiSetupHndlr* poGetWiFiSetupHndlrInstance();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclFactory::vLoadSettingsCompleted(...)
       ***************************************************************************/
      /*!
       * \fn     vLoadSettingsCompleted()
       * \brief  Invoked to notify that LoadSettings has completed.
       **************************************************************************/
      t_Void vLoadSettingsCompleted();

   private:
      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/
      friend class GenericSingleton<spi_tclFactory> ;

      /***************************************************************************
       ** FUNCTION:  spi_tclFactory::spi_tclFactory
       ***************************************************************************/
      /*!
       * \fn     spi_tclFactory()
       * \brief  Default Constructor
       **************************************************************************/
      spi_tclFactory();

      /***************************************************************************
       ** FUNCTION:  spi_tclFactory::spi_tclFactory
       ***************************************************************************/
      /*!
       * \fn     spi_tclFactory()
       * \brief  Parameterized  Constructor
       * \param  poRespInterface: pointer to response interface
       * \param  poMainAppl: pointer to main application
       **************************************************************************/
      spi_tclFactory(spi_tclRespInterface* poRespInterface, ahl_tclBaseOneThreadApp* poMainAppl);
#ifdef VARIANT_S_FTR_ENABLE_SPI_MIRRORLINK
      typedef void InitializeMLDynamicLibrary_t();
      void* m_poDynMLLibrary;
#endif
      /*!
       * Pointer to tResponse interface class object
       */
      spi_tclRespInterface *m_poRespInterface;

      /*!
       * Pointer to connection manager class object
       */
      spi_tclConnMngr *m_poConnMngr;

      /*!
       * spi_tclVideo member variable
       */
      spi_tclVideo* m_poVideo;

      /*!
       * spi_tclAppManager member variable
       */
      spi_tclAppMngr* m_poAppMngr;

      /*!
       * spi_tclAudio member variable
       */
      spi_tclAudio* m_poAudio;

      /*!
       * spi_tclInputHandler member variable
       */
      spi_tclInputHandler* m_poInputHandler;

      /*!
       * spi_tclBluetooth member variable
       */
      spi_tclBluetooth* m_poBluetooth;

      /*!
       * spi_tclDataService member variable
       */
      spi_tclDataService* m_poDataService;

      /*!
       * spi main app pointer
       */
      ahl_tclBaseOneThreadApp* m_poMainApp;

      /*!
       * Resource manager member variable
       */
      spi_tclResourceMngr* m_poRsrcMngr;

      /*!
       * Legal disclaimer instance
       */
      spi_tclLegalDisclaimer* m_poLegalDisclaimer;

      /*!
       *Technology selector instance
       */
      spi_tclTechnologySelector* m_poTechnologySelector;

      /*!
       * Devicelist handler instance
       */
      spi_tclDeviceListHandler* m_poDeviceListHandler;

      spi_tclDeviceSelector* m_poDeviceSelector;

      /*!
       * spi_tclWiFi member variable
       */

      spi_tclWiFi* m_poWiFi;

      spi_tclDeviceDiscoverer* m_poDeviceDiscoverer;

      /*!

       *SPIDatabaseSQlite3 member Variable
       */
      SPIDatabaseSQLite3 *m_poSQLite3db;

      spi_tclConfigurationManager* m_poConfigurationManager;

      //! Pointer object of Appplication launch/terminate class
      spi_tclAppLauncher* m_poLaunchApp;

      //! Pointer to default settings loader
      spi_tclDefSetLoader* m_poDefSet;

      //! Pointer to WifiSetupHndlr
      spi_tclWiFiSetupHndlr* m_poWifiSetupHndlr;

      //! Pointer to spi_tclUSBDiscovererImpl
      spi_tclUSBDiscovererIntf *m_poUSBDiscoverer;

      //! Pointer to spi_tclDeviceSwitcher
      spi_tclDeviceSwitcherIntf *m_poDeviceSwitcher;

      //member object for trCmdInterfaceCallback callback
      trCmdInterfaceCallback m_rCmdInterfaceCallback;

      spi_tclDiagnosis* m_poDiagnosis;

      //!Pointer object of DevHistory 
      spi_tclDevHistory* m_poDevHistory;

};

#endif /* SPI_TCLMANAGER_H_ */
