  /*!
 *******************************************************************************
 * \file         spi_tclWiFiSetupHndlr.cpp
 * \brief        Wifi Manager class that provides interface to delegate
                 the execution of command and handle response
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Wifi Manager class for SPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                           | Modifications
12.12.2016  |  Unmukt Jain (RBEI/ECP2)          | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

#include "spi_tclFactory.h"
#include "spi_tclBluetooth.h"
#include "spi_tclWiFi.h"
#include "spi_tclExtCompManager.h"
#include "spi_tclMediator.h"
#include "spi_tclWiFiSetupHndlr.h"


#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_WIFI
      #include "trcGenProj/Header/spi_tclWiFiSetupHndlr.cpp.trc.h"
   #endif
#endif

static const t_Bool scobUserDeselectonHMIInitiateWireless = false;

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/

/***************************************************************************
** FUNCTION:  spi_tclWiFiSetupHndlr::spi_tclWiFiSetupHndlr();
***************************************************************************/
spi_tclWiFiSetupHndlr::spi_tclWiFiSetupHndlr(spi_tclWiFiSetupHndlrRespIntf *poWiFiSetupHndlrRespIntf):
      m_poWiFiSetupHndlrRespIntf(poWiFiSetupHndlrRespIntf), m_bInitiateWirelessDiscoveryRequestPending(false)
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr() entered "));
} //!end of spi_tclWiFiSetupHndlr()

/***************************************************************************
** FUNCTION:  spi_tclWiFiSetupHndlr::~spi_tclWiFiSetupHndlr();
***************************************************************************/
spi_tclWiFiSetupHndlr::~spi_tclWiFiSetupHndlr()
{
   ETG_TRACE_USR1(("~spi_tclWiFiSetupHndlr() entered "));
   m_poWiFiSetupHndlrRespIntf = NULL;
} //!end of ~spi_tclWiFiSetupHndlr()

/***************************************************************************
** FUNCTION:  t_Bool spi_tclWiFiSetupHndlr::bInitialize()
***************************************************************************/
t_Bool spi_tclWiFiSetupHndlr::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::bInitialize() entered "));

   t_Bool bInit = true;

   trWiFiSetupHndlrCallbacks rWiFiSetupHndlrCallbacks;
   
   rWiFiSetupHndlrCallbacks.fvInitiateWirelessDiscoveryResult =
		                      std::bind( &spi_tclWiFiSetupHndlr::vCbInitiateWirelessDiscoveryResult,this,
		                    		     SPI_FUNC_PLACEHOLDERS_1);
										 
   rWiFiSetupHndlrCallbacks.fvBTLimitationModeStatus =
                              std::bind( &spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult,this,
                                         SPI_FUNC_PLACEHOLDERS_1);
										 
   rWiFiSetupHndlrCallbacks.fvSendWiFiCredentials = 
                              std::bind( &spi_tclWiFiSetupHndlr::vCbPostWiFiCredentials,this,
                                         SPI_FUNC_PLACEHOLDERS_1);   
   rWiFiSetupHndlrCallbacks.fvSetBTLimModeResult =
                              std::bind( &spi_tclWiFiSetupHndlr::vCbSetBTLimModeResult,this,
                              SPI_FUNC_PLACEHOLDERS_1);



   rWiFiSetupHndlrCallbacks.fvInitiateWirelessDiscovery = std::bind(static_cast<t_Void (spi_tclWiFiSetupHndlr::*)
            (const trUserContext&,t_String, tenDeviceCategory)>
            ( &spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery), this, SPI_FUNC_PLACEHOLDERS_3 );
										 
   spi_tclMediator* poMediator = spi_tclMediator::getInstance();
   if (NULL != poMediator)
   {
	   poMediator->vRegisterCallbacks(rWiFiSetupHndlrCallbacks);
   } // if (NULL != poMediator)

   //@todo - Return value to be revisited along with startup sequence.
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
   return bInit;
} //!end of bInitialize()

/***************************************************************************
** FUNCTION:  t_Bool spi_tclWiFiSetupHndlr::bUnInitialize()
***************************************************************************/
t_Bool spi_tclWiFiSetupHndlr::bUnInitialize()
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::bUnInitialize() entered "));

   t_Bool bUninitSuccess = true;

   ETG_TRACE_USR2(("spi_tclWiFiSetupHndlr::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
   return bUninitSuccess;
} //!end of bUnInitialize()

/***************************************************************************
** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vLoadSettings()
***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vLoadSettings()
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vLoadSettings() entered "));
   //Add code
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vSaveSettings()
***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vSaveSettings()
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vSaveSettings() entered "));
   //Add code
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery()
 ***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery(const trUserContext& rfcorUsrCntxt,
         t_String szBTMACAddress,
         tenDeviceCategory enDevCategory)
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery():DevCat:%d,BTAddress:%s ",
            enDevCategory,szBTMACAddress.c_str()));

   m_szBTMACAddress = szBTMACAddress;   
   spi_tclFactory *poFactory = spi_tclFactory::getInstance();
   if(NULL != poFactory)
   {
      spi_tclWiFi *poWiFi = poFactory->poGetWiFiInstance();
      if(NULL != poWiFi)
      {
         poWiFi->vInitiateWirelessDiscovery(enDevCategory);
      }
   }

}

/***************************************************************************
** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery()
***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery(t_String szBTMACAddress,
                                     tenDeviceCategory enDevCategory,
                                     t_Bool bIsKnownDevice)
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery():DevCat:%d,bIsKnownDevice:%d,BTAddress:%s ",
   enDevCategory,ETG_ENUM(BOOL,bIsKnownDevice),szBTMACAddress.c_str()));

   ETG_TRACE_USR1(("Initiate Wireless Discovery Pending Request %d", ETG_ENUM(BOOL, m_bInitiateWirelessDiscoveryRequestPending)));

   if(false == m_bInitiateWirelessDiscoveryRequestPending)
   {
      //! set the request pending to true until the Resault is posted back to HMI for this request
      m_bInitiateWirelessDiscoveryRequestPending = true;

      vSetUserDeselect(szBTMACAddress, scobUserDeselectonHMIInitiateWireless);

      ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery(): Initiate Wireless Request can be processed"));
      m_szBTMACAddress = szBTMACAddress;

      if(false == bIsKnownDevice)
      {
         //Directly trigger BT for device connection and do not setup AP even for a fresh device.
         vCbInitiateWirelessDiscoveryResult(true);
      }
      else
      {
         spi_tclFactory *poFactory = spi_tclFactory::getInstance();
         if(NULL != poFactory)
         {
           spi_tclWiFi *poWiFi = poFactory->poGetWiFiInstance();
           if(NULL != poWiFi)
           {
             poWiFi->vInitiateWirelessDiscovery(enDevCategory, szBTMACAddress);
           }
         }
      }
   }
   else
   {
      ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery(): Initiate Wireless Request can't be processed now as there is already one request Processing is going on"));
   }

}

/***************************************************************************
** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vCbInitiateWirelessDiscoveryResult()
**************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vCbInitiateWirelessDiscoveryResult(t_Bool bResult)
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vCbInitiateWirelessDiscoveryResult() entered with bResult = %d",ETG_ENUM(BOOL,bResult)));
   t_Bool bSendInitWirelessDiscoveryResult = false;
   t_Bool bInitWirelessDiscoveryResult = false;
   if(true == bResult)
   {
      if( ( (m_rBTLimitationModeInfo.enActionState == tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREPARED) ||
               (m_rBTLimitationModeInfo.enActionState == tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREACTIVATED)) &&
               (m_rBTLimitationModeInfo.szBTAddress == m_szBTMACAddress) &&
               (m_rBTLimitationModeInfo.enTechnology == e8BT_TECH_CARPLAY))
      {
         ETG_TRACE_USR2(("spi_tclWiFiSetupHndlr::vCbInitiateWirelessDiscoveryResult: BT Limitation is Prepared for this Device already"));
         bInitWirelessDiscoveryResult = true;
         bSendInitWirelessDiscoveryResult = true;
      }
      else
      {
         //! szBTDeviceName is an optional parameter and should be used when BT address is not available.
         //! In cases (name not known, BT address is available) this parameter should be an empty string
         t_String szBTDeviceName;
         ETG_TRACE_USR2(("spi_tclWiFiSetupHndlr::vCbInitiateWirelessDiscoveryResult: Set the BT Limitation Prepare for this Device"));
           spi_tclFactory *poFactory = spi_tclFactory::getInstance();
           if(NULL != poFactory)
           {
               spi_tclBluetooth *poBluetooth = poFactory->poGetBluetoothInstance();
               if(NULL != poBluetooth)
               {
                   poBluetooth->bSetBTLimitationMode(m_szBTMACAddress,szBTDeviceName,tenBTTechnology::e8BT_TECH_CARPLAY,
                        e8BT_COMM_CHN_WIFI,tenBTLimitationAction::e8BT_LIM_ACTION_PREPARE);
               }//end if(NULL != poFactory)
           }//end if(NULL != poFactory)
       }//else
   }
   else
   {
      bInitWirelessDiscoveryResult = false;
      bSendInitWirelessDiscoveryResult = true;
   }
   if( (true == bSendInitWirelessDiscoveryResult) && (corEmptyUsrContext != m_rUsrCntxt) && (NULL != m_poWiFiSetupHndlrRespIntf))
   {
      //! clearing the Pending Request to process the Further requests from HMI
      m_bInitiateWirelessDiscoveryRequestPending = false;

      tenResponseCode enRespCode = bInitWirelessDiscoveryResult ? e8SUCCESS : e8FAILURE;
      m_poWiFiSetupHndlrRespIntf->vPostInitiateWirelessDiscoveryResult(enRespCode,m_rUsrCntxt);
      vClearInitiateWirelessDiscContext();
      m_szBTMACAddress.clear();
   }

}

/**************************************************************************
** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult()
**************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult(const trBTLimitationModeInfo &corfBTLimitationModeInfo)
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult():BTAddress:%s",corfBTLimitationModeInfo.szBTAddress.c_str()));
   ETG_TRACE_USR4(("spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult():Wiating for status of BTAddress:%s",m_szBTMACAddress.c_str()));
   
   ETG_TRACE_USR4(("spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult::SrcAppID:%d,RegID:%d,FunID:%d,DestAppID:%d,ServID:%d",m_rUsrCntxt.u32SrcAppID, 
   m_rUsrCntxt.u32RegID, m_rUsrCntxt.u32FuncID,m_rUsrCntxt.u32DestAppID, m_rUsrCntxt.u32ServcID));
   
   
   m_rBTLimitationModeInfo = corfBTLimitationModeInfo;
   if((corEmptyUsrContext != m_rUsrCntxt) && (NULL != m_poWiFiSetupHndlrRespIntf) && ((corfBTLimitationModeInfo.szBTAddress == m_szBTMACAddress)) )
   {
         switch(corfBTLimitationModeInfo.enActionState)
         {
            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREPARING:
               //do nothing
               break;

            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREPARED:

               //! clearing the Pending Request to process the Further requests from HMI
               m_bInitiateWirelessDiscoveryRequestPending = false;

               m_poWiFiSetupHndlrRespIntf->vPostInitiateWirelessDiscoveryResult(e8SUCCESS,m_rUsrCntxt);
               vClearInitiateWirelessDiscContext();

               //accepting the remote-connection
               vSetUserDeselect(m_szBTMACAddress, false);
               m_szBTMACAddress.clear();

               //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
               vSetCredentialsExchange(false);

               break;

            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREACTIVATED:
            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ACTIVATING:
            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ACTIVE:

               //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
               vSetCredentialsExchange(true);
               break;

            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ERROR:
            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ERROR_USER_DENIED:

               //! clearing the Pending Request to process the Further requests from HMI
               m_bInitiateWirelessDiscoveryRequestPending = false;

               m_poWiFiSetupHndlrRespIntf->vPostInitiateWirelessDiscoveryResult(e8FAILURE,m_rUsrCntxt);
               vClearInitiateWirelessDiscContext();
               m_szBTMACAddress.clear();

               //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
               vSetCredentialsExchange(false);
               break;

            case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_IDLE:

               //! clearing the Pending Request to process the Further requests from HMI
               m_bInitiateWirelessDiscoveryRequestPending = false;

               //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
               vSetCredentialsExchange(false);
               break;


            default:
               ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult() unknown response!!! "));
               break;
         }
   }
   else
   {
      vHandleCbBTLimResForDifferentDevice(corfBTLimitationModeInfo);
   }
}

/**************************************************************************
** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult()
**************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vSetUserContext(const trUserContext& rfcorUsrCntxt)
{
    ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vSetUserContext() entered "));
	   ETG_TRACE_USR4(("spi_tclWiFiSetupHndlr::vSetUserContext::SrcAppID:%d,RegID:%d,FunID:%d,DestAppID:%d,ServID:%d",rfcorUsrCntxt.u32SrcAppID, 
   rfcorUsrCntxt.u32RegID, rfcorUsrCntxt.u32FuncID,rfcorUsrCntxt.u32DestAppID, rfcorUsrCntxt.u32ServcID));
    m_rUsrCntxt = rfcorUsrCntxt;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vCbPostWiFiCredentials(t_String szBTMACAddress)
***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vCbPostWiFiCredentials(t_String szBTMACAddress)
{
	ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vCbPostWiFiCredentials():%s",szBTMACAddress.c_str()));
	
    spi_tclFactory *poFactory = spi_tclFactory::getInstance();
    if(NULL != poFactory)
    {
        spi_tclWiFi *poWiFi = poFactory->poGetWiFiInstance();
		if(NULL != poWiFi)
		{
			poWiFi->vSendWiFiCredentails(szBTMACAddress);
		}
	}
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vCbSetBTLimModeResult(t_Bool bResult)
***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vCbSetBTLimModeResult(t_Bool bResult)
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vCbSetBTLimModeResult() entered with bResult = %d for the BT Mac address: %s",ETG_ENUM(BOOL,bResult), m_rBTLimitationModeInfo.szBTAddress.c_str()));

   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vCbSetBTLimModeResult() requested for the BT Mac address %s",m_szBTMACAddress.c_str()));

   if( (m_rBTLimitationModeInfo.szBTAddress == m_szBTMACAddress) &&
            (m_rBTLimitationModeInfo.enTechnology == e8BT_TECH_CARPLAY) && (false == bResult))
   {
      //! clearing the Pending Request to process the Further requests from HMI
      m_bInitiateWirelessDiscoveryRequestPending = false;

      m_poWiFiSetupHndlrRespIntf->vPostInitiateWirelessDiscoveryResult(e8FAILURE,m_rUsrCntxt);
      vClearInitiateWirelessDiscContext();
      m_szBTMACAddress.clear();
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vClearInitiateWirelessDiscContext()
 ***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vClearInitiateWirelessDiscContext()
{
	ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vClearInitiateWirelessDiscContext()"));
	m_rUsrCntxt = corEmptyUsrContext;
}

/***************************************************************************
 ** FUNCTION:  spi_tclWiFiSetupHndlr::vRestoreSettings
 ***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vRestoreSettings()
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vRestoreSettings Entered"));
   //clearing the private data on factory reset
   m_bInitiateWirelessDiscoveryRequestPending = false;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vSetUserDeselect()
 ***************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vSetUserDeselect(t_String szBTMACAddress, t_Bool bUserDeslect)
{
   spi_tclFactory *poFactory = spi_tclFactory::getInstance();
   if(NULL != poFactory)
   {
      spi_tclWiFi *poWiFi = poFactory->poGetWiFiInstance();
      if(NULL != poWiFi)
      {
         poWiFi->vSetUserDeselect(szBTMACAddress,  bUserDeslect);
      }
   }
}

/**************************************************************************
** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vSetCredentialsExchange()
**************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vSetCredentialsExchange(t_Bool bCredentialsExchange)
{
   //! This is done to Send the credentials to the device only after PREACTIVATED
   spi_tclFactory* poFactory = spi_tclFactory::getInstance();
   if (NULL != poFactory)
   {
      spi_tclWiFi* poWiFi = poFactory->poGetWiFiInstance();
      if (NULL != poWiFi)
      {
         poWiFi->vSetExchangeCredentails(bCredentialsExchange);
      }
   }
}

/**************************************************************************
 ** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vHandleCbBTLimResForDifferentDevice()
 **************************************************************************/
t_Void spi_tclWiFiSetupHndlr::vHandleCbBTLimResForDifferentDevice(const trBTLimitationModeInfo &corfBTLimitationModeInfo)
{
   ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vHandleCbBTLimResForDifferentDevice():BTAddress:%s",corfBTLimitationModeInfo.szBTAddress.c_str()));

   //This handling is for remote-connections or If for any other device the BT Limitation is set
   if((corEmptyUsrContext == m_rUsrCntxt) || (corfBTLimitationModeInfo.szBTAddress != m_szBTMACAddress))
   {
      switch(corfBTLimitationModeInfo.enActionState)
      {
         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREPARING:
            //do nothing
            break;

         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREPARED:

            //! clearing the Pending Request to process the Further requests from HMI
            m_bInitiateWirelessDiscoveryRequestPending = false;
            //accepting the remote-connection
            vSetUserDeselect(corfBTLimitationModeInfo.szBTAddress, false);

            //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
            vSetCredentialsExchange(false);

            break;

         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_PREACTIVATED:
         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ACTIVATING:
         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ACTIVE:

            //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
            vSetCredentialsExchange(true);
            break;

         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ERROR:
         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_ERROR_USER_DENIED:

            //! clearing the Pending Request to process the Further requests from HMI
            m_bInitiateWirelessDiscoveryRequestPending = false;

            m_szBTMACAddress.clear();

            //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
            vSetCredentialsExchange(false);
            break;

         case tenBTLimitationActionState::e8BT_LIM_ACTION_STATE_IDLE:

            //! clearing the Pending Request to process the Further requests from HMI
            m_bInitiateWirelessDiscoveryRequestPending = false;

            //! This is done to Send the credentials to the device only after PREACTIVATED/ACTIVATING
            vSetCredentialsExchange(false);
            break;


         default:
            ETG_TRACE_USR1(("spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult() unknown response!!! "));
            break;
      }
   }
}

//lint �restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>
