  /*!
 *******************************************************************************
 * \file         spi_tclWiFiSetupHndlr.cpp
 * \brief        Wifi Manager class that provides interface to delegate
                 the execution of command and handle response
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Wifi Manager class for SPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                           | Modifications
12.12.2016  |  Unmukt Jain (RBEI/ECP2)          | Initial Version
 
 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLWIFISETUPHANDLR_H_
#define _SPI_TCLWIFISETUPHANDLR_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "spi_tclLifeCycleIntf.h"
#include "spi_tclWiFiSetupHndlrRespIntf.h"

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/* Forward Declarations. */

/*!
* \class spi_tclWiFiSetupHndlr
* \brief This is the main Wifi Manager class that provides interface to delegate
*        the execution of command and handle response.
*/
class spi_tclWiFiSetupHndlr : public spi_tclLifeCycleIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclWiFiSetupHndlr::spi_tclWiFiSetupHndlr()
   ***************************************************************************/
   /*!
   * \fn      spi_tclWiFiSetupHndlr()
   * \brief   Default Constructor
   ***************************************************************************/
   spi_tclWiFiSetupHndlr(spi_tclWiFiSetupHndlrRespIntf *poWiFiSetupHndlrRespIntf);

   /***************************************************************************
   ** FUNCTION:  spi_tclWiFiSetupHndlr::~spi_tclWiFiSetupHndlr();
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclWiFiSetupHndlr()
   * \brief   Virtual Destructor
   ***************************************************************************/
   virtual ~spi_tclWiFiSetupHndlr();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclWiFiSetupHndlr::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bUnInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclWiFiSetupHndlr::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclWiFiSetupHndlr::vLoadSettings()
    ***************************************************************************/
   /*!
    * \fn      vLoadSettings()
    * \brief   vLoadSettings Method. Invoked during OFF->NORMAL state transition.
    * \sa      vSaveSettings()
    **************************************************************************/
   virtual t_Void vLoadSettings();

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vSaveSettings()
    ***************************************************************************/
   /*!
    * \fn      vSaveSettings()
    * \brief   vSaveSettings Method. Invoked during  NORMAL->OFF state transition.
    * \sa      vLoadSettings()
    **************************************************************************/
   virtual t_Void vSaveSettings();
   
      /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery()
    ***************************************************************************/
   /*!
    * \fn      vInitiateWirelessDiscovery(t_String szBTMACAddress,tenDeviceCategory enDevCategory)
	* \param   rfcorUsrCntxt   : [IN] Set the UserContext for InitiateWirelessDiscovery
	* \param   szBTMACAddress : [IN] BTMACAddress
	* \param   enDevCategory : Device Category
    * \brief   vInitiateWirelessDiscovery Method. Invoked by SPI to start CPW session.
    **************************************************************************/
   t_Void vInitiateWirelessDiscovery(const trUserContext& rfcorUsrCntxt,
									 t_String szBTMACAddress,
                                     tenDeviceCategory enDevCategory);
   
   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vInitiateWirelessDiscovery()
    ***************************************************************************/
   /*!
    * \fn      vInitiateWirelessDiscovery(t_String szBTMACAddress,tenDeviceCategory enDevCategory)
	* \param   szBTMACAddress : [IN] BTMACAddress
	* \param   enDevCategory : Device Category
	* \param   bIsKnownDevice: [IN] FALSE- Fresh device, TRUE - Known device
    * \brief   vInitiateWirelessDiscovery Method. Invoked by HMI to start CPW session.
    **************************************************************************/
   t_Void vInitiateWirelessDiscovery(t_String szBTMACAddress,
                                     tenDeviceCategory enDevCategory,
                                     t_Bool bIsKnownDevice);

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vSetUserContext()
    ***************************************************************************/
   /*!
    * \fn      vSetUserContext()
    * \brief   vSetUserContext Method. Set the UserContext for InitiateWirelessDiscovery
    *          method invoked by HMI.
    * \param   rfcorUsrCntxt: User Context
    **************************************************************************/
   t_Void vSetUserContext(const trUserContext& rfcorUsrCntxt);

   /***************************************************************************
    ** FUNCTION:  spi_tclWiFiSetupHndlr::vRestoreSettings
    ***************************************************************************/
   /*!
    * \fn     t_Void vRestoreSettings()
    * \brief  vRestoreSettings Method. Invoked on factory reset to clear the private data when SPI Session is active
    * \param  None
    **************************************************************************/
   t_Void vRestoreSettings();


   /**************************************************************************
   ****************************END OF PUBLIC**********************************
   **************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vCbInitiateWirelessDiscoveryResult(t_Bool bResult)
    ***************************************************************************/
   /*!
    * \fn      vCbInitiateWirelessDiscoveryResult()
    * \brief   vCbInitiateWirelessDiscoveryResult Method.
    **************************************************************************/
   t_Void vCbInitiateWirelessDiscoveryResult(t_Bool bResult);

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vCbBTLimitationModeResult
    **                                  (const trBTLimitationModeInfo &corfBTLimitationModeInfo)
    ***************************************************************************/
   /*!
    * \fn      vCbBTLimitationModeResult()
    * \brief   vCbBTLimitationModeResult Method.
    * \param   corfBTLimitationModeInfo[IN]: trBTLimitationModeInfo structure type
    **************************************************************************/
   t_Void vCbBTLimitationModeResult(const trBTLimitationModeInfo &corfBTLimitationModeInfo);
   
   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vCbPostWiFiCredentials(t_String szBTMACAddress)
    ***************************************************************************/
   /*!
    * \fn      t_Void vCbPostWiFiCredentials(t_String szBTMACAddress)
    * \brief   Method to send the WiFi credentials
    * \param   szBTMACAddress: [IN] BT MAC Address
	* \retval  t_Void
    **************************************************************************/ 
   t_Void vCbPostWiFiCredentials(t_String szBTMACAddress);

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vCbSetBTLimModeResult(t_Bool bResult)
    ***************************************************************************/
   /*!
    * \fn      t_Void vCbSetBTLimModeResult(t_Bool bResult)
    * \brief   Method to send the Result of Set BT Limitation Mode
    * \param   bResult: [IN] Result of Set BT Limitation Mode
	* \retval  t_Void
    **************************************************************************/
   t_Void vCbSetBTLimModeResult(t_Bool bResult);

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: spi_tclWiFiSetupHndlr(const spi_tclWiFiSetupHndlr &rhs)
    ***************************************************************************/
   /*!
    * \fn      spi_tclWiFiSetupHndlr(const spi_tclWiFiSetupHndlr &rhs)
    * \brief   Copy constructor not implemented hence made private
    **************************************************************************/
   spi_tclWiFiSetupHndlr(const spi_tclWiFiSetupHndlr &rhs);

   /***************************************************************************
    ** FUNCTION: const spi_tclWiFiSetupHndlr & operator=(const spi_tclWiFiSetupHndlr &rhs);
    ***************************************************************************/
   /*!
    * \fn      const spi_tclWiFiSetupHndlr & operator=(const spi_tclWiFiSetupHndlr &rhs);
    * \brief   assignment operator not implemented hence made private
    **************************************************************************/
   const spi_tclWiFiSetupHndlr & operator=(const spi_tclWiFiSetupHndlr &rhs);
 
   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vClearInitiateWirelessDiscContext()
    ***************************************************************************/
   /*!
    * \fn      t_Void vClearInitiateWirelessDiscContext()
    * \brief   Method to clear the context update stored to respond to HMI
	* \retval  t_Void
    **************************************************************************/ 
   t_Void vClearInitiateWirelessDiscContext();

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vHandleCbBTLimResForDifferentDevice()
    ***************************************************************************/
   /*!
    * \fn      t_Void vHandleCbBTLimResForDifferentDevice()
    * \brief   Method to clear the Pending requests when the BT Limitation mode is set for other device
    * \param   corfBTLimitationModeInfo : Limitation Info
    * \retval  t_Void
    **************************************************************************/
   t_Void vHandleCbBTLimResForDifferentDevice(const trBTLimitationModeInfo &corfBTLimitationModeInfo);


   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vSetUserDeselect()
    ***************************************************************************/
   /*!
    * \fn      vSetUserDeselect(t_String szBTMACAddress, t_Bool bUserDeslect)
    * \param   szBTMACAddress : [IN] BTMACAddress
    * \param   bUserDeslect: [IN] - UserDeselect falg
    **************************************************************************/
   t_Void vSetUserDeselect(t_String szBTMACAddress, t_Bool bUserDeslect);

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vSetUserDeselect()
    ***************************************************************************/
   /*!
    * \fn      vSetUserDeselect(t_String szBTMACAddress, t_Bool bUserDeslect)
    * \param   bCredentialsExchange: [IN] - CredentialsExchange
    **************************************************************************/
   t_Void vSetCredentialsExchange(t_Bool bCredentialsExchange);

   /***************************************************************************
    ** FUNCTION:  spi_tclWiFiSetupHndlr::vSetBTLimitedFunctionality
    ***************************************************************************/
   /*!
    * \fn     vSetBTLimitedFunctionality()
    * \brief  Called by SPI component when a device's BT Functionality is Limited
    * \param  szBTAddress: Bt Mac Address
    * \param  bIsDeviceBTFunctionalityLimited : Bt Limitated Functionality
    **************************************************************************/
    t_Void vSetBTLimitedFunctionality(t_String szBTAddress, t_Bool bIsDeviceBTFunctionalityLimited);

   /***************************************************************************
   * ! Data members
   ***************************************************************************/

   spi_tclWiFiSetupHndlrRespIntf *m_poWiFiSetupHndlrRespIntf;
   trUserContext m_rUsrCntxt;
   
   t_String m_szBTMACAddress;

   trBTLimitationModeInfo m_rBTLimitationModeInfo;

   //! Initiate Wireless Discovery Request Pending
   t_Bool m_bInitiateWirelessDiscoveryRequestPending;
   /***************************************************************************
   ******************************END OF PRIVATE********************************
   ***************************************************************************/

};

#endif // _SPI_TCLWIFI_H_

