/*!
 *******************************************************************************
 * \file             spi_tclDiagnosis.h
 * \brief            Handles device diagnosis
 * \addtogroup       Diagnosis
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Handles device diagnosis
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 21.09.2018 |  Rajendra Naik Vadthe        | Initial Version


 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLDIAGNOSIS_H_
#define SPI_TCLDIAGNOSIS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

#include "spi_tclDeviceListIntf.h"
#include "spi_tclMediatorIntf.h"
#include "Timer.h"
#include "spi_tclDiscovererSettingsIntf.h"

//! Forward declarations
class spi_tclDiagnosisResp;//RAJ::NEED TO ADD
/*!
 * \class spi_tclDeviceSelector
 * \brief Handles selection  and deselection of device
 */
 
 class spi_tclDiagnosis
 {
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDiagnosis::spi_tclDiagnosis
       ***************************************************************************/
      /*!
       * \fn	  spi_tclDiagnosis(spi_tclDiagnosisResp *poRespInterface)
       * \brief  Parameterized Constructor
       * \param  poRespInterface: Pointer to response interface class
       * \sa	   ~spi_tclDeviceSelector()
       **************************************************************************/
      spi_tclDiagnosis(spi_tclDiagnosisResp *poRespInterface, spi_tclMediatorIntf* poMediator,spi_tclDiscovererSettingsIntf* poDiscovSettings);
      /***************************************************************************
       ** FUNCTION:  spi_tclDiagnosis::~spi_tclDiagnosisResp
       ***************************************************************************/
      /*!
       * \fn	  ~spi_tclDiagnosis()
       * \brief  Destructor
       * \sa	  spi_tclDiagnosis()
       **************************************************************************/
      virtual ~spi_tclDiagnosis();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDiagnosisResp::bInitialize()
       ***************************************************************************/
      /*!
       * \fn	   bInitialize()
       * \brief   Method to Initialize Diagnosis: Register for callbacks
       * \retval  true: if the initialization of Diagnosis is successful,
       *		   false: on failure
       * \sa	   bUnInitialize()
       **************************************************************************/
      virtual t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiagnosisResp::vUnInitialize()
       ***************************************************************************/
      /*!
       * \fn	   vUnInitialize()
       * \brief   Method to UnInitialize Diagnosis: Unregister callbacks.
       * \sa	   bInitialize()
       **************************************************************************/
      virtual t_Void vUnInitialize();
	   private:
	   
		  /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION: spi_tclDiagnosis(const spi_tclDiagnosis &corfobjRhs)
       ***************************************************************************/
      /*!
       * \fn 	 spi_tclDiagnosis(const spi_tclDiagnosis &corfobjRhs)
       * \brief	 Copy constructor not implemented hence made protected to prevent
       * 		 misuse
       **************************************************************************/
      spi_tclDiagnosis(const spi_tclDiagnosis &corfobjRhs);

      /***************************************************************************
       ** FUNCTION: const spi_tclDiagnosis & operator=(const spi_tclDiagnosis &corfobjRhs);
       ***************************************************************************/
      /*!
       * \fn 	 const spi_tclDiagnosis & operator=(const spi_tclDeviceSelector &corfobjRhs);
       * \brief	 assignment operator not implemented hence made protected to
       * 		 prevent misuse
       **************************************************************************/
      //const spi_tclDiagnosis & operator=(const spi_tclDiagnosis &corfobjRhs);

      /***************************************************************************
       ** FUNCTION:  spi_tclDiagnosis::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \fn	 vRegisterCallbacks()
       * \brief  Registers callbacks with mediator
       **************************************************************************/
      t_Void vRegisterCallbacks();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiagnosis::bDeviceConnectionTimerCb
       ***************************************************************************/
      /*!
       * \brief	Timer Callback Function to write into DTC
       * \param   timerID : [IN] Id of the timer for which the timer is expired
       * \param   pObject : [IN] pointer to the object for which the callback is related to
       * \param   pcoUserData : [IN] User context data
       * \retval  t_Bool
       * \sa	  vStartDeviceVisibility
       **************************************************************************/
      static t_Bool bDeviceConnectionTimerCb(timer_t timerID, t_Void *pObject, const t_Void *pcoUserData);

      /***************************************************************************
       ** FUNCTION:  spi_tclDiagnosis::vStartDeviceConnectionTimer()
       ***************************************************************************/
      /*!
       * \brief   Starts Device Visibility. HU is supposed to get Vendor Id, Product Id of
       the device within 50 seconds after coldstart.
       *          Invoked after vLoadSettings() of all subcomponents.
       * \sa      vLoadSettings()
       **************************************************************************/
      t_Void vStartDeviceConnectionTimer();

      /******************************************************************
       ** FUNCTION: t_Void spi_tclDiagnosis::vStopDeviceConnectionTimer()
      ******************************************************************/
       /*!
       * \brief   Stop Device Visibility if HU gets Vendor Id, Product Id of
       the device within 50 seconds after coldstart.
       *******************************************************************/
      t_Void vStopDeviceConnectionTimer();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiagnosis::vDeviceConnection
       * \brief  check if the device is visible/connected
       * \param  [IN] u32ProductID :Product ID
       * \param  [IN] u32VendorID : Vendor ID
       ***************************************************************************/
      t_Void vDeviceConnection(t_U32 u32ProductID, t_U32 u32VendorID, t_U32 u32DeviceHandle);

      /******************************************************
       ** FUNCTION:  t_Void spi_tclDiagnosis::vHandleDeviceConnection()
       * \brief  Handle the device visible/connected state
       * \param  [IN] enDTCStatus :Handle DTC State
       *******************************************************/
      t_Void vHandleDeviceConnection(tenDTCStatus enDTCStatus);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSelector::vDeviceDisconnectionCb
       ***************************************************************************/
      /*!
       * \fn     vDeviceDisconnectionCb()
       * \brief  Callback function for Device Disconnection
       * \param  cou32DeviceHandle: Device handle of the disconnected device
       **************************************************************************/
      t_Void vDeviceDisconnectionCb(const t_U32 cou32DeviceHandle);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSelector::vDeviceConnectionCb
       ***************************************************************************/
      /*!
       * \fn     vDeviceConnectionCb()
       * \brief  Callback function for Device Connection
       * \param  u32ProductID: ProductId of the device
       * \param  u32VendorID: VendorId of the device
       * \param  cou32DeviceHandle: Device handle of the Connected device
       **************************************************************************/
      t_Void vDeviceConnectionCb(const t_U32 u32ProductID, const t_U32 u32VendorID, const t_U32 cou32DeviceHandle);

      //! pointer to Mediator for posting messages
      spi_tclMediatorIntf *m_poMediator;

      //! pointer to Device selection response
      spi_tclDiagnosisResp *m_poDiagnosisResp;

      timer_t m_oDeviceConnectionTimerIndex;

      //! Whitelisted Device Handle
      t_U32 m_u32ValidDeviceHandle;

      /*
       *Mirrorlink feature support indicator
       */
      t_Bool m_bIsMirrorlinkSupported;
      //! Discoverer settings pointer
      spi_tclDiscovererSettingsIntf *m_poDiscovererSettings;
};
/*! } */
#endif /* SPI_TCLDIAGNOSIS_H_ */


