  /*!
 *******************************************************************************
 * \file         spi_tclDefSetLoader.cpp
 * \brief        Default Setting Loader class that provides interface to delegate 
                 the execution of command and handle response
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Default Setting Loader class for SPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                           | Modifications
 03.03.2015 |  Chaitra Srinivasa                | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "spi_tclDefSetLoader.h"

#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DEFSET
      #include "trcGenProj/Header/spi_tclDefSetLoader.cpp.trc.h"
   #endif
#endif


/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/

/***************************************************************************
** FUNCTION:  spi_tclDefSetLoader::spi_tclDefSetLoader();
***************************************************************************/
spi_tclDefSetLoader::spi_tclDefSetLoader():m_poDefaultSettings(NULL)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader() entered "));
} //!end of spi_tclDefSetLoader()

/***************************************************************************
** FUNCTION:  spi_tclDefSetLoader::~spi_tclDefSetLoader();
***************************************************************************/
spi_tclDefSetLoader::~spi_tclDefSetLoader()
{
   ETG_TRACE_USR1(("~spi_tclDefSetLoader() entered "));
   m_poDefaultSettings = NULL;
} //!end of ~spi_tclDefSetLoader()

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDefSetLoader::bInitialize()
***************************************************************************/
t_Bool spi_tclDefSetLoader::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::bInitialize() entered "));
   return true;
} //!end of bInitialize()

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDefSetLoader::bUnInitialize()
***************************************************************************/
t_Bool spi_tclDefSetLoader::bUnInitialize()
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::bUnInitialize() entered "));
   return true;
} //!end of bUnInitialize()

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vRestoreSettings()
***************************************************************************/
t_Void spi_tclDefSetLoader::vRestoreSettings()
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vRestoreSettings() entered "));
   
   vLoadDefaultSetting();
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vLoadSettings()
***************************************************************************/
t_Void spi_tclDefSetLoader::vLoadSettings()
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vLoadSettings() entered "));
   if(NULL != m_poDefaultSettings)
   {
      t_U8 u8VirginStart = m_poDefaultSettings->u8ReadVirginStartSetting();
      if(u8VirginStart != 0)
      {
         vRestoreSettings();
         // Set the value to zero at the virgin start up
         static const t_U8 u8DefaultVgStrt = 0;
         m_poDefaultSettings->vWriteVirginStartSetting(u8DefaultVgStrt);
      }
   }	  
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSaveSettings()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSaveSettings()
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSaveSettings() entered "));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetMLNotiSettingVal()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetMLNotiSettingVal(t_Bool bMLNotiSettingVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::bSetMLNotiSettingVal() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      // By default set to false
      m_poDefaultSettings->vSetMLNotiSettingVal(bMLNotiSettingVal);
   }

}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetMLLinkEnableSetVal()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetMLLinkEnableSetVal(tenEnabledInfo enMLLinkEnableSetVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetMLLinkEnableSetVal() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      // By default ML usage is enabled
      m_poDefaultSettings->bSetMLLinkEnableSetVal(enMLLinkEnableSetVal);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetDipoEnableSetVal()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetDipoEnableSetVal(tenEnabledInfo enDipoEnableSetVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetDipoEnableSetVal() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      // By default Dipo usage is enabled
      m_poDefaultSettings->bSetDipoEnableSetVal(enDipoEnableSetVal);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetAAPEnableSetVal()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetAAPEnableSetVal(tenEnabledInfo enAAPEnableSetVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetAAPEnableSetVal() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      // By default the AAP usage is enabled
      m_poDefaultSettings->bSetAAPEnableSetVal(enAAPEnableSetVal);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetCarlifeEnableSetVal()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetCarlifeEnableSetVal(tenEnabledInfo enCarlifeEnableSetVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetCarlifeEnableSetVal() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      // By default the Carlife usage is enabled
      m_poDefaultSettings->bSetCarlifeEnableSetVal(enCarlifeEnableSetVal);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetMySPINEnableSetVal()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetMySPINEnableSetVal(tenEnabledInfo enMySPINEnableSetVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetMySPINEnableSetVal() entered "));
   // By default the MySPIN usage is enabled
   if( NULL != m_poDefaultSettings)
   {
      m_poDefaultSettings->bSetMySPINEnableSetVal(enMySPINEnableSetVal);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetOnCarEnableSetVal()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetOnCarEnableSetVal(tenEnabledInfo enOnCarEnableSetVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetOnCarEnableSetVal() entered "));
   // By default the Oncar usage is enabled
   if( NULL != m_poDefaultSettings)
   {
      m_poDefaultSettings->bWriteOnCarEnableSetting(enOnCarEnableSetVal);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetSteeringWheelPos()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetSteeringWheelPos(tenDriveSideInfo enSteeringWheelPos)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetSteeringWheelPos() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      // Default steering wheel position is set as unknown drive side
      m_poDefaultSettings->vSetSteeringWheelPos(enSteeringWheelPos);
   }
}


/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetSelectMode()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetSelectMode(tenDeviceSelectionMode enSelectMode)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetSelectMode() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      // Default select mode is set to unknown device
      m_poDefaultSettings->vSetSelectMode(enSelectMode);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetAndroidDeviceTechnologyPreference()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetAndroidDeviceTechnologyPreference(tenDeviceCategory enAndroidDeviceTechPrefVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetAndroidDeviceTechnologyPreference() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      m_poDefaultSettings->bSetAndroidDeviceTechnologyPreference(enAndroidDeviceTechPrefVal);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vSetAppleDeviceTechnologyPreference()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetAppleDeviceTechnologyPreference(tenDeviceCategory enAppleDeviceTechPrefVal)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetAppleDeviceTechnologyPreference() entered "));
   if(NULL !=m_poDefaultSettings)
   {
      m_poDefaultSettings->bSetAppleDeviceTechnologyPreference(enAppleDeviceTechPrefVal);
   }
}
/***************************************************************************
** FUNCTION:  t_Void spi_tclDefSetLoader::vLoadDefaultSetting()
***************************************************************************/
t_Void spi_tclDefSetLoader::vLoadDefaultSetting()
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vLoadDefaultSetting() entered "));
   //loading the default values to datapool

   if(m_poDefaultSettings != NULL)
   {
      t_Bool bMLNotiSettingVal = m_poDefaultSettings->bGetMLNotiSettingVal();
      vSetMLNotiSettingVal(bMLNotiSettingVal);

      tenEnabledInfo enMLLinkEnableSetVal = m_poDefaultSettings->enGetMLLinkEnableSetVal();
      vSetMLLinkEnableSetVal(enMLLinkEnableSetVal);

      tenEnabledInfo enDipoEnableSetVal = m_poDefaultSettings->enGetDipoEnableSetVal();
      vSetDipoEnableSetVal(enDipoEnableSetVal);

      tenEnabledInfo enAAPEnableSetVal = m_poDefaultSettings->enGetAAPEnableSetVal();
      vSetAAPEnableSetVal(enAAPEnableSetVal);

      tenEnabledInfo enCarlifeEnableSetVal = m_poDefaultSettings->enGetCarlifeEnableSetVal();
      vSetCarlifeEnableSetVal(enCarlifeEnableSetVal);

      tenEnabledInfo enMySPINEnableSetVal = m_poDefaultSettings->enGetMySPINEnableSetVal();
      vSetMySPINEnableSetVal(enMySPINEnableSetVal);

      tenEnabledInfo enOnCarEnableSetVal = m_poDefaultSettings->enGetOnCarEnableSetVal();
      vSetOnCarEnableSetVal(enOnCarEnableSetVal);

      tenDriveSideInfo enSteeringWheelPos = m_poDefaultSettings->enGetSteeringWheelPos();
      vSetSteeringWheelPos(enSteeringWheelPos);   

      tenDeviceSelectionMode enSelectMode = m_poDefaultSettings->enGetSelectMode();
      vSetSelectMode(enSelectMode); 

      tenDeviceCategory enAndroidDeviceTechnologyPreference =  m_poDefaultSettings->enGetAndroidDeviceTechnologyPreference();
      vSetAndroidDeviceTechnologyPreference(enAndroidDeviceTechnologyPreference);

      tenDeviceCategory enAppleDeviceTechnologyPreference =  m_poDefaultSettings->enGetAppleDeviceTechnologyPreference();
      vSetAppleDeviceTechnologyPreference(enAppleDeviceTechnologyPreference);
   }	  
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetDefaultSettingsInstance()
***************************************************************************/
t_Void spi_tclDefSetLoader::vSetDefaultSettingsInstance(spi_tclDefaultSettingsIntf* poDefaultSettingsIntf)
{
   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetAudioSettingsInstance entered"));

   if(NULL != poDefaultSettingsIntf)
   {
	   ETG_TRACE_USR1(("spi_tclDefSetLoader::vSetAudioSettingsInstance: Setting val"));
       m_poDefaultSettings = poDefaultSettingsIntf;
   }
}

