  /*!
 *******************************************************************************
 * \file         spi_tclDefSetLoader.h
 * \brief        Default settings loader class loads the default values
                 at the time of flashing a software on the target.
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Default settings loader class for SPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                           | Modifications
 04.03.2014 |  Chaitra Srinivasa                | Initial Version

 
 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLDEFSETLOADER_H_
#define _SPI_TCLDEFSETLOADER_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclDefaultSettingsIntf.h"

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/*!
* \class spi_tclDefSetLoader
* \brief This is the main Default settings loader class loads the default values
         at the time of flashing a software on the target.
*/
class spi_tclDefSetLoader 
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDefSetLoader::spi_tclDefSetLoader()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDefSetLoader()
   * \brief   Default Constructor
   ***************************************************************************/
   spi_tclDefSetLoader();

   /***************************************************************************
   ** FUNCTION:  spi_tclDefSetLoader::~spi_tclDefSetLoader();
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclDefSetLoader()
   * \brief   Virtual Destructor
   ***************************************************************************/
   virtual ~spi_tclDefSetLoader();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDefSetLoader::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bUnInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDefSetLoader::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDefSetLoader::vRestoreSettings()
    ***************************************************************************/
   /*!
    * \fn      vRestoreSettings()
    * \brief   vRestoreSettings Method. Invoked during OFF->NORMAL state transition.
    * \sa      vSaveSettings()
    **************************************************************************/
   virtual t_Void vRestoreSettings();

    /***************************************************************************
    ** FUNCTION: t_Void spi_tclDefSetLoader::vLoadSettings()
    ***************************************************************************/
   /*!
    * \fn      vLoadSettings()
    * \brief   vLoadSettings Method. Invoked during  NORMAL->OFF state transition.
    * \sa      vSaveSettings()
    **************************************************************************/
   virtual t_Void vLoadSettings();

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclDefSetLoader::vSaveSettings()
    ***************************************************************************/
   /*!
    * \fn      vSaveSettings()
    * \brief   vSaveSettings Method. Invoked during  NORMAL->OFF state transition.
    * \sa      vLoadSettings()
    **************************************************************************/
   virtual t_Void vSaveSettings();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetMLNotiSettingVal()
   ***************************************************************************/
   /*!
   * \fn      vSetMLNotiSettingVal(t_Bool bMLNotiSettingVal)
   * \brief   Called to set the default value to notification setting.
   * \param   [IN] bMLNotiSettingVal: default value for notification setting
   * \retval  None
   **************************************************************************/
   t_Void vSetMLNotiSettingVal(t_Bool bMLNotiSettingVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetMLLinkEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn      vSetMLLinkEnableSetVal(tenEnabledInfo enMLLinkEnableSetVal)
   * \brief   Called to set the default value to enable ML usage.
   * \param   [IN] enMLLinkEnableSetVal: default value for enabling ML link setting
   * \retval  None
   **************************************************************************/
   t_Void vSetMLLinkEnableSetVal(tenEnabledInfo enMLLinkEnableSetVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetDipoEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn      vSetDipoEnableSetVal(tenEnabledInfo enDipoEnableSetVal)
   * \brief   Called to set the default value to enable Dipo usage.
   * \param   [IN] enDipoEnableSetVal: default value for enabling Dipo setting
   * \retval  None
   **************************************************************************/
   t_Void vSetDipoEnableSetVal(tenEnabledInfo enDipoEnableSetVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetAAPEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn      vSetAAPEnableSetVal(tenEnabledInfo enAAPEnableSetVal)
   * \brief   Called to set the default value to enable AAP usage.
   * \param   [IN] enAAPEnableSetVal: default value for enabling AAP setting
   * \retval  None
   **************************************************************************/
   t_Void vSetAAPEnableSetVal(tenEnabledInfo enAAPEnableSetVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetCarlifeEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn      vSetCarlifeEnableSetVal(tenEnabledInfo enCarlifeEnableSetVal)
   * \brief   Called to set the default value to enable AAP usage.
   * \param   [IN] enCarlifeEnableSetVal: default value for enabling Carlife setting
   * \retval  None
   **************************************************************************/
   t_Void vSetCarlifeEnableSetVal(tenEnabledInfo enCarlifeEnableSetVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetMySPINEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn      vSetMySPINEnableSetVal(tenEnabledInfo enMySPINEnableSetVal)
   * \brief   Called to set the default value to enable AAP usage.
   * \param   [IN] enMySPINEnableSetVal: default value for enabling myspin setting
   * \retval  None
   **************************************************************************/
   virtual t_Void vSetMySPINEnableSetVal(tenEnabledInfo enMySPINEnableSetVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetOnCarEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn      vSetOnCarEnableSetVal(tenEnabledInfo enOnCarEnableSetVal)
   * \brief   Called to set the default value to enable OnCar usage.
   * \param   [IN] enOnCarEnableSetVal: default value for enabling OnCar setting
   * \retval  None
   **************************************************************************/
   virtual t_Void vSetOnCarEnableSetVal(tenEnabledInfo enOnCarEnableSetVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetSteeringWheelPos()
   ***************************************************************************/
   /*!
   * \fn      vSetSteeringWheelPos(tenDriveSideInfo enSteeringWheelPos)
   * \brief   Called to set the default value to steering wheel position.
   * \param   [IN] enSteeringWheelPos: default value for steering wheel position
   * \retval  None
   **************************************************************************/
   t_Void vSetSteeringWheelPos(tenDriveSideInfo enSteeringWheelPos);


   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetSelectMode()
   ***************************************************************************/
   /*!
   * \fn      vSetSelectMode(tenDeviceSelectionMode enSelectMode)
   * \brief   Called to set the default value to selection mode.
   * \param   [IN] enSelectMode: default value for selection mode
   * \retval  None
   **************************************************************************/
   t_Void vSetSelectMode(tenDeviceSelectionMode enSelectMode);


   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetAndroidDeviceTechnologyPreference()
   ***************************************************************************/
   /*!
   * \fn      vSetAndroidDeviceTechnologyPreference(tenDeviceCategory enAndroidDeviceTechPrefVal)
   * \brief   Called to set the default value to technology preference.
   * \param   [IN] enAndroidDeviceTechPrefVal: default value -technology preference for Android Device
   * \retval  None
   **************************************************************************/
   t_Void vSetAndroidDeviceTechnologyPreference(tenDeviceCategory enAndroidDeviceTechPrefVal);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vSetAppleDeviceTechnologyPreference()
   ***************************************************************************/
   /*!
   * \fn      vSetAppleDeviceTechnologyPreference(tenDeviceCategory enAppleDeviceTechPrefVal)
   * \brief   Called to set the default value to technology preference.
   * \param   [IN] enAppleDeviceTechPrefVal: default value -technology preference for Apple Device
   * \retval  None
   **************************************************************************/
   t_Void vSetAppleDeviceTechnologyPreference(tenDeviceCategory enAppleDeviceTechPrefVal);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclAppLauncher::vSetDefaultSettingsInstance(spi_tclDefaultSettingsIntf* poDefaultSettingsIntf)
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetDefaultSettingsInstance()
    * \brief   Method to set Default settings instance.
    * \param   poDefaultSettingsIntf  : pointer to AudioSettingsIntf.
    * \retval  t_Void
    **************************************************************************/
   t_Void vSetDefaultSettingsInstance(spi_tclDefaultSettingsIntf* poDefaultSettingsIntf);
   
   /**************************************************************************
   ****************************END OF PUBLIC**********************************
   **************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: spi_tclDefSetLoader(const spi_tclDefSetLoader &rfcoDefSetLoader)
    ***************************************************************************/
   /*!
    * \fn      spi_tclDefSetLoader(const spi_tclDefSetLoader &rfcoDefSetLoader)
    * \brief   Copy constructor not implemented hence made private
    **************************************************************************/
   spi_tclDefSetLoader(const spi_tclDefSetLoader &rfcoDefSetLoader);

   /***************************************************************************
    ** FUNCTION: const spi_tclDefSetLoader & operator=(
    **                                 const spi_tclDefSetLoader &rfcoDefSetLoader);
    ***************************************************************************/
   /*!
    * \fn      const spi_tclDefSetLoader & operator=(const spi_tclDefSetLoader &rfcoDefSetLoader);
    * \brief   assignment operator not implemented hence made private
    **************************************************************************/
   const spi_tclDefSetLoader & operator=(
            const spi_tclDefSetLoader &rfcoDefSetLoader);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefSetLoader::vLoadDefaultSetting()
   ***************************************************************************/
   /*!
   * \fn      vLoadDefaultSetting()
   * \brief   Called to load the default value to datapool.
   * \retval  None
   **************************************************************************/
   t_Void vLoadDefaultSetting();   			

   /***************************************************************************
   * ! Data members
   ***************************************************************************/
   //! DefaultSettingsIntf pointer
   spi_tclDefaultSettingsIntf* m_poDefaultSettings;

};

#endif // _SPI_TCLDEFSETLOADER_H_

