/*!
 *******************************************************************************
 * \file             spi_tclDeviceIDUtility.cpp
 * \brief
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 25.05.2017 |  Pruthvi Thej Nagaraju       | Initial Version
 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclDeviceIDUtility.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/spi_tclDeviceIDUtility.cpp.trc.h"
#endif
#endif


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::~spi_tclDeviceIDUtility
 ***************************************************************************/
spi_tclDeviceIDUtility::~spi_tclDeviceIDUtility()
{
   m_pDeviceList = NULL;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::u32GetDeviceIDFromBTAddress
 ***************************************************************************/
t_U32 spi_tclDeviceIDUtility::u32GetDeviceIDFromBTAddress(const t_String& coszBTAddress)
{
   t_U32 u32DeviceID  = 0;
   if(NULL != m_pDeviceList)
   {
      u32DeviceID = m_pDeviceList->u32GetDeviceIDFromBTAddress(coszBTAddress);
   }
   return u32DeviceID;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::u32GetDeviceIDFromSerialNo
 ***************************************************************************/
t_U32 spi_tclDeviceIDUtility::u32GetDeviceIDFromSerialNo(const t_String& coszSerialNo)
{
   t_U32 u32DeviceID  = 0;
   if(NULL != m_pDeviceList)
   {
      u32DeviceID = m_pDeviceList->u32GetDeviceIDFromSerialNo(coszSerialNo);
   }
   return u32DeviceID;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::u32GetDeviceIDFromName
 ***************************************************************************/
t_U32 spi_tclDeviceIDUtility::u32GetDeviceIDFromName(const t_String &coszDeviceName)
{
   t_U32 u32DeviceID  = 0;
   if (NULL != m_pDeviceList)
   {
      u32DeviceID= m_pDeviceList->u32GetDeviceIDFromName(coszDeviceName);
   }
   return u32DeviceID;
}


/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::vGetBTAddress
 ***************************************************************************/
t_Void spi_tclDeviceIDUtility::vGetBTAddress(t_String& coszBTAddress, const t_U32 cou32DeviceID)
{
   if (NULL != m_pDeviceList)
   {
      m_pDeviceList->vGetBTAddress(cou32DeviceID, coszBTAddress);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::vGetSerialNumber
 ***************************************************************************/
t_Void spi_tclDeviceIDUtility::vGetSerialNumber(t_String& coszSerialNo, const t_U32 cou32DeviceID)
{
   if (NULL != m_pDeviceList)
   {
      m_pDeviceList->vGetSerialNumber(coszSerialNo, cou32DeviceID);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::vGetSessionTransport
 ***************************************************************************/
t_Void spi_tclDeviceIDUtility::vGetSessionTransport(const t_U32 cou32DeviceID,tenSessionTransport& enSessionTransport)
{
   if (NULL != m_pDeviceList)
   {
      t_String szSerialNo;
      vGetSerialNumber(szSerialNo,cou32DeviceID);

      enSessionTransport = m_pDeviceList->enGetSessionTransportFromSerialNumber(szSerialNo);
   }

}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::enGetDeviceCategory
 ***************************************************************************/
tenDeviceCategory spi_tclDeviceIDUtility::enGetDeviceCategory(const t_U32 cou32DeviceID)
{
   tenDeviceCategory enDeviceCategory = e8DEV_TYPE_UNKNOWN;
   if (NULL != m_pDeviceList)
   {
      enDeviceCategory = m_pDeviceList->enGetDeviceCategory(cou32DeviceID);
   }
   return enDeviceCategory;

}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::u32GetDeviceIDFromIPAddress
 ***************************************************************************/
t_U32 spi_tclDeviceIDUtility::u32GetDeviceIDFromIPAddress(const t_String& coszIPAddress)
{
   t_U32 u32DeviceID  = 0;
   if(NULL != m_pDeviceList)
   {
      u32DeviceID = m_pDeviceList->u32GetDeviceIDFromIPAddress(coszIPAddress);
   }
   return u32DeviceID;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::vGetBTDeviceName
 ***************************************************************************/
t_Void spi_tclDeviceIDUtility::vGetDeviceName(t_U32 cou32DeviceHandle, t_String &rfszDeviceName)
{
    if (NULL != m_pDeviceList)
    {
        m_pDeviceList->vGetDeviceName(cou32DeviceHandle, rfszDeviceName);
    }
    ETG_TRACE_USR1(("spi_tclDeviceIDUtility::vGetBTDeviceName: Device = %d  with device name = %s ",
         cou32DeviceHandle, rfszDeviceName.c_str()));
}


/***************************************************************************
 *********************************PRIVATE*************************************
 ***************************************************************************/
/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::spi_tclDeviceIDUtility
 ***************************************************************************/
spi_tclDeviceIDUtility::spi_tclDeviceIDUtility(): m_pDeviceList(NULL)
{

}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDUtility::spi_tclDeviceIDUtility
 ***************************************************************************/
spi_tclDeviceIDUtility::spi_tclDeviceIDUtility(spi_tclDeviceListIntf *poDeviceList): m_pDeviceList(poDeviceList)
{

}
