/*!
 *******************************************************************************
 * \file             spi_tclTechnologySelectorResp.h
 * \brief            Response to HMI from TechnologySelector class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Response  to HMI  from TechnologySelector class.
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 28.10.2016 |  Pruthvi Thej Nagaraju       | Initial Version
 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLTECHNOLOGYSELECTORRESP_H_
#define SPI_TCLTECHNOLOGYSELECTORRESP_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclTechnologySelectorResp
 * \brief Response  to HMI  from TechnologySelector class
 */
class spi_tclTechnologySelectorResp
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclTechnologySelectorResp::spi_tclTechnologySelectorResp
       ***************************************************************************/
      /*!
       * \fn     spi_tclTechnologySelectorResp()
       * \brief  Default Constructor
       * \sa      ~spi_tclTechnologySelectorResp()
       **************************************************************************/
      spi_tclTechnologySelectorResp()
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclTechnologySelectorResp::~spi_tclTechnologySelectorResp
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclTechnologySelectorResp()
       * \brief  Virtual Destructor
       * \sa     spi_tclTechnologySelectorResp()
       **************************************************************************/
      virtual ~spi_tclTechnologySelectorResp()
      {

      }


      /***************************************************************************
       ** FUNCTION: t_Void spi_tclTechnologySelectorResp::vUpdateTechnologySelectionStatus
       ***************************************************************************/
      /*!
       * \fn     vUpdateTechnologySelectionStatus
       * \brief  It notifies the client when device authorization is required
       * \param  [IN] u32DeviceHandle : Uniquely identifies the target Device.
       * \param  [IN] enDeviceType   : Device type : Android/iPhone
       * \param  [IN] enAuthStatus  : Authorization status
       **************************************************************************/
      virtual t_Void vUpdateTechnologySelectionStatus(t_U32 /*u32DevHandle*/,
               tenDeviceType /*enDeviceType*/,
               tenDeviceCategory /*enSelectedTechnology*/)
      {

      }

};
#endif // SPI_TCLTECHNOLOGYSELECTORRESP_H_
