/*!
 *******************************************************************************
 * \file             spi_tclSelectionIntf.h
 * \brief            Selection interface to trigger select device and selectdevice results
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Selection interface to trigger select device and selectdevice results
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 28.10.2016 |  Pruthvi Thej Nagaraju       | Initial Version
 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLSELECTIONINTF_H_
#define SPI_TCLSELECTIONINTF_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

class spi_tclSelectionIntf
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclSelectionIntf::spi_tclSelectionIntf
       ***************************************************************************/
      /*!
       * \fn     spi_tclSelectionIntf()
       * \brief  Parameterized Constructor
       * \param enComponentID: component ID
       * \sa      ~spi_tclSelectionIntf()
       **************************************************************************/
      spi_tclSelectionIntf(tenCompID enComponentID):m_enComponentID(enComponentID)
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclSelectionIntf::~spi_tclSelectionIntf
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclSelectionIntf()
       * \brief  Virtual Destructor
       * \sa     spi_tclSelectionIntf()
       **************************************************************************/
      virtual ~spi_tclSelectionIntf()
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclSelectionIntf::vSelectDevice
       ***************************************************************************/
      /*!
       * \fn     vSelectDevice
       * \brief  Device selection request
       * \param  corfrSelectReq : Device selection request details
       **************************************************************************/
      virtual t_Void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclSelectionIntf::vSelectDeviceResult
       ***************************************************************************/
      /*!
       * \fn     vSelectDeviceResult
       * \brief  device selection result
       * \param  corfrSelectReq : Device selection result details
       * \param  enErrorCode : Error code
       **************************************************************************/
      virtual t_Void vSelectDeviceResult(const trSelectDeviceRequest& corfrSelectReq, tenErrorCode enErrorCode)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclSelectionIntf::vUpdateSelectionState
       ***************************************************************************/
      /*!
       * \fn     vUpdateSelectionState
       * \brief  Informs if the device selection is not initiated for a reported device
       * \param  cou32DeviceHandle: Device handle
       * \param  enDeviceConnType : Device Connection type to differentiate between the transport while sending the role switch request response
       **************************************************************************/
      virtual t_Void  vUpdateSelectionState(const t_U32 /*cou32DeviceHandle*/, tenDeviceSelectionState /*enDevSelectionState*/, tenDeviceConnectionType /*enDeviceConnType*/) {};


      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclSelectionIntf::vRetryConnection()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRetryConnection()
       * \brief   Method to retry to establish session
       * \param   u32DeviceID  : [IN] Device Handle.
       * \param   enDevCategory : [IN] Device category
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vRetryConnection(t_U32 /*u32DeviceID*/,tenDeviceCategory /*enDevCategory*/){};

      /***************************************************************************
       ** FUNCTION:  spi_tclSelectionIntf::enGetComponentID
       ***************************************************************************/
      /*!
       * \fn     enGetComponentID
       * \brief  returns componentID
       **************************************************************************/
      tenCompID enGetComponentID()
      {
         return m_enComponentID;
      }

   private:

      /***************************************************************************
       ** FUNCTION:  spi_tclSelectionIntf::vSendSelectDeviceResponse
       ***************************************************************************/
      /*!
       * \fn     vSendSelectDeviceResponse
       * \brief  send device selection response back to deviceselector
       * \param  enErrorCode :Error code
       **************************************************************************/
      virtual void vSendSelectDeviceResponse(tenErrorCode /*enErrorCode*/) {};

      //! component ID
      tenCompID m_enComponentID;
};


#endif /* SPI_TCLSELECTIONINTF_H_ */
