/*!
 *******************************************************************************
 * \file             spi_tclDevHistoryIntf.h
 * \brief            Interface to access Device History
 * \addtogroup       Connectivity
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Interface to access Device History
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 19.07.2019 |  Pavan Hiremath              | Initial Version
 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLDEVHISTORYINTF_H_
#define SPI_TCLDEVHISTORYINTF_H_


/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"

/*!
 * \class spi_tclDevHistoryIntf
 * \brief Interface for Device List handling
 */
class spi_tclDevHistoryIntf
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::spi_tclDevHistoryIntf
       ***************************************************************************/
      /*!
       * \fn     spi_tclDevHistoryIntf()
       * \brief  Default Constructor
       * \sa      ~spi_tclDevHistoryIntf()
       **************************************************************************/
      spi_tclDevHistoryIntf(){}

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::~spi_tclDevHistoryIntf
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclDevHistoryIntf()
       * \brief   Destructor
       * \sa     spi_tclDevHistoryIntf()
       **************************************************************************/
      virtual ~spi_tclDevHistoryIntf(){}

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::bRestoreDeviceList
       ***************************************************************************/
      /*!
       * \fn     bRestoreDeviceList
       * \brief  Reads database to restore device history to device list
       * \retval true: if the history was added successfully to device list
       *         false: on Error
       **************************************************************************/
      virtual t_Bool bInitialize()=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::bSaveDeviceList
       ***************************************************************************/
      /*!
       * \fn     bSaveDeviceList
       * \brief  Saves the device list to persistent memory device list
       **************************************************************************/
      virtual t_Bool bUnInitialize()=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vLoadSettings()=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSaveSettings()=0;
      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_U32 u32GetNumOfDevices()=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Bool bAddtoHistorydb(trEntireDeviceInfo &rfrDevInfo)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Bool bDeleteFromHistorydb(const t_U32 cou32DeviceHandle)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Bool bGetDeviceHistoryFromdb(std::vector<trEntireDeviceInfo> &rfrDeviceInfo,
               tenSelModePriority enPriority = e8PRIORITY_DEVICELIST_HISTORY,
               tenDeviceCategory enDevTypePref = e8DEV_TYPE_DIPO,
               tenDeviceConnectionType enConnModePref = e8USB_CONNECTED)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vDisplayDevHistorydb()=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Bool bFindDevice(t_U32 u32Key)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetSelectedDevice(const t_U32 cou32DeviceHandle,
               t_Bool bIsDevSelected)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetDeviceName(const t_U32 cou32DeviceHandle, t_String &rfrszDeviceName)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetUserDeselectionFlag(const t_U32 cou32DeviceHandle, t_Bool bState)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_U32 u32GetLastSelectedDevice()=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSaveDeviceList(std::map<t_U32, trEntireDeviceInfo> &m_mapDeviceList)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_U32 u32GetMaxAccessIndex()=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetDeviceUsagePreference(
               const t_U32 cou32DeviceHandle, tenEnabledInfo enEnabledInfo)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetBTAddress(const t_U32 cou32DeviceHandle, const t_String& corfrszBTAddress)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetDeviceCategory(const t_U32 cou32DeviceHandle, tenDeviceCategory enDeviceCategory)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Bool bSetDeviceConnectionCountInfo(const t_U32 cou32DeviceHandle,
               trDeviceConnectionCountInfo &rfrDeviceConnectionCountInfo)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetVendorID(const t_U32 cou32DeviceHandle, const t_U32 cou32VendorID)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vSetProductID(const t_U32 cou32DeviceHandle, const t_U32 cou32ProductID)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
       ***************************************************************************/
      /*!
       * \fn     vClearDeviceList
       * \brief  clears Device List
       **************************************************************************/
      virtual t_Void vClearPrivateData()=0;

      /***************************************************************************
        ** FUNCTION:  spi_tclDevHistoryIntf::vSetLastActiveSessionTransport
        ***************************************************************************/
       /*!
        * \fn     vSetLastActiveSessionTransport
        * \brief  Sets the Last Active Session Transport
        * \param cou32DeviceHandle: Device Handle of the device to be added to history
        * \param enSessionTransport : Session Transport
        **************************************************************************/
       virtual t_Void vSetLastActiveSessionTransport(const t_U32 cou32DeviceHandle, tenSessionTransport enSessionTransport) = 0;

//
//      /***************************************************************************
//       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
//       ***************************************************************************/
//      /*!
//       * \fn     vClearDeviceList
//       * \brief  clears Device List
//       **************************************************************************/
//      virtual t_Void vSaveSettings()=0;
//
//      /***************************************************************************
//       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
//       ***************************************************************************/
//      /*!
//       * \fn     vClearDeviceList
//       * \brief  clears Device List
//       **************************************************************************/
//      virtual t_Void vSaveSettings()=0;
//
//      /***************************************************************************
//       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
//       ***************************************************************************/
//      /*!
//       * \fn     vClearDeviceList
//       * \brief  clears Device List
//       **************************************************************************/
//      virtual t_Void vSaveSettings()=0;
//
//      /***************************************************************************
//       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
//       ***************************************************************************/
//      /*!
//       * \fn     vClearDeviceList
//       * \brief  clears Device List
//       **************************************************************************/
//      virtual t_Void vSaveSettings()=0;
//
//      /***************************************************************************
//       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
//       ***************************************************************************/
//      /*!
//       * \fn     vClearDeviceList
//       * \brief  clears Device List
//       **************************************************************************/
//      virtual t_Void vSaveSettings()=0;
//
//      /***************************************************************************
//       ** FUNCTION:  spi_tclDevHistoryIntf::vClearDeviceList
//       ***************************************************************************/
//      /*!
//       * \fn     vClearDeviceList
//       * \brief  clears Device List
//       **************************************************************************/
//      virtual t_Void vSaveSettings()=0;
};

#endif /* spi_tclDevHistoryIntf_H_ */
