/*!
 *******************************************************************************
 * \file             spi_tclConnMngrResp.h
 * \brief            Response to HMI from ConnMngr class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Response  to HMI  from ConnMngr class.
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 10.01.2014 |  Pruthvi Thej Nagaraju       | Initial Version
 05.11.2014 |  Ramya Murthy                | Added Application metadata response
 01.01.2017 |  Noopur R K                  | Added vPostDeleteDevice

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLCONNMNGRRESP_H_
#define SPI_TCLCONNMNGRRESP_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclConnMngrResp
 * \brief Response  to HMI  from ConnMngr class
 */
class spi_tclConnMngrResp
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclConnMngrResp::spi_tclConnMngrResp
       ***************************************************************************/
      /*!
       * \fn     spi_tclConnMngrResp()
       * \brief  Default Constructor
       * \sa      ~spi_tclConnMngrResp()
       **************************************************************************/
      spi_tclConnMngrResp()
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclConnMngrResp::~spi_tclConnMngrResp
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclConnMngrResp()
       * \brief  Virtual Destructor
       * \sa     spi_tclConnMngrResp()
       **************************************************************************/
      virtual ~spi_tclConnMngrResp()
      {

      }


      /***************************************************************************
       ** FUNCTION: t_Void spi_tclConnMngrResp::vPostDeviceStatusInfo
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceStatusInfo(t_U32 u32DeviceHandle,
       *             tenDeviceConnectionType enDevConnType, tenDeviceStatusInfo enDeviceStatus)
       * \brief  It notifies the client on change in any device attributes.
       *         The client can retrieve the detailed information
       *         via the methods provided.
       * \param  [IN] u32DeviceHandle : Uniquely identifies the target Device.
       * \param  [IN] enDevConnType   : Identifies the Connection Type.
       * \param  [IN] enDeviceStatus  : enum value which stores device status
       **************************************************************************/
      virtual t_Void vPostDeviceStatusInfo(t_U32 /*u32DevHandle*/, tenDeviceConnectionType /*enDevConnType*/,
               tenDeviceStatusInfo /*enDeviceStatus*/)
      {

      }

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclConnMngrResp::vPostDAPStatusInfo
      ***************************************************************************/
      /*!
      * \fn     vPostDAPStatusInfo
      * \brief  It notifies the client about DAP authentication progress information
      *            for a Mirror Link device.
      * \param  [IN] u32DeviceHandle : Uniquely identifies the target Device.
      * \param  [IN] enDevConnType   : Identifies the Connection Type.
      * \param  [IN] enDAPStatus : DAP Authentication Progress Status.
      **************************************************************************/
      virtual t_Void vPostDAPStatusInfo(t_U32 /*u32DeviceHandle*/, tenDeviceConnectionType /*enDevConnType*/,
               tenDAPStatus /*enDAPStatus*/)
      {

      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclConnMngrResp::vPostDeviceUsagePrefResult
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceUsagePrefResult
       * \brief  It provides the result for Device Usage Preference Set Request
       * \param  coU32DeviceHandle: Device handle for which the device usage
       *         preference was set
       * \param  enErrorCode: Error code if setting device usage preference fails
       * \param  enDeviceCategory: Device Category
       * \param  enUsagePref: indicates whether the device usage preference is enabled or not
       * \param  corfrUsrCtxt : User context
       **************************************************************************/
      virtual t_Void vPostDeviceUsagePrefResult(const t_U32 /*coU32DeviceHandle*/, tenErrorCode /*enErrorCode*/,
               tenDeviceCategory /*enDeviceCategory*/, tenEnabledInfo /*enUsagePref*/, const trUserContext & /*corfrUsrCtxt*/)
      {

      }

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclConnMngrResp::vPostDipoRoleSwitchResponse
      ***************************************************************************/
      /*!
      * \fn     vPostDipoRoleSwitchResponse
      * \brief  Post response to DIPO role switch request
      * \param  [IN] enRoleswitchRes : USB role switch required or not response
      * \param  [IN] rfcorUsrCntxt : User context
      * \sa
      **************************************************************************/
      virtual t_Void vPostDipoRoleSwitchResponse(tenRoleSwitchResponse /*enRoleswitchRes*/,const t_U32 /*cou32DeviceHandle*/,
            const trUserContext& /*rfcorUsrCntxt*/,trEAPAppInfo& /*rfrEAPAppInfo*/)
      {

      }

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclConnMngrResp::vPostDeleteDevice(...
      ***************************************************************************/
      /*!
      * \fn     vPostDeleteDevice()
      * \brief  Interface to notify delete device result to the client.
      * \param
      * \param  .
      * \sa
      **************************************************************************/
      virtual t_Void vPostDeleteDevice(const std::vector<t_U32> /*vecrDeleteDeviceResult*/,
         const tenResponseCode /*enResponseCode*/,const trUserContext& /*rfcorUsrCntxt*/)
      {

      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclConnMngrResp::vPostDeviceInfoList
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceInfoList(const std::vector<trDeviceInfo>& corfvecDeviceInfoList,
               const trUserContext &corfrUsrCntxt)
       * \brief  Interface to send device list details
       * \param  [IN] corfvecDeviceInfoList : SPI device list
       * \param  [IN] corfrUsrCntxt   : User context info
       **************************************************************************/
      virtual t_Void vPostDeviceInfoList(const std::vector<trDeviceInfo>& /*corfvecDeviceInfoList*/,
               const trUserContext & /*corfrUsrCntxt*/)
      {

      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclConnMngrResp::vPostDeviceList
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceList(const std::vector<trDeviceInfo>& corfvecDeviceInfoList,
               const trUserContext &corfrUsrCntxt)
       * \brief  Interface to send device list details
       * \param  [IN] corfvecDeviceInfoList : SPI device list
       * \param  [IN] corfrUsrCntxt   : User context info
       **************************************************************************/
      virtual t_Void vPostDeviceList(const std::vector<trDeviceInfo>& /*corfvecDeviceInfoList*/,
               const trUserContext & /*corfrUsrCntxt*/)
      {

      }
//!@TODO SPI : Application metadata will not be posted with the unfified disocverer changes. This needs to be implemented



};
#endif // SPI_TCLCONNMNGRRESP_H_
