/***********************************************************************/
/*!
* \file  spi_tclDiscoveryResp.h
* \brief AAP Discoverer Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    AAP Discoverer Output Interface
AUTHOR:         Pruthvi Thej Nagaraju
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                   | Modification
03.03.2015  | Pruthvi Thej Nagaraju    | Initial Version
\endverbatim
*************************************************************************/

#ifndef SPI_TCLDISCOVERYRESP_H_
#define SPI_TCLDISCOVERYRESP_H_

#include "RespBase.h"
#include "SPITypes.h"
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiscoveryResp
* \brief ML Discoverer Output Interface
*
* Detects USB devices and provides interface to switch to Android Auto
* updates all the registered clients, whenever there is
* an update on device connections
*
****************************************************************************/
class spi_tclDiscoveryResp:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiscoveryResp::spi_tclDiscoveryResp()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiscoveryResp()
   * \brief   Constructor
   * \sa      ~spi_tclDiscoveryResp()
   **************************************************************************/
   spi_tclDiscoveryResp():RespBase(e16_DISCOVERER_REGID)
   {}

   /***************************************************************************
   ** FUNCTION:  spi_tclDiscoveryResp::~spi_tclDiscoveryResp()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclDiscoveryResp()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclDiscoveryResp(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclDiscoveryResp(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiscoveryResp::vReportDeviceConnection
   ***************************************************************************/
   /*!
   * \fn      t_Void vReportDeviceConnection
   * \brief   To Post the device info to SPI, when a new device is detected
   * \param   corfrDeviceInfo : [IN] const reference to the DeviceInfo structure.
   * \retval  t_Void
   * \sa      vReportDeviceDisconnection(const t_U32 cou32DeviceHandle)
   ***************************************************************************/
   virtual t_Void vReportDeviceConnection(const trDeviceInfo &/*corfrDeviceInfo*/, tenDiscovererType /*enDiscovererType*/){}


   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiscoveryResp::vReportDeviceDisconnection
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vReportDeviceDisconnection
   * \brief   To Post the Device Id to SPI, when a device is disconnected
   * \param   rUserContext : [IN] Context information passed from the caller
   * \param   cou32DeviceHandle    : [IN] Device Id
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vReportDeviceDisconnection(const t_U32 /*cou32DeviceHandle*/, tenDiscovererType /*enDiscovererType*/, tenDeviceConnectionType /*enDeviceConnectionType*/, 
   tenSPISupport /*enCarplaySupport*/){}

   /***************************************************************************
    ** FUNCTION:  spi_tclDiscoveryResp::vReportAuthenticationtatus
    ***************************************************************************/
   /*!
    * \fn     vReportAuthenticationtatus
    * \brief   Callback to Notify the client about  authentication progress
    *          information for a Mirror Link device.
    * \param  [IN] cou32DeviceHandle : Uniquely identifies the target Device.
    * \param  [IN] enDAPStatus : DAP Authentication Progress Status.
    **************************************************************************/
   virtual t_Void vReportAuthenticationtatus(const t_U32 /*cou32DeviceHandle*/,
            tenDAPStatus /*enDAPStatus*/){}

   /***************************************************************************
    ** FUNCTION:  spi_tclDiscoveryResp::vUpdateDeviceName
    ***************************************************************************/
   /*!
    * \fn     vUpdateDeviceName
    * \brief   Callback to Notify the client for updating Device Name
    * \param  [IN] cou32DeviceHandle : Uniquely identifies the target Device.
    * \param  [IN] szDeviceName : Device Name
    * \param  [IN] enDiscovererType: Discoverer type
    ***************************************************************************/
   virtual t_Void vUpdateDeviceName(const t_U32 /*cou32DeviceHandle*/,t_String /*szDeviceName*/, tenDiscovererType /*enDiscovererType*/){}


   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiscoveryResp::vSetDeviceProfile
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vSetDeviceProfile
   * \brief   To Post the Device Id to SPI, when a device is disconnected
   * \param   rUserContext : [IN] Context information passed from the caller
   * \param   cou32DeviceHandle    : [IN] Device Id
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vSetDeviceProfile(const t_U32 , tenDiscovererType , tenDeviceProfile ){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiscoveryResp::vUpdateBTLimitedFunctionality
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vUpdateBTLimitedFunctionality
   * \brief   To Post the BT Limitated Functionality
   * \param   cou32DeviceHandle : [IN] Device Handle
   * \param   m_bIsDeviceBTFunctionalityLimited : [IN] BT Limited functionality is set or not
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vUpdateBTLimitedFunctionality(const t_U32 , tenDiscovererType , t_Bool ){}

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiscoveryResp::spi_tclDiscoveryResp()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiscoveryResp(
   *                          const spi_tclDiscoveryResp& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclDiscoveryResp(RegID enRegId)
   **************************************************************************/
   spi_tclDiscoveryResp(const spi_tclDiscoveryResp& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiscoveryResp& operator=( const spi_tclMLV...
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiscoveryResp& operator=(
   *                          const spi_tclDiscoveryResp& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclDiscoveryResp(const spi_tclDiscoveryResp& otrSrc)
   ***************************************************************************/
   spi_tclDiscoveryResp& operator=(const spi_tclDiscoveryResp& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

};

#endif /* SPI_TCLDISCOVERYRESP_H_ */
