/*!
 *******************************************************************************
 * \file             spi_tclDiscoveryDataIntf.h
 * \brief            Discoverer data interface class
 * \addtogroup       Connectivity
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Discoverer data interface class
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.05.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLDISCOVERYDATAINTF_H_
#define SPI_TCLDISCOVERYDATAINTF_H_

#include "Lock.h"
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
/**
 * \class spi_tclDiscoveryDataIntf
 * \brief Responsible for sharing the required USB device details
 */

class spi_tclDiscoveryDataIntf
{

   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDataIntf::spi_tclDiscoveryDataIntf
       ***************************************************************************/
      /*!
       * \brief   Default Constructor
       **************************************************************************/
      spi_tclDiscoveryDataIntf();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDataIntf::~spi_tclDiscoveryDataIntf()
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclDiscoveryDataIntf();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDeviceListIntf::vSetUSBDeviceDetails
       ***************************************************************************/
      /*!
       * \brief   sets USB Device Details
       * \param   cou32DeviceHandle: Device handle
       * \param   corfrUSBDeviceInfo:[IN] USBDevice information
       **************************************************************************/
      virtual t_Void vSetUSBDeviceDetails(const t_U32 cou32DeviceHandle, trUSBDeviceInfo &corfrUSBDeviceInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDeviceListIntf::vGetUSBDeviceDetails
       ***************************************************************************/
      /*!
       * \brief   Provides USB Device Details
       * \param   cou32DeviceHandle: Device handle
       * \param   rfrUSBDeviceInfo:[OUT] USBDevice information
       **************************************************************************/
      virtual t_Void vGetUSBDeviceDetails(const t_U32 cou32DeviceHandle, trUSBDeviceInfo &rfrUSBDeviceInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBDiscoveryManager::vCopyUSBDeviceInfo
       ***************************************************************************/
      /*!
       * \brief   Returns the stored device ID. Some phones in mirrorlink mode will
       *          will not give serial number. hence this stored ID will be used
       **************************************************************************/
      virtual t_U32 u32GetStoredDeviceID(t_String szManufacturerName, t_String szUUID);

      virtual t_Bool bIsDeviceInfoExists(const t_U32 cou32DeviceHandle);

      virtual t_Void vSetDeviceSwitchInfo(const trDeviceSwitchInfo &corfrDeviceSwitchInfo);
      virtual t_Void vGetDeviceSwitchInfo(const t_U32 cou32DeviceHandle, trDeviceSwitchInfo &corfrDeviceSwitchInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBDiscoveryManager::vSetSwitchRetrialFailCount
       ***************************************************************************/
      /*!
       * \brief   Set switch retrial fail count
       **************************************************************************/
      virtual t_Void vSetSwitchRetrialFailCount(const t_U32 cou32DeviceHandle, t_Bool bFailed);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBDiscoveryManager::vGetSwitchRetrialFailCount
       ***************************************************************************/
      /*!
       * \brief   Get switch retrial count
       **************************************************************************/
      virtual t_U32 u32GetSwitchRetrialFailCount(const t_U32 cou32DeviceHandle);

   private:
      //! Stores USB Device information
      std::map<t_U32, trUSBDeviceInfo> m_mapDeviceInfo;

      //! Lock to protect m_mapDeviceInfo
      Lock m_oLockDeviceInfo;
};

/*! } */

#endif /* SPI_TCLDISCOVERYDATAINTF_H_ */
