/*!
 *******************************************************************************
 * \file              spi_tclUSBDiscovererIntf.h
 * \brief             Device discovery interface
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Device discovery interface
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 26.02.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLUSBDISCOVERERINTF_H_
#define SPI_TCLUSBDISCOVERERINTF_H_

/******************************************************************************
 | includes:
 | 1)AAP - includes
 | 2)Typedefines
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include <functional>
#include "spi_ConnMngrTypeDefines.h"
#include "spi_tclDiscovererSettingsIntf.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
typedef std::function<void(trUSBDeviceInfo&)> tfvDeviceInfo;
struct trUSBDiscovererCbs
{
      //! Informs when a new device is detected
      tfvDeviceInfo fvUSBDeviceConnectionCb;

      //! Property called when there is change in device status
      tfvDeviceInfo fvDeviceDisconnectionCb;


      //! Informs when a new projection device is detected
      tfvDeviceInfo fvProjectionDeviceConnectionCb;


      trUSBDiscovererCbs(): fvUSBDeviceConnectionCb(NULL), fvDeviceDisconnectionCb(NULL), fvProjectionDeviceConnectionCb(NULL)
      {

      }
};
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclUSBDiscovererIntf
 * \brief Device discovery wrapper for Android Auto
 */

class spi_tclUSBDiscovererIntf
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscovererIntf::spi_tclUSBDiscovererIntf();
       ***************************************************************************/
      /*!
       * \brief  Default Constructor
       * \sa      ~spi_tclUSBDiscovererIntf()
       **************************************************************************/
      spi_tclUSBDiscovererIntf() {};

      /***************************************************************************
       ** FUNCTION:  virtual spi_tclUSBDiscovererIntf::~spi_tclUSBDiscovererIntf()
       ***************************************************************************/
      /*!
       * \brief   Destructor
       * \sa      spi_tclUSBDiscovererIntf()
       **************************************************************************/
      virtual ~spi_tclUSBDiscovererIntf() {};

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscovererIntf::bInitialize
       ***************************************************************************/
      /*!
       * \brief  Initializes USB device discovery
       **************************************************************************/
      virtual t_Bool bInitialize(const trUSBDiscovererCbs &corfrDiscovererCbs) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscovererIntf::vUnInitialize
       ***************************************************************************/
      /*!
       * \brief  Uninitializes USB device discovery
       **************************************************************************/
      virtual t_Void  vUnInitialize() = 0 ;

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscovererIntf::s32StartMonitoring
       ***************************************************************************/
      /*!
       * \brief  Start monitoring USB devices. Creates a thread which listens to USB
       *         devices reported (using libraries such as libusb)
       **************************************************************************/
      virtual t_S32  s32StartMonitoring() = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscovererIntf::s32StopMonitoring
       ***************************************************************************/
      /*!
       * \brief  Stop monitoring USB devices
       **************************************************************************/
      virtual t_S32  s32StopMonitoring() = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclUSBDiscovererImpl::vSetDiscoverersettingsInstance(spi_tclDiscovererSettingsIntf* poDiscovererSettingsIntf)
       ***************************************************************************/
       /*!
       * \fn      t_Void vSetDiscoverersettingsInstance()
       * \brief   Method to set discoverer settings instance.
       * \param   poDiscovererSettingsIntf  : pointer to DiscovererSettingsIntf.
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSetDiscoverersettingsInstance(spi_tclDiscovererSettingsIntf* poDiscovererSettingsIntf) = 0;

   private:


      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

};

#endif /* SPI_TCLUSBDISCOVERERINTF_H_ */
