/*!
 *******************************************************************************
 * \file              spi_tclUSBDiscoverer.h
 * \brief             Device discovery wrapper
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Device discovery wrapper
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 08.03.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLUSBDISCOVERERER_H_
#define SPI_TCLUSBDISCOVERERER_H_

/******************************************************************************
 | includes:
 | 1)AAP - includes
 | 2)Typedefinesspi_usb_discoverer_types.h
 |----------------------------------------------------------------------------*/
#include <map>
#include "Lock.h"
#include "Timer.h"
#include "BaseTypes.h"
#include "MsgContext.h"
#include "spi_tclUSBDiscovererIntf.h"
#include "spi_tclDiscovererBase.h"
#include "spi_tclDiscoveryDataIntf.h"
/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclUSBDiscoverer
 * \brief USB Device discovery Manager for all USB devices. Responsible for handling
 * Device detection and device removal for all USB devices except apple devices
 * Uses the discoverer implementing the interface spi_tclUSBDiscovererIntf for USB devices
 */
class spi_tclUSBDiscoverer: public spi_tclDiscovererBase
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/
      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::spi_tclUSBDiscoverer
       ***************************************************************************/
      /*!
       * \brief   Default constructor
       **************************************************************************/
      spi_tclUSBDiscoverer(spi_tclUSBDiscovererIntf* poExtDiscoverer, spi_tclDiscoveryDataIntf* poDiscoveryData);

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::~spi_tclUSBDiscoverer
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclUSBDiscoverer();

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::bInitialize
       ***************************************************************************/
      /*!
       * \brief   Initializes the Discoverer
       * \retval  true if initialization succeeds
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::vUninitialize
       ***************************************************************************/
      /*!
       * \brief   Uninitializes the Discoverer
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::bStartDeviceDetection
       ***************************************************************************/
      /*!
       * \brief   Start device detection/ device monitoring
       * \retval  true on success
       **************************************************************************/
      t_Bool bStartDeviceDetection();

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::vStartDeviceReporting
       ***************************************************************************/
      /*!
       * \brief   Start reporting detected devices
       **************************************************************************/
      t_Void vStartDeviceReporting();

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::vStopDeviceDetection
       ***************************************************************************/
      /*!
       * \brief   Stop detection/ device monitoring
       **************************************************************************/
      t_Void vStopDeviceDetection();

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::vStartDeviceReporting
       ***************************************************************************/
      /*!
       * \brief   Stop reporting detected devices
       **************************************************************************/
      t_Void vStopDeviceReporting();

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBDiscoverer::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \brief   Register discoverer callbacks
       **************************************************************************/
      t_Void vRegisterCallbacks(const trDiscovererCbs corfrDisccbs);

   private:

      /***************************************************************************
       *********************************PRIVATE*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBDiscoverer::vOnUSBDeviceConnectionCb
       ***************************************************************************/
      /*!
       * \brief   Callback from USB discoverer when a new USb device is detected
       * \param   rfrDeviceInfo: Structure containing USB info
       **************************************************************************/
      t_Void vOnUSBDeviceConnectionCb(trUSBDeviceInfo &rfrDeviceInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBDiscoverer::vOnAOAPDeviceConnectionCb
       ***************************************************************************/
      /*!
       * \brief   Callback from USB discoverer when a USB device disappears
       * \param   rfrDeviceInfo: Structure containing USB info
       **************************************************************************/
      t_Void vOnAOAPDeviceConnectionCb(trUSBDeviceInfo &rfrDeviceInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBDiscoverer::vOnDeviceDisconnectionCb
       ***************************************************************************/
      /*!
       * \brief   Callback from discoverer when a device is detected in AOAP mode
       * \param   rfrDeviceInfo: Structure containing USB info
       **************************************************************************/
      t_Void vOnDeviceDisconnectionCb(trUSBDeviceInfo &rfrDeviceInfo);

      //! USB discoverer implementation
      spi_tclUSBDiscovererIntf *m_poExtDiscoverer;

      spi_tclDiscoveryDataIntf* m_poDiscoveryData;



};
#endif // SPI_TCLUSBDISCOVERERER_H_
