/***********************************************************************/
/*!
 * \file  spi_tclDiscoveryMsgQInterface.cpp
 * \brief interface for writing discoverer messages to Message Q to use the MsgQ based
 *        threading model for Dispatching messages received by Discoverer
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing discoverer messages to Message Q to use the MsgQ based
                 threading model for Dispatching messages received by Discoverer
 AUTHOR:         Pruthvi Thej Nagaraju
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 17.06.2016  | Pruthvi Thej Nagaraju | Initial Version

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "MsgQThreader.h"
#include "spi_tclDiscoveryMsgQThreadable.h"
#include "spi_tclDiscoveryMsgQInterface.h"
#include "MessageQueue.h"
#include "SPITypes.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclDiscoveryMsgQInterface.cpp.trc.h"
   #endif
#endif

using namespace shl::thread;

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryMsgQInterface::spi_tclDiscoveryMsgQInterface()
 ***************************************************************************/
spi_tclDiscoveryMsgQInterface::spi_tclDiscoveryMsgQInterface() :
   m_poDiscoveryMsgQThreadable(NULL), m_poDiscoveryMsgQThreader(NULL)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   m_poDiscoveryMsgQThreadable = new spi_tclDiscoveryMsgQThreadable();
   SPI_NORMAL_ASSERT(NULL == m_poDiscoveryMsgQThreadable);
   m_poDiscoveryMsgQThreader = new MsgQThreader(m_poDiscoveryMsgQThreadable);
   SPI_NORMAL_ASSERT(NULL == m_poDiscoveryMsgQThreader);
   if(NULL != m_poDiscoveryMsgQThreader)
   {
      m_poDiscoveryMsgQThreader->bRunThread();
      m_poDiscoveryMsgQThreader->vSetThreadName("DISCQ");
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryMsgQInterface::~spi_tclDiscoveryMsgQInterface()
 ***************************************************************************/
spi_tclDiscoveryMsgQInterface::~spi_tclDiscoveryMsgQInterface()
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   RELEASE_MEM(m_poDiscoveryMsgQThreader);
   RELEASE_MEM(m_poDiscoveryMsgQThreadable);
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryMsgQInterface::bWriteMsgToQ
 ***************************************************************************/
t_Bool spi_tclDiscoveryMsgQInterface::bWriteMsgToQ(trMsgBase *prMsgBase,
         t_U32 u32MsgSize)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   t_Bool bRetQ = false;

   if (NULL != m_poDiscoveryMsgQThreader)
   {
      //! Get the MsgQ form threader and push the message to Q
      MessageQueue *poMsgQ = m_poDiscoveryMsgQThreader->poGetMessageQueu();
      if ((NULL != poMsgQ) && (NULL != prMsgBase))
      {
         t_S32 s32RetMsgQ = poMsgQ->s16Push(static_cast<t_Void*>(prMsgBase), u32MsgSize);
         bRetQ = (0 == s32RetMsgQ);
      } // if ((NULL != poMsgQ) && (NULL != prMsgBase))
   } //if (NULL != m_poDiscoveryMsgQThreader)

   if(bRetQ == false)
   {
      ETG_TRACE_ERR(("spi_tclDiscoveryMsgQInterface::bWriteMsgToQ: Write to MsgQ failed  \n"));
   }
   return bRetQ;
}
