/***********************************************************************/
/*!
 * \file  spi_tclDiscoveryDispatcher.cpp
 * \brief Message Dispatcher for SPI Discoverer Messages.
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for SPI Discoverer Messages. Implemented using
 double dispatch mechanism
 AUTHOR:         Pruthvi Thej Nagaraju
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                        | Modification
 17.06.2016  | Pruthvi Thej Nagaraju         | Initial Version
 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclDiscoveryDispatcher.h"
#include "spi_tclDiscoveryResp.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclDiscoveryDispatcher.cpp.trc.h"
#endif
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//! Macro to define message dispatch function

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleDiscovererMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}


/***************************************************************************
 ** FUNCTION:  DeviceInfoMsg::DeviceInfoMsg
 ***************************************************************************/
DeviceInfoMsg::DeviceInfoMsg() :  m_prDeviceInfo(NULL), m_enDiscovererType(e8_DISCOVERER_TYPE_UNKNOWN)
{
   vSetServiceID(e32MESSAGEID_DISCOVERER_DEVICEINFO);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DeviceInfoMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DeviceInfoMsg, spi_tclDiscoveryDispatcher);

/***************************************************************************
 ** FUNCTION:  DeviceInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void DeviceInfoMsg::vAllocateMsg()
{
   m_prDeviceInfo = new trDeviceInfo;
   SPI_NORMAL_ASSERT(NULL == m_prDeviceInfo);
}

/***************************************************************************
 ** FUNCTION:  DeviceInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DeviceInfoMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prDeviceInfo);
}

/***************************************************************************
 ** FUNCTION:  DeviceDisconnectionMsg::DeviceDisconnectionMsg
 ***************************************************************************/
DeviceDisconnectionMsg::DeviceDisconnectionMsg(): m_u32DeviceHandle(0), m_enDiscovererType(e8_DISCOVERER_TYPE_USB), m_enDeviceConnectionType(e8UNKNOWN_CONNECTION),
         m_enCarplaySupport(e8SPI_SUPPORT_UNKNOWN)
{
   vSetServiceID(e32MESSAGEID_DISCOVERER_DEVICEDISCONNECTION);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DeviceDisconnectionMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DeviceDisconnectionMsg, spi_tclDiscoveryDispatcher);

/***************************************************************************
 ** FUNCTION:  AuthenticationStatusMsg::AuthenticationStatusMsg
 ***************************************************************************/
AuthenticationStatusMsg::AuthenticationStatusMsg(): m_u32DeviceHandle(0), m_enDAPStatus(e8DAP_UNKNOWN)
{
   vSetServiceID(e32MESSAGEID_DISCOVERER_AUTHENTICATIONSTATUS);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  AuthenticationStatusMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AuthenticationStatusMsg, spi_tclDiscoveryDispatcher);

/***************************************************************************
 ** FUNCTION:  UpdateDeviceNameMsg::UpdateDeviceNameMsg
 ***************************************************************************/
UpdateDeviceNameMsg::UpdateDeviceNameMsg()
{

   m_u32DeviceHandle = 0x00;
   m_enDiscovererType = e8_DISCOVERER_TYPE_UNKNOWN;
   m_szDeviceName = new t_String;
   SPI_NORMAL_ASSERT(NULL == m_szDeviceName);

}

/***************************************************************************
 ** FUNCTION:  UpdateDeviceNameMsg::UpdateDeviceNameMsg
 ***************************************************************************/
UpdateDeviceNameMsg::UpdateDeviceNameMsg(t_U32 u32DeviceHandle, t_String szDeviceName, tenDiscovererType enDiscovererType):
         m_u32DeviceHandle(0), m_szDeviceName(NULL), m_enDiscovererType(e8_DISCOVERER_TYPE_UNKNOWN)
{
   vSetServiceID(e32MESSAGEID_DISCOVERER_DEVICENAMEUPDATE);
   vAllocateMsg();
   m_u32DeviceHandle = u32DeviceHandle;
   m_enDiscovererType = enDiscovererType;
   if(NULL != m_szDeviceName)
   {
      *(m_szDeviceName) = szDeviceName;
   }
}
/***************************************************************************
 ** FUNCTION:  UpdateDeviceNameMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(UpdateDeviceNameMsg, spi_tclDiscoveryDispatcher);

/***************************************************************************
 ** FUNCTION:  UpdateDeviceNameMsg::vAllocateMsg
 ***************************************************************************/
t_Void UpdateDeviceNameMsg::vAllocateMsg()
{
   m_szDeviceName = new t_String;
   SPI_NORMAL_ASSERT(NULL == m_szDeviceName);
}

/***************************************************************************
 ** FUNCTION:  UpdateDeviceNameMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void UpdateDeviceNameMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_szDeviceName);
}

/***************************************************************************
 ** FUNCTION:  DeviceProfileMsg::DeviceProfileMsg
 ***************************************************************************/
DeviceProfileMsg::DeviceProfileMsg(): m_u32DeviceHandle(0), m_enDiscovererType(e8_DISCOVERER_TYPE_APPLE), m_enDeviceProfile(e8_PROFILE_UNKNOWN)
{
   vSetServiceID(e32MESSAGEID_DISCOVERER_DEVICEPROFILE);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DeviceProfileMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DeviceProfileMsg, spi_tclDiscoveryDispatcher);

/***************************************************************************
 ** FUNCTION:  BTLimitationStateMsg::BTLimitationStateMsg
 ***************************************************************************/
BTLimitationStateMsg::BTLimitationStateMsg(): m_u32DeviceHandle(0), m_enDiscovererType(e8_DISCOVERER_TYPE_APPLE), m_bIsDeviceBTFunctionalityLimited(false)
{
   vSetServiceID(e32MESSAGEID_DISCOVERER_BTLIMITATIONSTATE);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BTLimitationStateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTLimitationStateMsg, spi_tclDiscoveryDispatcher);

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::spi_tclDiscoveryDispatcher
 ***************************************************************************/
spi_tclDiscoveryDispatcher::spi_tclDiscoveryDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiscoveryDispatcher::spi_tclDiscoveryDispatcher() entered \n"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::~spi_tclDiscoveryDispatcher
 ***************************************************************************/
spi_tclDiscoveryDispatcher::~spi_tclDiscoveryDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiscoveryDispatcher::~spi_tclDiscoveryDispatcher() entered \n"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg) const
{
   ETG_TRACE_USR1(("  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg) entered \n"));
   if ((NULL != poDeviceInfoMsg) && (NULL != poDeviceInfoMsg->m_prDeviceInfo))
   {
      CALL_REG_OBJECTS(spi_tclDiscoveryResp,
               e16_DISCOVERER_REGID,
               vReportDeviceConnection(*(poDeviceInfoMsg->m_prDeviceInfo), poDeviceInfoMsg->m_enDiscovererType));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceDisconnectionMsg* poDeviceDisconnMsg)
 ***************************************************************************/
t_Void spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceDisconnectionMsg* poDeviceDisconnMsg) const
{
   ETG_TRACE_USR1((" spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceDisconnectionMsg* poDeviceDisconnMsg) entered \n"));
   if (NULL != poDeviceDisconnMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiscoveryResp,
               e16_DISCOVERER_REGID,
               vReportDeviceDisconnection(poDeviceDisconnMsg->m_u32DeviceHandle, poDeviceDisconnMsg->m_enDiscovererType, poDeviceDisconnMsg->m_enDeviceConnectionType,
                        poDeviceDisconnMsg->m_enCarplaySupport));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(AuthenticationStatusMsg* poAuthMsg)
 ***************************************************************************/
t_Void spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(AuthenticationStatusMsg* poAuthMsg) const
{
   ETG_TRACE_USR1((" spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(AuthenticationStatusMsg* poDeviceDisconnMsg) entered \n"));
   if (NULL != poAuthMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiscoveryResp,
               e16_DISCOVERER_REGID,
               vReportAuthenticationtatus(poAuthMsg->m_u32DeviceHandle, poAuthMsg->m_enDAPStatus));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(UpdateDeviceNameMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(UpdateDeviceNameMsg* poUpdateDeviceNameMsg) const
{
   ETG_TRACE_USR1(("  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(UpdateDeviceNameMsg* poDeviceInfoMsg) entered \n"));
   if ((NULL != poUpdateDeviceNameMsg) && (NULL != poUpdateDeviceNameMsg->m_szDeviceName))
   {
      CALL_REG_OBJECTS(spi_tclDiscoveryResp,
               e16_DISCOVERER_REGID,
               vUpdateDeviceName(poUpdateDeviceNameMsg->m_u32DeviceHandle, *(poUpdateDeviceNameMsg->m_szDeviceName), poUpdateDeviceNameMsg->m_enDiscovererType));
   } // if (NULL != UpdateDeviceNameMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceProfileMsg* poDeviceProfileMsg)
 ***************************************************************************/
t_Void spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceProfileMsg* poDeviceProfileMsg) const
{
   ETG_TRACE_USR1((" spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceProfileMsg* poDeviceProfileMsg) entered \n"));
   if (NULL != poDeviceProfileMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiscoveryResp,
               e16_DISCOVERER_REGID,
               vSetDeviceProfile(poDeviceProfileMsg->m_u32DeviceHandle, poDeviceProfileMsg->m_enDiscovererType, poDeviceProfileMsg->m_enDeviceProfile));
   } // if (NULL != poDeviceInfoMsg)
}


/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(BTLimitationStateMsg* poBTLimitationStateMsg)
 ***************************************************************************/
t_Void spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(BTLimitationStateMsg* poBTLimitationStateMsg) const
{
   ETG_TRACE_USR1((" spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(BTLimitationStateMsg* poBTLimitationStateMsg) entered \n"));
   if (NULL != poBTLimitationStateMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiscoveryResp,
               e16_DISCOVERER_REGID,
               vUpdateBTLimitedFunctionality(poBTLimitationStateMsg->m_u32DeviceHandle, poBTLimitationStateMsg->m_enDiscovererType, poBTLimitationStateMsg->m_bIsDeviceBTFunctionalityLimited));
   } // if (NULL != poDeviceInfoMsg)
}
