/*!
 *******************************************************************************
 * \file             spi_tclDeviceSwitcherFactory.cpp
 * \brief            DeviceSwitcher Factory: Creates DeviceSwitchers
 * \addtogroup       Connectivity
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    DeviceSwitcher Factory: Creates DeviceSwitchers
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.05.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/


#include "spi_tclDeviceSwitcherFactory.h"
#include "spi_tclDeviceSwitcher.h"
#include "spi_tclAAPSwitch.h"
#include "spi_tclCarplaySwitch.h"
#include "spi_tclmySPINSwitch.h"
#ifdef VARIANT_S_FTR_ENABLE_SPI_BAIDU_CARLIFE
#include "spi_tclBDCLSwitch.h"
#endif

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/spi_tclDeviceSwitcherFactory.cpp.trc.h"
#endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceSwitcherFactory::spi_tclDeviceSwitcherFactory
 ***************************************************************************/
spi_tclDeviceSwitcherFactory::spi_tclDeviceSwitcherFactory()
{
   ETG_TRACE_USR1(("spi_tclDeviceSwitcherFactory::spi_tclDeviceSwitcherFactory\n"));

}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceSwitcherFactory::~spi_tclDeviceSwitcherFactory
 ***************************************************************************/
spi_tclDeviceSwitcherFactory::~spi_tclDeviceSwitcherFactory()
{
   ETG_TRACE_USR1(("spi_tclDeviceSwitcherFactory::spi_tclDeviceSwitcherFactory \n "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceSwitcherFactory::poGetDeviceSwitcherInstance
 ***************************************************************************/
spi_tclDeviceSwitchBase* spi_tclDeviceSwitcherFactory::poGetDeviceSwitcherInstance(tenDeviceCategory enDeviceSwitcherType)
{
   ETG_TRACE_USR1(("[DESC] spi_tclDeviceSwitcherFactory::poGetDeviceSwitcherInstance enDiscoverrType = %d\n", ETG_ENUM(DeviceSwitcher_TYPE, enDeviceSwitcherType)));

   spi_tclDeviceSwitchBase* poDeviceSwitcherInstance = NULL;
   m_oDeviceDeviceSwitcherLock.s16Lock();
   if(m_mapDeviceDeviceSwitchers.end() != m_mapDeviceDeviceSwitchers.find(enDeviceSwitcherType))
   {
      poDeviceSwitcherInstance = m_mapDeviceDeviceSwitchers[enDeviceSwitcherType];
   }
   m_oDeviceDeviceSwitcherLock.vUnlock();
   return poDeviceSwitcherInstance;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher
 ***************************************************************************/
t_Void spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher(tenDeviceCategory enDeviceSwitcherType)
{
   ETG_TRACE_USR1(("[DESC]spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher enDiscoverrType = %d\n", ETG_ENUM(DeviceSwitcher_TYPE, enDeviceSwitcherType)));

   switch (enDeviceSwitcherType)
   {
      case e8DEV_TYPE_DIPO:
      {
         //! Create Carplay DeviceSwitcher
         m_oDeviceDeviceSwitcherLock.s16Lock();
         m_mapDeviceDeviceSwitchers[e8DEV_TYPE_DIPO] = new spi_tclCarplaySwitch();
         SPI_NORMAL_ASSERT(NULL == m_mapDeviceDeviceSwitchers[e8DEV_TYPE_DIPO]);
         m_oDeviceDeviceSwitcherLock.vUnlock();
      }
         break;
      case e8DEV_TYPE_MIRRORLINK:
      {
         //! Create Mirrorlink DeviceSwitcher
         m_oDeviceDeviceSwitcherLock.s16Lock();
		 
#ifdef VARIANT_S_FTR_ENABLE_SPI_MIRRORLINK
         if ((NULL != DeviceSwitch[e8DEV_TYPE_MIRRORLINK]))
         {
            ETG_TRACE_USR1((" spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher before obj create m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MIRRORLINK] = %p", m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MIRRORLINK]));
            //m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MIRRORLINK] = new spi_tclMLSwitch();
            //m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MIRRORLINK] = DeviceSwitch[e8DEV_TYPE_MIRRORLINK]();
            SPI_NORMAL_ASSERT(NULL == m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MIRRORLINK]);
         }
         ETG_TRACE_USR1((" spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher obj success m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MIRRORLINK] = %p", m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MIRRORLINK]));
#endif

         m_oDeviceDeviceSwitcherLock.vUnlock();
      }
         break;
      case e8DEV_TYPE_ANDROIDAUTO:
      {
         //! Create Android Auto DeviceSwitcher
         m_oDeviceDeviceSwitcherLock.s16Lock();
         m_mapDeviceDeviceSwitchers[e8DEV_TYPE_ANDROIDAUTO] = new spi_tclAAPSwitch();
         SPI_NORMAL_ASSERT(NULL == m_mapDeviceDeviceSwitchers[e8DEV_TYPE_ANDROIDAUTO]);
         m_oDeviceDeviceSwitcherLock.vUnlock();
      }
         break;
      case e8DEV_TYPE_MYSPIN:
      {
         //! Create mySPIN DeviceSwitcher
         m_oDeviceDeviceSwitcherLock.s16Lock();
         m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MYSPIN] = new spi_tclmySPINSwitch();
         SPI_NORMAL_ASSERT(NULL == m_mapDeviceDeviceSwitchers[e8DEV_TYPE_MYSPIN]);
         m_oDeviceDeviceSwitcherLock.vUnlock();
      }
         break;
#ifdef VARIANT_S_FTR_ENABLE_SPI_BAIDU_CARLIFE
      case e8DEV_TYPE_CARLIFE:
      {
         //! Create Baidu Carlife DeviceSwitcher
         m_oDeviceDeviceSwitcherLock.s16Lock();
         m_mapDeviceDeviceSwitchers[e8DEV_TYPE_CARLIFE] = new spi_tclBDCLSwitch();
         SPI_NORMAL_ASSERT(NULL == m_mapDeviceDeviceSwitchers[e8DEV_TYPE_CARLIFE]);
         m_oDeviceDeviceSwitcherLock.vUnlock();
      }
         break;
#endif
      default:
      {
         ETG_TRACE_ERR(("[ERR] spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher unknown DeviceSwitcher type = %d\n",
                  ETG_ENUM(DeviceSwitcher_TYPE, enDeviceSwitcherType)));
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher
 ***************************************************************************/
t_Void spi_tclDeviceSwitcherFactory::vDestroyDeviceSwitcher(tenDeviceCategory enDeviceSwitcherType)
{
   ETG_TRACE_USR1(("[DESC] spi_tclDeviceSwitcherFactory::vDestroyDeviceSwitcher enDiscoverrType = %d\n", ETG_ENUM(DeviceSwitcher_TYPE, enDeviceSwitcherType)));

   m_oDeviceDeviceSwitcherLock.s16Lock();
   if (m_mapDeviceDeviceSwitchers.end() != m_mapDeviceDeviceSwitchers.find(enDeviceSwitcherType))
   {
      RELEASE_MEM(m_mapDeviceDeviceSwitchers[enDeviceSwitcherType]);
   }
   m_oDeviceDeviceSwitcherLock.vUnlock();
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceSwitcherFactory::u32GetNoofDeviceSwitchers
 ***************************************************************************/
t_U32 spi_tclDeviceSwitcherFactory::u32GetNoofDeviceSwitchers()
{
   m_oDeviceDeviceSwitcherLock.s16Lock();
   t_U32 u32NoofDeviceSwitchers = static_cast<t_U32>( m_mapDeviceDeviceSwitchers.size());
   m_oDeviceDeviceSwitcherLock.vUnlock();
   ETG_TRACE_USR1(("[DESC] spi_tclDeviceSwitcherFactory::u32GetNoofDeviceSwitchers : No of DeviceSwitchers = %d ", u32NoofDeviceSwitchers));
   return u32NoofDeviceSwitchers;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceSwitcherFactory::u32GetNoofDeviceSwitchers
 ***************************************************************************/
t_Void spi_tclDeviceSwitcherFactory::vGetDeviceSwitchers(std::vector<spi_tclDeviceSwitchBase*> &rfvecDeviceSwitchers)
{
   std::map<tenDeviceCategory, spi_tclDeviceSwitchBase*>::iterator itmapDeviceSwitchers;
   m_oDeviceDeviceSwitcherLock.s16Lock();
   t_U8 u8NofDeviceSwitchers = static_cast<t_U8>(m_mapDeviceDeviceSwitchers.size());
   for(itmapDeviceSwitchers = m_mapDeviceDeviceSwitchers.begin(); itmapDeviceSwitchers != m_mapDeviceDeviceSwitchers.end(); itmapDeviceSwitchers++)
   {
      rfvecDeviceSwitchers.push_back(itmapDeviceSwitchers->second);
   }
   m_oDeviceDeviceSwitcherLock.vUnlock();
   ETG_TRACE_USR1(("[DESC] spi_tclDeviceSwitcherFactory::vGetDeviceSwitchers u8NofDeviceSwitchers = %d\n", u8NofDeviceSwitchers));
}
