/*
 * spi_tclUSBResetIntf.h
 *
 *  Created on: Mar 28, 2017
 *      Author: ptr4kor
 */

#ifndef GENERIC_COMMON_CONNMNGR_DISCOVERER_DEVICESWITCHER_INC_SPI_TCLUSBRESETINTF_H_
#define GENERIC_COMMON_CONNMNGR_DISCOVERER_DEVICESWITCHER_INC_SPI_TCLUSBRESETINTF_H_

#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
#include "spi_tclDiscoveryDataIntf.h"


//! Stores USB reset retrial information
struct trUSBResetInfo
{
      timer_t oTimerID;
      t_U32 u32RetryCount;
      trUSBResetInfo(): oTimerID(0), u32RetryCount(0)
      {

      }
};

/**
 * \class spi_tclUSBResetIntf
 * \brief  ML device switcher. Reponsible for sending mirrorlink command to USB devices
 */

class spi_tclUSBResetIntf
{

   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclUSBResetIntf::spi_tclUSBResetIntf
       ***************************************************************************/
      /*!
       * \brief   Default Constructor
       **************************************************************************/
      spi_tclUSBResetIntf(){};

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBResetIntf::~spi_tclUSBResetIntf()
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclUSBResetIntf(){};

      /***************************************************************************
       ** FUNCTION:  t_U32 spi_tclUSBResetIntf::bResetUSBDevice
       ***************************************************************************/
      /*!
       * \fn      t_U32 bResetUSBDevice()
       * \brief   Trigger a USB profile switch to re-enumerate the device in default USB Mode
       * \param   rfrDeviceInfo : Contains information of the USB device
       **************************************************************************/
      virtual t_Bool bResetUSBDevice(const trUSBDeviceInfo &rfrDeviceInfo) = 0;


      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBResetIntf::vStopUSBResetRetrial
       ***************************************************************************/
      /*!
       * \fn      t_Void vStopUSBResetRetrial()
       * \brief   Stops USB Reset retrial
       * \param   cou32DeviceHandle: Device handle
       * \sa      bSwitchToUSBMode()
       **************************************************************************/
      virtual t_Void vStopUSBResetRetrial(const t_U32 cou32DeviceHandle) =0;

   private:


};
/*! } */


#endif /* GENERIC_COMMON_CONNMNGR_DISCOVERER_DEVICESWITCHER_INC_spi_tclUSBResetIntfINTF_H_ */
