/*!
 *******************************************************************************
 * \file             spi_tclDeviceSwitcherFactory.h
 * \brief            DeviceSwitcher Factory: Creates Device Switchers
 * \addtogroup       Device Switcher
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    DeviceSwitcher Factory: Creates DeviceSwitchers
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.05.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/


#ifndef SPI_TCLDEVICESWITCHERFACTORY_H_
#define SPI_TCLDEVICESWITCHERFACTORY_H_


#include <map>
#include "Lock.h"
#include "spi_tclDeviceSwitchBase.h"
#include "GenericSingleton.h"

/**
 * \class spi_tclDeviceSwitcherFactory
 * \brief Responsible for DeviceSwitcher creation
 */

class spi_tclDeviceSwitcherFactory: public GenericSingleton<spi_tclDeviceSwitcherFactory>
{

   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcherFactory::spi_tclDeviceSwitcherFactory
       ***************************************************************************/
      /*!
       * \brief   Default Constructor
       **************************************************************************/
      spi_tclDeviceSwitcherFactory();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcherFactory::~spi_tclDeviceSwitcherFactory
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclDeviceSwitcherFactory();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcherFactory::poGetDeviceSwitcherInstance
       ***************************************************************************/
      /*!
       * \brief   Get the device switcher instance for the DeviceSwitcher type specified by enDeviceSwitcherType
       * \param   enDeviceSwitcherType: Type of the DeviceSwitcher
       * \retval  spi_tclDeviceSwitchBase*: pointer to the DeviceSwitcher instance
       **************************************************************************/
      spi_tclDeviceSwitchBase* poGetDeviceSwitcherInstance(tenDeviceCategory enDeviceSwitcherType);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher
       ***************************************************************************/
      /*!
       * \brief   Create the DeviceSwitcher specified by enDeviceSwitcherType
       * \param   enDeviceSwitcherType: Type of the DeviceSwitcher
       **************************************************************************/
      t_Void vCreateDeviceSwitcher(tenDeviceCategory enDeviceSwitcherType);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcherFactory::vCreateDeviceSwitcher
       ***************************************************************************/
      /*!
       * \brief   Destroys the DeviceSwitcher specified by enDeviceSwitcherType
       * \param   enDeviceSwitcherType: Type of the DeviceSwitcher
       **************************************************************************/
      t_Void vDestroyDeviceSwitcher(tenDeviceCategory enDeviceSwitcherType);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcherFactory::u32GetNoofDeviceSwitchers
       ***************************************************************************/
      /*!
       * \brief   Returns the number of DeviceSwitchers created
       * \retval   t_U32: No of DeviceSwitchers
       **************************************************************************/
      t_U32 u32GetNoofDeviceSwitchers();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcherFactory::u32GetNoofDeviceSwitchers
       ***************************************************************************/
      /*!
       * \brief   Returns the instances of DeviceSwitchers created
       * \param   [OUT]rfvecDeviceSwitchers: Vector with the instances of created device switchers
       **************************************************************************/
      t_Void vGetDeviceSwitchers(std::vector<spi_tclDeviceSwitchBase*> &rfvecDeviceSwitchers);

   private:

      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/
      friend class GenericSingleton<spi_tclDeviceSwitcherFactory> ;

      //! Stores the created DeviceSwitchers
      std::map<tenDeviceCategory, spi_tclDeviceSwitchBase*> m_mapDeviceDeviceSwitchers;

      //! Lock to protect the DeviceSwitcher map
      Lock m_oDeviceDeviceSwitcherLock;

};
/*! } */
#endif // SPI_TCLDEVICESWITCHERFACTORY_H_
