/*!
 *******************************************************************************
 * \file             spi_tclCarplaySwitch.h
 * \brief            Carplay device switcher
 * \addtogroup       Device Switcher
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:     Carplay device switcher
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.06.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLCARPLAYSWITCH_H_
#define SPI_TCLCARPLAYSWITCH_H_

#include "Lock.h"
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
#include "spi_tclDeviceSwitchBase.h"
#include "spi_tclExtRespRoleSwitch.h"
#include <queue>

/**
 * \class spi_tclCarplaySwitch
 * \brief  Carplay device switcher. Responsible for requesting role switch for carplay devices.
 * This calss forwards the request to mediaplayer for the role switch
 */

class spi_tclCarplaySwitch: public spi_tclDeviceSwitchBase, public spi_tclExtRespRoleSwitch
{

   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclCarplaySwitch::spi_tclCarplaySwitch
       ***************************************************************************/
      /*!
       * \brief   Default Constructor
       **************************************************************************/
      spi_tclCarplaySwitch();

      /***************************************************************************
       ** FUNCTION:  spi_tclCarplaySwitch::~spi_tclCarplaySwitch()
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclCarplaySwitch();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitcher::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \brief   Register discoverer callbacks
       * \brief   corfrSwitchCbs: Structure containing the function pointers to be invoked
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trDeviceSwitcherCbs corfrSwitchCbs);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitchBase::enSwitchDeviceMode
       ***************************************************************************/
      /*!
       * \brief   Switch the connection profile of the device
       * \param   enDeviceCat: SPI technology to which the device has to be switched to
       * \param   enDeviceSwitchType: Device Switch type
       * \param   rfrDeviceSwitchInfo: Device switch Information
       * \retval   tenDeviceSwitchResult: Indicates result of device switch
       **************************************************************************/
      virtual tenDeviceSwitchResult enSwitchDeviceMode(const trUSBDeviceInfo &rfrDeviceInfo,
               trDeviceSwitchInfo &rfrDeviceSwitchInfo, tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE);
   protected:

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclExtRespRoleSwitch::vPostRoleSwitchCompleteMsg()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostRoleSwitchCompleteMsg()
       * \brief   Called when role switch completes
       * \param   cou32DeviceHandle:Device handle
       * \param   bSwitchStatus: Role Switch status
       * \sa      None
       **************************************************************************/
      t_Void vPostRoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus);

   private:

      trDeviceSwitcherCbs m_rSwitcherCbs;
      t_U32 m_u32RoleSwitchDeviceHandle;
};
/*! } */



#endif /* SPI_TCLCARPLAYSWITCH_H_ */
