/*!
 *******************************************************************************
 * \file             spi_tclAudioInBase.cpp
 * \brief            Base class for Audio Input Handling
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Base class for Audio Input Handling
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 21.03.2014 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/
#include <pthread.h>
#include "ThreadNamer.h"
#include "spi_tclAudioInBase.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_AUDIO
#include "trcGenProj/Header/spi_tclAudioInBase.cpp.trc.h"
#endif
#endif

//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclAudioInBase::spi_tclAudioInBase
 ***************************************************************************/
spi_tclAudioInBase::spi_tclAudioInBase(): m_poMainLoop(NULL)
{
}

/***************************************************************************
 ** FUNCTION:  spi_tclAudioInBase::~spi_tclAudioInBase
 ***************************************************************************/
spi_tclAudioInBase::~spi_tclAudioInBase()
{
   if (g_main_loop_is_running (m_poMainLoop))
   {
      //! Stop the Main loop
      g_main_loop_quit(m_poMainLoop);
   }
   //! Release the memory of m_poMainLoop.
   g_main_loop_unref(m_poMainLoop);
   m_poMainLoop = NULL;
}

/***************************************************************************
 *********************************PRIVATE***********************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclAudioInBase::vExecute
 ***************************************************************************/
t_Void spi_tclAudioInBase::vExecute()
{
   ETG_TRACE_USR1((" spi_tclAudioInBase::vExecute %d \n",pthread_self()));
   DEFINE_THREAD_NAME("AudioIn");

   t_Bool bResult= bSubscribeForAudioIn();
   //! Create the main loop instance, uses default context
   m_poMainLoop = g_main_loop_new(NULL, FALSE);

   if ((NULL != m_poMainLoop)&& (true == bResult))
   {
      //!Start Main loop
      g_main_loop_run(m_poMainLoop);
   }
   else
   {
      ETG_TRACE_ERR(("spi_tclAudioInBase::vStartMainLoop: g_main_loop_new failed \n"));
   }
}

//lint restore
