/*!
 *******************************************************************************
 * \file         spi_tclAudioDevBase.cpp
 * \brief        Main Audio class that provides interface to delegate 
                 the execution of command and handle response
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3 Projects
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Base class for ML and DiPO Interfaces
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                                  | Modifications
 28.10.2013 |  Hari Priya E R(RBEI/ECP2)               | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
//#define VNC_USE_STDINT_H

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_AUDIO
#include "trcGenProj/Header/spi_tclAudioDevBase.cpp.trc.h"
#endif
#endif
#include "spi_tclAudioDevBase.h"


/***************************************************************************
** FUNCTION:  spi_tclAudioDevBase::spi_tclAudioDevBase();
***************************************************************************/
spi_tclAudioDevBase::spi_tclAudioDevBase():m_bIsLastModeSupported(false),
m_poAudioSettings(NULL)
{
	ETG_TRACE_USR1(("spi_tclAudioDevBase::spi_tclAudioDevBase()"));
}

/***************************************************************************
** FUNCTION:  spi_tclAudioDevBase::~spi_tclAudioDevBase();
***************************************************************************/
spi_tclAudioDevBase::~spi_tclAudioDevBase()
{
	ETG_TRACE_USR1(("spi_tclAudioDevBase::~spi_tclAudioDevBase()"));
	m_poAudioSettings = NULL;
}

/***************************************************************************
** FUNCTION: t_Bool spi_tclAudioDevBase::vSetLastModeSupport()
***************************************************************************/
t_Void spi_tclAudioDevBase::vSetLastModeSupport(t_Bool bSupported)
{
   ETG_TRACE_USR1(("spi_tclAudioDevBase::vSetLastModeSupport entered: %d", ETG_ENUM(BOOL, bSupported)));
   m_bIsLastModeSupported = bSupported;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAudioDevBase::vSetAudioSettingsInstance()
***************************************************************************/
t_Void spi_tclAudioDevBase::vSetAudioSettingsInstance(spi_tclAudioSettingsIntf* poAudioSettingsIntf)
{
   ETG_TRACE_USR1(("spi_tclAudioInBase::vSetAudioSettingsInstance entered"));
   if( NULL != poAudioSettingsIntf)
   {
	   ETG_TRACE_USR1(("spi_tclAudioInBase::vSetAudioSettingsInstance: Setting m_poAudioSettings value"));
       m_poAudioSettings = poAudioSettingsIntf;
   }

}


