/*!
 *******************************************************************************
 * \file             spi_tclBDCLVideoResourceMngr.h
 * \brief            Video Resource Manager for Baidu Carlife
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3 Projects
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Video Resource Manager for Baidu Carlife
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author              | Modifications
 04.05.2017 |  Ramya Murthy        | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLBDCLVIDEORESOURCEMNGR_H_
#define _SPI_TCLBDCLVIDEORESOURCEMNGR_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "BDCLTypes.h"
#include "Lock.h"
#include "spi_tclBDCLRespSession.h"
#include "spi_tclBDCLRespVideo.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

//! Forward declarations
class spi_tclBDCLResourceMngr;

/****************************************************************************/
/*!
* \class   spi_tclBDCLVideoResourceMngr
* \brief   BDCL Video resource manager
*
*           This class implements the logic to when to request for Video Focus
*           and how to respond to the VideoFocus request from the Phone.
*
****************************************************************************/
class spi_tclBDCLVideoResourceMngr: public spi_tclBDCLRespVideo, spi_tclBDCLRespSession
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoResourceMngr::spi_tclBDCLVideoResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLVideoResourceMngr()
       * \brief   parameterized  Constructor
       * \param   poBDCLRsrcMngr : [IN] BDCL resource manager
       * \sa      ~spi_tclBDCLVideoResourceMngr()
       **************************************************************************/
      spi_tclBDCLVideoResourceMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoResourceMngr::~spi_tclBDCLVideoResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLVideoResourceMngr()
       * \brief   Destructor
       * \sa      spi_tclBDCLVideoResourceMngr()
       **************************************************************************/
      ~spi_tclBDCLVideoResourceMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclBDCLVideoResourceMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Video resources
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief    To Uninitialize  the Video resources
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vSetAccessoryDisplayContext()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId,
       *             t_Bool bDisplayFlag, tenDisplayContext enDisplayContext)
       * \brief   To send accessory display context related info .
       * \pram    cou32DevId    : [IN] Uniquely identifies the target Device.
       * \param   bDisplayFlag  : [IN] Display flag
       * \pram    enDisplayContext : [IN] display context
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
               tenDisplayContext enDisplayContext);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclBDCLVideoResourceMngr::vSetAccessoryDisplayMode(t_U32...
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryDisplayMode()
       * \brief  Accessory display mode update request.
       * \param  [IN] cou32DeviceHandle      : Uniquely identifies the target Device.
       * \param  [IN] corDisplayContext     : Display context info
       * \param  [IN] corDisplayConstraint  : DiDisplay constraint info
       * \param  [IN] coenDisplayInfo       : Display info flag
       * \sa
       **************************************************************************/
      t_Void vSetAccessoryDisplayMode(const t_U32 cou32DeviceHandle, const trDisplayContext corDisplayContext,
               const trDisplayConstraint corDisplayConstraint, const tenDisplayInfo coenDisplayInfo);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vOnSPISelectDeviceResult()
      ***************************************************************************/
      /*!
      * \fn      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID,
      *             tenDeviceConnectionReq enDevConnReq,
      *             tenResponseCode enRespCode,
      *             tenErrorCode enErrorCode)
      * \brief   Called when SelectDevice operation is complete & with the result
      *           of the operation.
      * \param   u32DevID : [IN] Unique handle of selected device
      * \param   enDevConnReq: [IN]  Connection request type for the device
      * \param   enRespCode: [IN]  Response code enumeration
      * \param   enErrorCode: [IN]  Error code enumeration
      * \retval  None
      **************************************************************************/
      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDevConnReq,
               tenResponseCode enRespCode, tenErrorCode enErrorCode);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vRequestProjUI()
      ***************************************************************************/
      /*!
      * \fn      t_Void vRequestProjUI(t_U32 u32DevId,
      *                 ct_U32 u32AppId)
      * \brief   To Launch the Video for the requested app
      * \pram    u32DevId  : [IN] Uniquely identifies the target Device.
      * \pram    u32AppId  : [IN] Application Id
      * \retval  t_Void
      **************************************************************************/
      t_Void vRequestProjUI(t_U32 u32DevId,t_U32 u32AppId);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vOnCoreError()
       ***************************************************************************/
      /*!
       * \fn      vOnCoreError
       * \brief   Triggered when there is an error notified by AditCoreSurrogate endpoint
       * \param   enCarlifeError [IN]: Error type enumeration
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnCoreError(tenBdclCarLifeError enCarlifeError);
	  
      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vOnDeviceDeselection()
       ***************************************************************************/
      /*!
       * \fn      vOnDeviceDeselection()
       * \brief   Triggered on start of Device deselection
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnDeviceDeselection();

      /***************************************************************************
       ** FUNCTION:  t_Void vRegisterCallbacks(...)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks()
       * \brief  interface for the creator class to register for the required
       *         callbacks.
       * \param  corfrResMngrCbs : reference to the callback structure
       *         populated by the caller
       **************************************************************************/
      t_Void vRegisterCallbacks(const trBdclResMngrCbs& corfrResMngrCbs);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED*********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vOnPlaybackStart()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnPlaybackStart()
       * \brief   Triggered when Video Play back is started
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnPlaybackStart();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vOnVideoEncoderInitDone()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnVideoEncoderInitDone()
       * \brief   Triggered when VideoEncoderInitDone msg is sent by MD
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnVideoEncoderInitDone(t_U32 u32Width,
               t_U32 u32Height, t_U32 u32Framerate);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vOnGotoDeskTop()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnGotoDeskTop()
       * \brief   Triggered when BDCL device sends GotoDeskTop message
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnGotoDeskTop();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vOnForeground()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnForeground()
       * \brief   Triggered when BDCL device sends Foreground/Background message
       * \param   bForeground [IN]:
       *              TRUE - if BDCL app is in foreground
       *              FALSE - if BDCL app is in background
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnForeground(t_Bool bForeground);

      /***************************************************************************
       ****************************END OF PROTECTED*******************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclBDCLVideoResourceMngr::vSetVideoFocus()
      ***************************************************************************/
      /*!
      * \fn      t_Void vSetVideoFocus(tenBdclVideoFocus enVideoFocus)
      * \brief   Method to handle video focus
      * \param   enVideoFocus : [IN] Video Focus Mode
      * \retval  t_Void
      **************************************************************************/
      t_Void vSetVideoFocus(tenBdclVideoFocus enVideoFocus);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoResourceMngr(const spi_tclBDCLVideoResourceMngr...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLVideoResourceMngr(
       *                             const spi_tclBDCLVideoResourceMngr& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLVideoResourceMngr()
       ***************************************************************************/
      spi_tclBDCLVideoResourceMngr(const spi_tclBDCLVideoResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoResourceMngr& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLVideoResourceMngr& operator=(
       *                          const spi_tclBDCLVideoResourceMngr& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLVideoResourceMngr(const spi_tclBDCLVideoResourceMngr& otrSrc)
       ***************************************************************************/
      spi_tclBDCLVideoResourceMngr& operator=(const spi_tclBDCLVideoResourceMngr& corfoSrc);

      /***************************************************************************
       *** FUNCTION: spi_tclBDCLVideoResourceMngr::vSendDeviceDeselect()
       ***************************************************************************/
      /*!
       * \fn      vSendDeviceDeselect()
       * \brief   Requests deselection of current active device
       * \param   none
       * \return  none
       **************************************************************************/
      t_Void vSendDeviceDeselect();

     /***************************************************************************
      *** FUNCTION: spi_tclBDCLVideoResourceMngr::vStartTransportErrorTimer ()
      ***************************************************************************/
     /*!
      * \fn      vStartTransportErrorTimer ()
      * \brief   Start timer function will begin the timer after a I/O or
      *          timeout error has been received.
      * \param   none
      * \return  none
      **************************************************************************/
      t_Void vStartTransportErrorTimer ();

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLVideoResourceMngr::vStopTransportErrorTimer ()
       ***************************************************************************/
      /*!
       * \fn      vStopTransportErrorTimer ()
       * \brief   Stop timer function will stop the timer after a I/O or
       *          timeout error has been received.
       * \param   none
       * \return  none
       **************************************************************************/
      t_Void vStopTransportErrorTimer ();

      /***************************************************************************
       *** FUNCTION: spi_tclBDCLVideoResourceMngr::vStartVideoInitDoneWaitTimer()
       ***************************************************************************/
      /*!
       * \fn      vStartVideoInitDoneWaitTimer()
       * \brief   Start timer function will begin the timer when VideoEncoderIntiDoneCb
       *          is not received.
       * \param   none
       * \return  none
       **************************************************************************/
       t_Void vStartVideoInitDoneWaitTimer();

       /***************************************************************************
        ** FUNCTION: spi_tclBDCLVideoResourceMngr::vStopVideoInitDoneWaitTimer()
        ***************************************************************************/
       /*!
        * \fn      vStopVideoInitDoneWaitTimer()
        * \brief   Stop timer function will stop the timer when VideoEncoderIntiDoneCb
        *          has been received.
        * \param   none
        * \return  none
        **************************************************************************/
       t_Void vStopVideoInitDoneWaitTimer();

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLVideoResourceMngr::bTransportErrorTimerCb()
       ***************************************************************************/
      /*!
       * \fn      bTransportErrorTimerCb()
       * \brief   Callback that will be called on timer transport error timer expiry
       * \param   none
       * \return  none
       **************************************************************************/
      static t_Bool bTransportErrorTimerCb(timer_t rTimerID, t_Void *pvObject, const t_Void *pvUserData);

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLVideoResourceMngr::bVideoInitDoneWaitTimerCb()
       ***************************************************************************/
      /*!
       * \fn      bVideoInitDoneWaitTimerCb()
       * \brief   Callback that will be called on video init Done timer expiry
       * \param   none
       * \return  none
       **************************************************************************/
      static t_Bool bVideoInitDoneWaitTimerCb(timer_t rTimerID, t_Void *pvObject, const t_Void *pvUserData);

      //! Currently selected device
      t_U32 m_u32SelectedDeviceID;

      //! Current Display context of HMI
      tenDisplayContext m_enCurAccDispCntxt;

      t_Bool m_bCurAccDisplayFlag;

      //! Current Video Focus State of HU
      tenBdclVideoFocusState m_enCurMDFocusState;

      Lock m_oCurMDFocusStateLock;

      //! To contain constraint behavior
      tenDiPOConstraint m_enGrantConstraint;

      //! Holds last state
      tenDiPOTransferType m_enPrevTransferType;

      //! Initial Video Focus to MD.
      t_Bool m_bInitialMDVideoFocus;

      //! Lock for Initial Video Focus
      Lock  m_oVideoSetupLock;

      //! Indicates whether InitVideoEncoder is complete
      t_Bool m_bIsVideoInitDoneCbRcvd;

      //! Lock to protect Timer flags
      Lock m_oErrorLock;

      Lock m_oVideoInitDoneWaitTimerLock;

      //! indicates whether video streaming is started
      t_Bool m_bPlaybackStarted;

      //! Resource manager callbacks
      trBdclResMngrCbs m_rResMngrCbs;

      //launch app request received to SPI
      t_Bool m_bIsLaunchAppRequestReceived;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclBDCLVideoResourceMngr

#endif //_SPI_TCLBDCLVIDEORESOURCEMNGR_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
