/*!
 *******************************************************************************
 * \file             spi_tclBDCLResourceMngr.h
 * \brief            Resource Manager for Baidu Carlife
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3 Projects
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Resource Manager for Baidu Carlife
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author              | Modifications
 04.05.2017 |  Ramya Murthy        | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLBDCLRESOURCEMNGR_H_
#define _SPI_TCLBDCLRESOURCEMNGR_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <memory>

#include "BDCLTypes.h"
#include "spi_tclResorceMngrDefines.h"
#include "spi_tclResourceMngrBase.h"
#include "spi_tclBDCLRespSession.h"


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
//! Forward declarations
class spi_tclBDCLCmdSession;

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
typedef std::shared_ptr< spi_tclBDCLCmdSession >     t_SptrBDCLCmdSession;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/
class spi_tclBDCLVideoResourceMngr;
class spi_tclBDCLAudioResourceMngr;

/****************************************************************************/
/*!
* \class  spi_tclBDCLResourceMngr
* \brief  BDCL Resource Manager
****************************************************************************/
class spi_tclBDCLResourceMngr: public spi_tclResourceMngrBase,
         public spi_tclBDCLRespSession
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLResourceMngr::spi_tclBDCLResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLResourceMngr()
       * \brief   Default Constructor
       * \param   t_Void
       * \sa      ~spi_tclBDCLResourceMngr()
       **************************************************************************/
      spi_tclBDCLResourceMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLResourceMngr::~spi_tclBDCLResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLResourceMngr()
       * \brief   Destructor
       * \param   t_Void
       * \sa      spi_tclBDCLResourceMngr()
       **************************************************************************/
      virtual ~spi_tclBDCLResourceMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclBDCLResourceMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Resource Manager related classes
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLResourceMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the Resource Manager related classes
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclBDCLResourceMngr::vRegRsrcMngrCallBack()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegRsrcMngrCallBack()
       * \brief   To Register for the asynchronous responses that are required from
       *          SPI technology Resource Manager
       * \param   rRsrcMngrCallback : [IN] Resource Manager callbacks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegRsrcMngrCallBack(trRsrcMngrCallback rRsrcMngrCallback);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLResourceMngr::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSelectDevice()
       * \brief   Processing of the select device request
       * \param   u32DevID : [IN] Resource Manager callbacks structure.
       * \param   enDeviceConnReq : [IN] Select/ deselect.
       * \param   enDevCat : [IN] Category of device
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const t_U32 cou32DevId, tenDeviceConnectionReq enConnReq,
               tenDeviceCategory enDevCat);

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclBDCLResourceMngr::vOnSPISelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSPISelectDeviceResult()
       * \brief   Interface to receive result of SPI device selection/deselection
       * \param   u32DevID : [IN] Resource Manager callbacks structure.
       * \param   enDeviceConnReq : [IN] Select/ deselect.
       * \param   enRespCode : [IN] Response code (success/failure)
       * \param   enErrorCode : [IN] Error
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDeviceConnReq,
               tenResponseCode enRespCode, tenErrorCode enErrorCode);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLResourceMngr::vSetAccessoryDisplayContext()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId,
       *        t_Bool bDisplayFlag, tenDisplayContext enDisplayContext)
       * \brief   To send accessory display context related info .
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   enDevConnType : [IN] Device connection Type USB/WIFI
       * \pram    rfrcUsrCntxt: [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
               tenDisplayContext enDisplayContext, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclBDCLResourceMngr::vSetAccessoryDisplayMode(t_U32...
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryDisplayMode()
       * \brief  Accessory display mode update request.
       * \param  [IN] cu32DeviceHandle      : Uniquely identifies the target Device.
       * \param  [IN] corDisplayContext     : Display context info
       * \param  [IN] corDisplayConstraint  : DiDisplay constraint info
       * \param  [IN] coenDisplayInfo       : Display info flag
       * \sa
       **************************************************************************/
      t_Void vSetAccessoryDisplayMode(const t_U32 cu32DeviceHandle,
               const trDisplayContext corDisplayContext,
               const trDisplayConstraint corDisplayConstraint,
               const tenDisplayInfo coenDisplayInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLResourceMngr::vSetAccessoryAudioContext()
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryAudioContext(const t_U32 cou32DevId, const t_U8 cu8AudioCntxt
       *       t_Bool bDisplayFlag, const trUserContext& rfrcUsrCntxt)
       * \brief   To send accessory audio context related info .
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   cu8AudioCntxt : [IN] Audio Context
       * \pram    bReqFlag : [IN] Request/ Release flag
       * \pram    rfrcUsrCntxt: [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAccessoryAudioContext(const t_U32 cou32DevId,
               const tenAudioContext coenAudioCntxt, t_Bool bReqFlag,
               const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLResourceMngr::vSetAccessoryAppState()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetAccessoryAppState(tenSpeechAppState enAccSpeechAppState,
       *         tenPhoneAppState enAccPhoneAppState,
       *         tenNavAppState enAccNavAppState
       *
       * \brief   To set accessory app state realated info.
       * \pram    enAccSpeechAppState: [IN] Accessory speech state.
       * \param   enAccPhoneAppState : [IN] Accessory phone state
       * \pram    enAccNavAppState   : [IN] Accessory navigation app state
       * \pram    rfrcUsrCntxt    : [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAccessoryAppState(const tenSpeechAppState enAccSpeechAppState,
               const tenPhoneAppState enAccPhoneAppState,
               const tenNavAppState enAccNavAppState,
               const trUserContext& rfrcUsrCntxt);


       /***************************************************************************
        ** FUNCTION:  t_Void spi_tclResourceMngr::vRequestProjUI()
        ***************************************************************************/
       /*!
        * \fn      t_Void vRequestProjUI(t_U32 u32DevId,
        *                                t_U32 u32AppId)
        * \brief   To Launch the Video for the requested app
        * \pram    u32DevId  : [IN] Uniquely identifies the target Device.
        * \pram    u32AppId  : [IN] Application Id
        * \retval  t_Void
        **************************************************************************/
       t_Void vRequestProjUI(t_U32 u32DevId, t_U32 u32AppId);

   protected:

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLResourceMngr::vOnModuleStatusInfo()
       ***************************************************************************/
      /*!
       * \fn      vOnModuleStatusInfo
       * \brief   Triggered when BDCL device updates status of one or modules on the device
       * \param   corfStatusList [IN]: Structure containing status information of
       *             various logical modules in BDCL device
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnModuleStatusInfo(const tBdclModuleStatusList& corfStatusList);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLResourceMngr(const spi_tclBDCLResourceMngr...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLResourceMngr(
       *                             const spi_tclBDCLResourceMngr& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLResourceMngr()
       ***************************************************************************/
      spi_tclBDCLResourceMngr(const spi_tclBDCLResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLResourceMngr& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLResourceMngr& operator=(
       *                          const spi_tclBDCLResourceMngr& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLResourceMngr(const spi_tclBDCLResourceMngr& otrSrc)
       ***************************************************************************/
      spi_tclBDCLResourceMngr& operator=(const spi_tclBDCLResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  vOnVRStateUpdate(tenBdclVRState enBdclVRState)
       ***************************************************************************/
      /*!
       * \fn      vOnVRStateUpdate(tenBdclVRState enBdclVRState)
       * \brief   Callback function to get updates on VR status.
       * \param   enBdclVRState : VR states.
       * \retval  t_Void
       ***************************************************************************/
      t_Void vOnVRStateUpdate(tenBdclVRState enBdclVRState);

      /***************************************************************************
       ** FUNCTION:  vOnSessionState(...)
       ***************************************************************************/
      /*!
       * \fn      vOnSessionState()
       * \brief   Callback function to get session state info
       * \param   enSessionStatus: Session state
       * \retval  t_Void
       ***************************************************************************/
      t_Void vOnSessionState(tenSessionStatus enSessionStatus);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLResourceMngr::vUpdateDeviceDisplayCntxt()
       ***************************************************************************/
       /*!
       * \fn      virtual t_Void vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag,
       *           tenDisplayContextReason enDisplayContextReason)
       * \brief   Request HMI to enable/diable Layer
       * \pram    bDisplayFlag      : [IN] TRUE - enable layer
       *                                   FALSE - disable layer
       * \param   enDisplayContextReason  : [IN] Reason for device display context update.
       * \retval  t_Void
       **************************************************************************/
       t_Void vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag,
                tenDisplayContextReason enDisplayContextReason);


      //! Callback functions to Resource manager
      trRsrcMngrCallback m_rRsrcMngrCb;

      //! Pointer to Video resource manager
      spi_tclBDCLVideoResourceMngr* m_poVideoRsrcMngr;

      //! Pointer to Audio resource manager
      spi_tclBDCLAudioResourceMngr* m_poAudioRsrcMngr;

      //! Pointer to Cmd Session class
      t_SptrBDCLCmdSession m_spoCmdSession;

      //!Structure varaible to store device app states
      trDiPOAppState m_rDeviceAppStates;
      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/
}; //class spi_tclBDCLResourceMngr

#endif //_SPI_TCLBDCLRESOURCEMNGR_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
