/*!
 *******************************************************************************
 * \file             spi_tclBDCLContextHandler.h
 * \brief            Baidu Carlife context reader
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3 Projects
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Baidu Carlife context reader
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author              | Modifications
 27.06.2017 |  Ramya Murthy        | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef SPI_TCLBDCLCONTEXTHANDLER_H
#define SPI_TCLBDCLCONTEXTHANDLER_H

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "BDCLTypes.h"
#include "SPITypes.h"
#include "SharedSingleton.h"


/******************************************************************************
| defines:
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
class spi_tclBDCLContextHandler;
typedef std::shared_ptr< spi_tclBDCLContextHandler >     t_SptrBDCLContextHandler;


/****************************************************************************/
/*!
* \class spi_tclBDCLContextHandler
* \brief BDCL Context reader
*
****************************************************************************/
class spi_tclBDCLContextHandler : public SharedSingleton<spi_tclBDCLContextHandler>
{
public:
   /***************************************************************************
   *********************************PUBLIC************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclBDCLContextHandler::~spi_tclBDCLContextHandler()
   ***************************************************************************/
   /*!
   * \fn     ~spi_tclBDCLContextHandler()
   * \brief  Destructor
   * \sa     spi_tclBDCLContextHandler()
   **************************************************************************/ 
   virtual ~spi_tclBDCLContextHandler();

   /***************************************************************************
    ** FUNCTION:  t_Bool bGetAudioResponse(...)
    ***************************************************************************/
   /*!
    * \fn      bGetAudioResponse
    * \brief   Looks up the response for a Media Request
    * \param   rAudInfo: [OUT] Contains audio request and result info
    * \retval  t_Bool: TRUE if match is found in lookup table, else FALSE
    **************************************************************************/
   t_Bool bGetAudioResponse(const trBdclAudioRequest& crfrAudRrequest,
         const trBdclAudioStates& crfrCurAudioStates,
         trBdclAudioStates& rfrNewAudioStates,
         tenBdclAudioResponse& rfenAudResponse);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclBDCLContextHandler::bGetAudioStatus(...)
    ***************************************************************************/
   /*!
    * \fn      bGetAudioStatus
    * \brief   Looks up the audio status changes based on newly activated audio context
    * \param   rAudInfo: [OUT] Contains audio request and result info
    * \retval  t_Bool: TRUE if match is found in lookup table, else FALSE
    **************************************************************************/
   t_Bool bGetAudioStatus(t_Bool bAudioFlag, tenAudioContext enAudioCntxt,
         const trBdclAudioStates& crfrCurAudioStates,
         trBdclAudioStates& rfrNewAudioStates);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclBDCLContextHandler::bLookupCLAudioContext(...)
    ***************************************************************************/
   /*!
    * \fn      bLookupCLAudioContext
    * \brief   Looks up the CL audio context type
    * \param   enAudContext: [IN] Audio context type
    * \param   rfenCLAudContext: [IN] BDCL Audio context type
    * \retval  t_Bool: TRUE if match is found in lookup table, else FALSE
    **************************************************************************/
   t_Bool bLookupCLAudioContext(tenAudioContext enAudContext,
         tenBdclAudioContext& rfenCLAudContext);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclBDCLContextHandler::bGetAccVideoFocusState()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bGetAccVideoFocusState(tenDisplayContext enDisplayContext,
   *                 t_Bool bDisplayFlag,tenBdclVideoFocusState& rfenVideoFocusState)
   * \brief   Method to get the current HMI requesting Video Focus state from the
   *          configuration file. Video Focus states for various contexts is defined
   *          based on the Carplay experience
   * \param   enDisplayContext : [IN] Accessory Display Context
   * \param   bDisplayFlag   : [IN] TRUE - HMI is requesting for the Video Focus
   *                          FALSE - HMI screen with the received context has lost focus
   * \param   rfenVideoFocusState : [OUT] HMI requested Video focus state
   * \retval  t_Bool - TRUE - if the received display context is available in the config
   *                   FALSE - if the received display context is not available in the config
   **************************************************************************/
   t_Bool bGetAccVideoFocusState(tenDisplayContext enDisplayContext,
      t_Bool bDisplayFlag, tenBdclVideoFocusState& rfenVideoFocusState);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclBDCLContextHandler::bGetMDVideoFocusState()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bGetMDVideoFocusState(tenBdclVideoFocusState enCurMDFocusState,
   *                 tenBdclVideoFocusState enNewAccFocusState,
   *                 tenBdclVideoFocusState& rfenNewMDFocusState)
   * \brief   Method to get the New MD Focus state based on the Current Hu & MD focus states
   * \param   enCurMDFocusState       : [IN] MD Current Focus State
   * \param   enNewAccFocusState      : [IN] Accessory Current Focus State
   * \param   rfenNewMDFocusState : [OUT] MD New Focus State
   * \retval  t_Bool - TRUE - if the received focus states are available in the config
   *                   FALSE - if the received ocus states are not available in the config
   **************************************************************************/
   t_Bool bGetMDVideoFocusState(tenBdclVideoFocusState enCurMDFocusState,
      tenBdclVideoFocusState enNewAccFocusState,
      tenBdclVideoFocusState& rfenNewMDFocusState);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclBDCLContextHandler::bGetAccRespType()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bGetAccRespType(tenBdclResponse& rfenRespType)
   * \brief   Method to get the Accessory Response for the MD Focus request
   *          for PROJECTED_MODE
   * \param   rfenRespType    : [IN] Accessory Response for the Focus request
   * \retval  t_Bool - TRUE - if the current display context is available in the config
   **************************************************************************/
   t_Bool bGetAccRespType(tenDisplayContext enCurDisplayContext,
            tenBdclVideoFocusState enCurMDFocusState, tenBdclResponse& rfenRespType);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclBDCLContextHandler::bProcessRequestProjUI()
    ***************************************************************************/
   /*!
    * \fn     t_Bool bProcessRequestProjUI();
    * \brief  Method to check whether the launch app can be processed,
    *         based on the current display context.
    * \param  None
    * \retval  t_Bool
    **************************************************************************/
   t_Bool bProcessRequestProjUI(tenDisplayContext enCurDisplayContext);

   /***************************************************************************
   ****************************END OF PUBLIC**********************************
   ***************************************************************************/
private:

   //! Friend class declaration to use singleton utility.
   friend class SharedSingleton<spi_tclBDCLContextHandler>;

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclBDCLContextHandler::spi_tclBDCLContextHandler()
   ***************************************************************************/
   /*!
   * \fn     spi_tclBDCLContextHandler()
   * \brief  Constructor
   * \sa     ~spi_tclBDCLContextHandler()
   **************************************************************************/ 
   spi_tclBDCLContextHandler();

   /***************************************************************************
    ** FUNCTION:  t_Bool bLookupMediaResponse(...)
    ***************************************************************************/
   /*!
    * \fn      bLookupMediaResponse
    * \brief   Looks up the response for a Media Request
    * \param   crfrAudRrequest: [IN] Audio request info
    * \param   crfrCurAudioStates: [IN] structure containing all current audio states
    * \param   rfrNewAudioStates: [OUT] structure containing all new audio states
    * \param   rfenAudResponse: [IN] Response to audio request
    * \retval  t_Bool: TRUE if match is found in lookup table, else FALSE
    **************************************************************************/
   t_Bool bLookupMediaResponse(const trBdclAudioRequest& crfrAudRrequest,
         const trBdclAudioStates& crfrCurAudioStates,
         trBdclAudioStates& rfrNewAudioStates,
         tenBdclAudioResponse& rfenAudResponse);

   /***************************************************************************
    ** FUNCTION:  t_Bool bLookupVRResponse(...)
    ***************************************************************************/
   /*!
    * \fn      bLookupVRResponse
    * \brief   Looks up the response for a VR Request
    * \param   crfrAudRrequest: [IN] Audio request info
    * \param   crfrCurAudioStates: [IN] structure containing all current audio states
    * \param   rfrNewAudioStates: [OUT] structure containing all new audio states
    * \param   rfenAudResponse: [IN] Response to audio request
    * \retval  t_Bool: TRUE if match is found in lookup table, else FALSE
    **************************************************************************/
   t_Bool bLookupVRResponse(const trBdclAudioRequest& crfrAudRrequest,
         const trBdclAudioStates& crfrCurAudioStates,
         trBdclAudioStates& rfrNewAudioStates,
         tenBdclAudioResponse& rfenAudResponse);

   /***************************************************************************
    ** FUNCTION:  t_Bool bLookupTTSResponse(...)
    ***************************************************************************/
   /*!
    * \fn      bLookupTTSResponse
    * \brief   Looks up the response for a TTS Request
    * \param   crfrAudRrequest: [IN] Audio request info
    * \param   crfrCurAudioStates: [IN] structure containing all current audio states
    * \param   rfrNewAudioStates: [OUT] structure containing all new audio states
    * \param   rfenAudResponse: [IN] Response to audio request
    * \retval  t_Bool: TRUE if match is found in lookup table, else FALSE
    **************************************************************************/
   t_Bool bLookupTTSResponse(const trBdclAudioRequest& crfrAudRrequest,
         const trBdclAudioStates& crfrCurAudioStates,
         trBdclAudioStates& rfrNewAudioStates,
         tenBdclAudioResponse& rfenAudResponse);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclBDCLContextHandler::bLookupAudioStatus(...)
    ***************************************************************************/
   /*!
    * \fn      bLookupAudioStatus
    * \brief   Looks up the audio status change
    * \param   enRsrcRequest: [IN] Audio resource request type
    * \param   enAudContext: [IN] Audio context type for which resource is requested/released
    * \param   crfrCurAudioStates: [IN] structure containing all current audio states
    * \param   rfrNewAudioStates: [OUT] structure containing all new audio states
    * \retval  t_Bool: TRUE if match is found in lookup table, else FALSE
    **************************************************************************/
   t_Bool bLookupAudioStatus(tenBdclAudioResourceRequest enRsrcRequest,
         tenBdclAudioContext enAudContext,
         const trBdclAudioStates& crfrCurAudioStates,
         trBdclAudioStates& rfrNewAudioStates);

   /***************************************************************************
   *****************************END OF PRIVATE********************************
   ***************************************************************************/

}; //

#endif
