/***********************************************************************/
/*!
* \file  spi_tclBDCLVideoDispatcher.h
* \brief Message Dispatcher for Video Messages. implemented using
*        double dispatch mechanism
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Video Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLBDCLVIDEODISPATCHER_H_
#define _SPI_TCLBDCLVIDEODISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "BDCLTypes.h"

//!Forward declarations
class spi_tclBDCLVideoDispatcher;

/****************************************************************************/
/*!
 * \class    BDCLVideoMsgBase
 * \brief    Base Message type for all Video messages
 ****************************************************************************/
class BDCLVideoMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLVideoMsgBase::BDCLVideoMsgBase
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoMsgBase();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  BDCLVideoMsgBase::~BDCLVideoMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLVideoMsgBase()
      {
      }
};

/****************************************************************************/
/*!
 * \class    BDCLVideoPlaybackStartMsg
 ****************************************************************************/
class BDCLVideoPlaybackStartMsg: public BDCLVideoMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLVideoPlaybackStartMsg::BDCLVideoPlaybackStartMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoPlaybackStartMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoPlaybackStartMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoPlaybackStartMsg::~BDCLVideoPlaybackStartMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoPlaybackStartMsg()
       * \brief   BDCLVideoPlaybackStartMsg
       **************************************************************************/
      virtual ~BDCLVideoPlaybackStartMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoPlaybackStartMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoPlaybackStartMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoPlaybackStartMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
}; //class BDCLVideoPlaybackStartMsg

/****************************************************************************/
/*!
 * \class    BDCLVideoEncoderInitDoneMsg
 ****************************************************************************/
class BDCLVideoEncoderInitDoneMsg: public BDCLVideoMsgBase
{
   public:

      t_U32 m_u32Width;
      t_U32 m_u32Height;
      t_U32 m_u32Framerate;

      /***************************************************************************
       ** FUNCTION:  BDCLVideoEncoderInitDoneMsg::BDCLVideoEncoderInitDoneMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoEncoderInitDoneMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoEncoderInitDoneMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoEncoderInitDoneMsg::~BDCLVideoEncoderInitDoneMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoEncoderInitDoneMsg()
       * \brief   BDCLVideoEncoderInitDoneMsg
       **************************************************************************/
      virtual ~BDCLVideoEncoderInitDoneMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoEncoderInitDoneMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoEncoderInitDoneMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoEncoderInitDoneMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};//class BDCLVideoEncoderInitDoneMsg

/****************************************************************************/
/*!
 * \class    BDCLVideoHeartBeatMsg
 ****************************************************************************/
class BDCLVideoHeartBeatMsg: public BDCLVideoMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLVideoHeartBeatMsg::BDCLVideoHeartBeatMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoHeartBeatMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoHeartBeatMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoHeartBeatMsg::~BDCLVideoHeartBeatMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoHeartBeatMsg()
       * \brief   BDCLVideoHeartBeatMsg
       **************************************************************************/
      virtual ~BDCLVideoHeartBeatMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoHeartBeatMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoHeartBeatMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoHeartBeatMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};//class BDCLVideoHeartBeatMsg

/****************************************************************************/
/*!
 * \class    BDCLVideoForegroundMsg
 ****************************************************************************/
class BDCLVideoForegroundMsg: public BDCLVideoMsgBase
{
   public:
      t_Bool m_bForeground;

      /***************************************************************************
       ** FUNCTION:  BDCLVideoForegroundMsg::BDCLVideoForegroundMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoForegroundMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoForegroundMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoForegroundMsg::~BDCLVideoForegroundMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoForegroundMsg()
       * \brief   BDCLVideoForegroundMsg
       **************************************************************************/
      virtual ~BDCLVideoForegroundMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoForegroundMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoForegroundMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoForegroundMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};//class BDCLVideoForegroundMsg

/****************************************************************************/
/*!
 * \class    BDCLVideoGotoForegroundMsg
 ****************************************************************************/
class BDCLVideoGotoForegroundMsg: public BDCLVideoMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoForegroundMsg::BDCLVideoGotoForegroundMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoGotoForegroundMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoGotoForegroundMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoForegroundMsg::~BDCLVideoGotoForegroundMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoGotoForegroundMsg()
       * \brief   BDCLVideoGotoForegroundMsg
       **************************************************************************/
      virtual ~BDCLVideoGotoForegroundMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoForegroundMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoForegroundMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoForegroundMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};//class BDCLVideoGotoForegroundMsg

/****************************************************************************/
/*!
 * \class    BDCLVideoScreenOnOffMsg
 ****************************************************************************/
class BDCLVideoScreenOnOffMsg: public BDCLVideoMsgBase
{
   public:
      t_Bool m_bScreenOn;

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenOnOffMsg::BDCLVideoScreenOnOffMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoScreenOnOffMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoScreenOnOffMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenOnOffMsg::~BDCLVideoScreenOnOffMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoScreenOnOffMsg()
       * \brief   BDCLVideoScreenOnOffMsg
       **************************************************************************/
      virtual ~BDCLVideoScreenOnOffMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenOnOffMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenOnOffMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenOnOffMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};//class BDCLVideoScreenOnOffMsg

/****************************************************************************/
/*!
 * \class    BDCLVideoScreenUserPresentMsg
 ****************************************************************************/
class BDCLVideoScreenUserPresentMsg: public BDCLVideoMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenUserPresentMsg::BDCLVideoScreenUserPresentMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoScreenUserPresentMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoScreenUserPresentMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenUserPresentMsg::~BDCLVideoScreenUserPresentMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoScreenUserPresentMsg()
       * \brief   BDCLVideoScreenUserPresentMsg
       **************************************************************************/
      virtual ~BDCLVideoScreenUserPresentMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenUserPresentMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenUserPresentMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoScreenUserPresentMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};//class BDCLVideoScreenUserPresentMsg

/****************************************************************************/
/*!
 * \class    BDCLVideoGotoDesktopMsg
 ****************************************************************************/
class BDCLVideoGotoDesktopMsg: public BDCLVideoMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoDesktopMsg::BDCLVideoGotoDesktopMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVideoGotoDesktopMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVideoGotoDesktopMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoDesktopMsg::~BDCLVideoGotoDesktopMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVideoGotoDesktopMsg()
       * \brief   BDCLVideoGotoDesktopMsg
       **************************************************************************/
      virtual ~BDCLVideoGotoDesktopMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoDesktopMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLVideoDispatcher* poDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoDesktopMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVideoGotoDesktopMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};//class BDCLVideoGotoDesktopMsg


/****************************************************************************/
/*!
 * \class    spi_tclBDCLVideoDispatcher
 * \brief    Message Dispatcher for Video Messages
 ****************************************************************************/
class spi_tclBDCLVideoDispatcher
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::spi_tclBDCLVideoDispatcher()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLVideoDispatcher()
       * \brief   Default Constructor
       * \param   t_Void
       * \sa      ~spi_tclBDCLVideoDispatcher()
       **************************************************************************/
      spi_tclBDCLVideoDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::~spi_tclBDCLVideoDispatcher()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLVideoDispatcher()
       * \brief   Destructor
       * \param   t_Void
       * \sa      spi_tclBDCLVideoDispatcher()
       **************************************************************************/
      ~spi_tclBDCLVideoDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoPlaybackStartMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoPlaybackStartMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoPlaybackStartMsg type
       * \param   poMsg :Pointer object of type BDCLVideoPlaybackStartMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoPlaybackStartMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoEncoderInitDoneMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoEncoderInitDoneMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoEncoderInitDoneMsg type
       * \param   poMsg :Pointer object of type BDCLVideoEncoderInitDoneMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoEncoderInitDoneMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoHeartBeatMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoHeartBeatMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoHeartBeatMsg type
       * \param   poMsg :Pointer object of type BDCLVideoHeartBeatMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoHeartBeatMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoForegroundMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoForegroundMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoForegroundMsg type
       * \param   poMsg :Pointer object of type BDCLVideoForegroundMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoForegroundMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoGotoForegroundMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoGotoForegroundMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoGotoForegroundMsg type
       * \param   poMsg :Pointer object of type BDCLVideoGotoForegroundMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoGotoForegroundMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoScreenOnOffMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoScreenOnOffMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoScreenOnOffMsg type
       * \param   poMsg :Pointer object of type BDCLVideoScreenOnOffMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoScreenOnOffMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoScreenUserPresentMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoScreenUserPresentMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoScreenUserPresentMsg type
       * \param   poMsg :Pointer object of type BDCLVideoScreenUserPresentMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoScreenUserPresentMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoGotoDesktopMsg..)
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(BDCLVideoGotoDesktopMsg* poMsg)
       * \brief   Handles Messages of BDCLVideoGotoDesktopMsg type
       * \param   poMsg :Pointer object of type BDCLVideoGotoDesktopMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(BDCLVideoGotoDesktopMsg* poMsg) const;

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher(const spi_tclBDCLVideoDispatcher...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLVideoDispatcher(
       *                             const spi_tclBDCLVideoDispatcher& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLVideoDispatcher()
       ***************************************************************************/
      spi_tclBDCLVideoDispatcher(const spi_tclBDCLVideoDispatcher& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoDispatcher& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLVideoDispatcher& operator=(
       *                          const spi_tclBDCLVideoDispatcher& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLVideoDispatcher(const spi_tclBDCLVideoDispatcher& corfoSrc)
       ***************************************************************************/
      spi_tclBDCLVideoDispatcher& operator=(const spi_tclBDCLVideoDispatcher& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclBDCLVideoDispatcher


#endif //_SPI_TCLBDCLVIDEODISPATCHER_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
