
/***********************************************************************/
/*!
* \file   spi_tclBDCLRespVideo.h
* \brief  VideoSink Call backs output interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    VideoSink Call backs output interface
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLBDCLRESPVIDEO_H_
#define _SPI_TCLBDCLRESPVIDEO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "BDCLTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class  spi_tclBDCLRespVideo.h
* \brief  BDCL Video callbacks output interface
*****************************************************************************/
class spi_tclBDCLRespVideo:public RespBase
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespVideo::spi_tclBDCLRespVideo()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespVideo()
       * \brief   Default Constructor
       * \sa      ~spi_tclBDCLRespVideo()
       **************************************************************************/
      spi_tclBDCLRespVideo() :
         RespBase(e16BDCL_VIDEO_REGID)
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespVideo::~spi_tclBDCLRespVideo()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLRespVideo()
       * \brief   Destructor
       * \sa      spi_tclBDCLRespVideo()
       **************************************************************************/
      virtual ~spi_tclBDCLRespVideo()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnPlaybackStart()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnPlaybackStart()
       * \brief   Triggered when Video Play back is started
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnPlaybackStart()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnVideoEncoderInitDone()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnVideoEncoderInitDone()
       * \brief   Triggered when VideoEncoderInitDone msg is sent by MD
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnVideoEncoderInitDone(t_U32 u32Width,
               t_U32 u32Height, t_U32 u32Framerate)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnHeartBeat()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnHeartBeat()
       * \brief   Triggered when BDCL device sends HeartBeat message
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnHeartBeat()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnForeground()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnForeground()
       * \brief   Triggered when BDCL device sends  Foreground/Background message
       * \param   bForeground [IN]:
       *              TRUE - if BDCL app is in foreground
       *              FALSE - if BDCL app is in background
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnForeground(t_Bool bForeground)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnGotoForeground()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnGotoForeground()
       * \brief   Triggered when BDCL device sends GotoForeground message
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnGotoForeground()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnScreenOnOff()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnScreenOnOff()
       * \brief   Triggered when BDCL device sends ScreenOn or ScreenOff message
       * \param   bScreenOn [IN]:
       *              TRUE - if BDCL device Screen is On
       *              FALSE - if BDCL device Screen is Off
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnScreenOnOff(t_Bool bScreenOn)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnScreenUserPresent()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnScreenUserPresent()
       * \brief   Triggered when BDCL device sends ScreenUserPresent message
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnScreenUserPresent()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespVideo::vOnGotoDeskTop()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vOnGotoDeskTop()
       * \brief   Triggered when BDCL device sends GotoDeskTop message
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnGotoDeskTop()
      {
      }

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespVideo(const spi_tclBDCLRespVideo...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespVideo(const spi_tclBDCLRespVideo& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespVideo()
       ***************************************************************************/
      spi_tclBDCLRespVideo(const spi_tclBDCLRespVideo& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespVideo& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespVideo& operator=(const spi_tclBDCLRespVideo& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespVideo(const spi_tclBDCLRespVideo& otrSrc)
       ***************************************************************************/
      spi_tclBDCLRespVideo& operator=(const spi_tclBDCLRespVideo& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/


}; //class spi_tclBDCLRespVideo

#endif //_SPI_TCLBDCLRESPVIDEO_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
