/***********************************************************************/
/*!
* \file  spi_tclBDCLSessionDispatcher.h
* \brief Message Dispatcher for Session Messages. implemented using
*        double dispatch mechanism
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Session Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLSESSIONDISPATCHER_H_
#define SPI_TCLBDCLSESSIONDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "BDCLTypes.h"

//!Forward declarations
class spi_tclBDCLSessionDispatcher;

/****************************************************************************/
/*!
 * \class BDCLSessionMsgBase
 * \brief Base Message type for all Session messages
 ****************************************************************************/
class BDCLSessionMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLSessionMsgBase::BDCLSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      BDCLSessionMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      BDCLSessionMsgBase();

      /***************************************************************************
       ** FUNCTION:  BDCLSessionMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  BDCLSessionMsgBase::~BDCLSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~BDCLSessionMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLSessionMsgBase()
      {
      }
};

/****************************************************************************/
/*!
 * \class BDCLMDInfoMsg
 * \brief Session attestation response message
 ****************************************************************************/
class BDCLMDInfoMsg: public BDCLSessionMsgBase
{
   public:

      trBdclMDInfo* m_prMDInfo;

      /***************************************************************************
       ** FUNCTION:  BDCLMDInfoMsg::BDCLMDInfoMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLMDInfoMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLMDInfoMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLMDInfoMsg::~BDCLMDInfoMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLMDInfoMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLMDInfoMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLMDInfoMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLMDInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLMDInfoMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BDCLModuleStatusMsg
 * \brief Session attestation response message
 ****************************************************************************/
class BDCLModuleStatusMsg: public BDCLSessionMsgBase
{
   public:

      tBdclModuleStatusList* m_pStatusList;

      /***************************************************************************
       ** FUNCTION:  BDCLModuleStatusMsg::BDCLModuleStatusMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLModuleStatusMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLModuleStatusMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLModuleStatusMsg::~BDCLModuleStatusMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLModuleStatusMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLModuleStatusMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLModuleStatusMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLModuleStatusMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLModuleStatusMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BDCLExitMsg
 * \brief Session attestation response message
 ****************************************************************************/
class BDCLExitMsg: public BDCLSessionMsgBase
{
   public:

      /***************************************************************************
       ** FUNCTION:  BDCLExitMsg::BDCLExitMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLExitMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLExitMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLExitMsg::~BDCLExitMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLExitMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLExitMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLExitMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLExitMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
	  {
		  
	  }

      /***************************************************************************
       ** FUNCTION:  BDCLExitMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
	  {
		  
	  }
};

/****************************************************************************/
/*!
 * \class BDCLFeatureConfigRequestMsg
 * \brief Feature Config request message
 ****************************************************************************/
class BDCLFeatureConfigRequestMsg: public BDCLSessionMsgBase
{
   public:

      /***************************************************************************
       ** FUNCTION:  BDCLFeatureConfigRequestMsg::BDCLFeatureConfigRequestMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLFeatureConfigRequestMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLFeatureConfigRequestMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLFeatureConfigRequestMsg::~BDCLFeatureConfigRequestMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLFeatureConfigRequestMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLFeatureConfigRequestMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLFeatureConfigRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLFeatureConfigRequestMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
     {

     }

      /***************************************************************************
       ** FUNCTION:  BDCLFeatureConfigRequestMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
     {

     }
};

/****************************************************************************/
/*!
 * \class BDCLProtocolVersionMatchStatusMsg
 * \brief Protocol Version Match status message
 ****************************************************************************/
class BDCLProtocolVersionMatchStatusMsg: public BDCLSessionMsgBase
{
	public:

	t_Bool  bProtocolMatchStatus;
	/***************************************************************************
	 *** FUNCTION:  BDCLProtocolVersionMatchStatusMsg::BDCLProtocolVersionMatchStatusMsg
	 ******************************************************************************/
	/*!
	 ** \fn      BDCLProtocolVersionMatchStatusMsg()
	 *** \brief   Default constructor
	 *****************************************************************************/
	BDCLProtocolVersionMatchStatusMsg();

	/***************************************************************************
	 *** FUNCTION:  BDCLProtocolVersionMatchStatusMsg::~BDCLProtocolVersionMatchStatusMsg
	 ******************************************************************************/
	/*!
	 ** \fn      ~BDCLProtocolVersionMatchStatusMsg()
	 *** \brief   Destructor
	 *****************************************************************************/
	virtual ~BDCLProtocolVersionMatchStatusMsg()
	{

	}

	/***************************************************************************
     ** FUNCTION:  BDCLProtocolVersionMatchStatusMsg::vDispatchMsg
     ***************************************************************************/
	/*!
	 ** \fn      vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher)
     * \brief   virtual function for dispatching the message of 'this' type
     * \param  poSessionDispatcher : pointer to Message dispatcher for Session
     **************************************************************************/
	t_Void vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher);
	/***************************************************************************
     ** FUNCTION:  BDCLProtocolVersionMatchStatusMsg::vAllocateMsg
     ***************************************************************************/
    /*!
     * \fn      vAllocateMsg()
     * \brief   Allocates memory for non trivial datatypes (ex STL containers)
     * \sa      vDeAllocateMsg
     **************************************************************************/
    t_Void vAllocateMsg()
    {

    }

    /***************************************************************************
     ** FUNCTION:  BDCLProtocolVersionMatchStatusMsg::vDeAllocateMsg
     ***************************************************************************/
    /*!
     *** \fn      vDeAllocateMsg()
     **** \brief   Destroys memory allocated by vAllocateMsg()
     * \sa      vAllocateMsg
     ***************************************************************************/
    t_Void vDeAllocateMsg()
    {

    }
};

/****************************************************************************/
/*!
 * \class BDCLCoreErrorMsg
 * \brief Session attestation response message
 ****************************************************************************/
class BDCLCoreErrorMsg: public BDCLSessionMsgBase
{
   public:

      tenBdclCarLifeError  m_enCarlifeError;

      /***************************************************************************
       ** FUNCTION:  BDCLCoreErrorMsg::BDCLCoreErrorMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLCoreErrorMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLCoreErrorMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCoreErrorMsg::~BDCLCoreErrorMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLCoreErrorMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLCoreErrorMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLCoreErrorMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLCoreErrorMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLCoreErrorMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};

/****************************************************************************/
/*!
 * \class spi_tclBDCLSessionDispatcher
 * \brief Message Dispatcher for Session Messages
 ****************************************************************************/
class spi_tclBDCLSessionDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::spi_tclBDCLSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLSessionDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclBDCLSessionDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::~spi_tclBDCLSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLSessionDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclBDCLSessionDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLMDInfoMsg* poBDCLMDInfoMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(BDCLMDInfoMsg* poBDCLMDInfoMsg)
       * \brief   Handles Messages of BDCLMDInfoMsg type
       * \param   poBDCLMDInfoMsg : pointer to BDCLMDInfoMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(BDCLMDInfoMsg* poBDCLMDInfoMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLModuleStatusMsg* poBDCLModuleStatusMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(BDCLModuleStatusMsg* poBDCLModuleStatusMsg)
       * \brief   Handles Messages of BDCLModuleStatusMsg type
       * \param   poBDCLModuleStatusMsg : pointer to BDCLModuleStatusMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(BDCLModuleStatusMsg* poBDCLModuleStatusMsg) const;
	  
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg()
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(BDCLExitMsg* poBDCLExitMsg)
       * \brief   Handles Messages of BDCLExitMsg type
       * \param   poBDCLModuleStatusMsg : pointer to BDCLExitMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(BDCLExitMsg* poBDCLExitMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLProtocolVersionMatchStatusMsg* poBDCLProtocolVersionMatchStatusMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(BDCLProtocolVersionMatchStatusMsg* poBDCLProtocolVersionMatchStatusMsg)
       * \brief   Handles Messages of BDCLProtocolVersionMatchStatusMsg type
       * \param   poBDCLProtocolVersionMatchStatusMsg : pointer to BDCLProtocolVersionMatchStatusMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(BDCLProtocolVersionMatchStatusMsg* poBDCLProtocolVersionMatchStatusMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg()
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(BDCLCoreErrorMsg* poBDCLErrorMsg)
       * \brief   Handles Messages of poBDCLErrorMsg type
       * \param   poBDCLModuleStatusMsg : pointer to poBDCLErrorMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(BDCLCoreErrorMsg* poBDCLErrorMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg()
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(BDCLFeatureConfigRequestMsg* poBDCLFeatureConfigRequestMsg)
       * \brief   Handles Messages of poBDCLFeatureConfigRequestMsg type
       * \param   poBDCLFeatureConfigRequestMsg : pointer to BDCLFeatureConfigRequestMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(BDCLFeatureConfigRequestMsg* poBDCLFeatureConfigRequestMsg) const;


      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher(const spi_tclBDCLSessionDispatcher...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLSessionDispatcher(
       *                             const spi_tclBDCLSessionDispatcher& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLSessionDispatcher()
       ***************************************************************************/
      spi_tclBDCLSessionDispatcher(const spi_tclBDCLSessionDispatcher& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionDispatcher& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLSessionDispatcher& operator=(
       *                          const spi_tclBDCLSessionDispatcher& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLSessionDispatcher(const spi_tclBDCLSessionDispatcher& corfoSrc)
       ***************************************************************************/
      spi_tclBDCLSessionDispatcher& operator=(const spi_tclBDCLSessionDispatcher& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/
};


#endif /* SPI_TCLBDCLSESSIONDISPATCHER_H_ */

///////////////////////////////////////////////////////////////////////////////
// <EOF>
