/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdSession.h
* \brief  Implementation of the Class spi_tclBDCLCmdSession
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLCMDSESSION_
#define SPI_TCLBDCLCMDSESSION_

#include <memory>
#include <bdcl/CommonUtil.h>
#include <bdcl/AditCoreSurrogate.h>

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "spi_tclBDCLProxyManager.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Forward declarations
class spi_tclBDCLSessionProxyIntf;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::unique_ptr< adit::bdcl::AditCoreSurrogate >    t_SptrBDCLCoreEndpoint;


/*!
 * \class spi_tclBDCLCmdSession
 * \brief
 */
class spi_tclBDCLCmdSession: public adit::bdcl::IAditBaiduCoreCallbacks
{

public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCmdSession
       ***************************************************************************/
      /*!
       * \fn       spi_tclBDCLCmdSession()
       * \brief    Constructor
       * \sa       ~spi_tclBDCLCmdSession()
       **************************************************************************/
      spi_tclBDCLCmdSession();

      /***************************************************************************
       ** FUNCTION:   ~spi_tclBDCLCmdSession()
       ***************************************************************************/
      /*!
       * \fn       ~spi_tclBDCLCmdSession()
       * \brief    Destructor
       * \sa       spi_tclBDCLCmdSession()
       **************************************************************************/
      ~spi_tclBDCLCmdSession();

      /***************************************************************************
       ** FUNCTION:  tenBdclInitStatus enInitialize()
       ***************************************************************************/
      /*!
       * \fn      enInitialize()
       * \brief   Performs initialization for session with BDCL device
       * \sa      vUninitialize()
       **************************************************************************/
      tenBdclInitStatus enInitialize(const trBdclInitInfo& corfrInitInfo,
               const trBdclStatisticsInfo& corfrStatisticsInfo);

      /***************************************************************************
       ** FUNCTION:  t_Bool vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief   Performs cleanup of session with BDCL device
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:   t_Void vAbortInit()
       ***************************************************************************/
      /*!
       * \fn      vAbortInit()
       * \brief   Aborts session initialization with BDCL device
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vAbortInit();

      /***************************************************************************
       ** FUNCTION:   t_Void vSetProtocolStatusTimeOut()
       ***************************************************************************/
      /*!
       * \fn      vSetProtocolStatusTimeOut()
       * \brief   Interface to set the maximum time to retry sending HU Protocol
       *             version message to phone
       * \param   u16TimeOut [IN]: Maximum time within which to retry sending
       *             HU Protocol version message to phone
       **************************************************************************/
      t_Void vSetProtocolStatusTimeOut(t_U16 u16TimeOut);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetHeadUnitInfo()
       ***************************************************************************/
      /*!
       * \fn      vSetHeadUnitInfo()
       * \brief   Performs cleanup of session with BDCL device
       * \param   corfrHUInfo [IN]: structure containing HU information
       **************************************************************************/
      t_Void vSetHeadUnitInfo(const trBdclHUInfo& corfrHUInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSetMusicState()
       ***************************************************************************/
      /*!
       * \fn      vSetMusicState()
       * \brief   Interface to set state of CL audio playback to CL device
       * \param   enMusicState [IN] : Music playback state
       **************************************************************************/
      t_Void vSetMusicState(tenBdclMusicState enMusicState);

      /***************************************************************************
       ** FUNCTION:   t_Void vSetVRState()
       ***************************************************************************/
      /*!
       * \fn      vSetVRState()
       * \brief   Interface to set state of CL VR session to CL device
       * \param   enVRState [IN] : VR session state
       **************************************************************************/
      t_Void vSetVRState(tenBdclVRState enVRState);

      /***************************************************************************
       ** FUNCTION:   t_Void vSetNavigationState()
       ***************************************************************************/
      /*!
       * \fn      vSetNavigationState()
       * \brief   Interface to set state of CL Navigation to CL device
       * \param   enNavState [IN] : Navigation state
       **************************************************************************/
      t_Void vSetNavigationState(tenBdclNaviState enNavState);

      /***************************************************************************
       ** FUNCTION:   t_Void vSetPhoneState()
       ***************************************************************************/
      /*!
       * \fn      vSetPhoneState()
       * \brief   Interface to set state of CL Phone to CL device
       * \param   enPhoneState [IN] : Phone state
       **************************************************************************/
      t_Void vSetPhoneState(tenBdclPhoneState enPhoneState);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetFeatureConfigInfo()
       ***************************************************************************/
      /*!
       * \fn     vSetFeatureConfigInfo
       * \brief  Sends Feature configuration information to BDCL device
       * \retval None
       **************************************************************************/
      t_Void vSetFeatureConfigInfo(const tBdclFeatureConfigList& corfrFeatConfigList);


   private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLCmdSession(const spi_tclBDCLCmdSession&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCmdSession(const spi_tclBDCLCmdSession&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLCmdSession(const spi_tclBDCLCmdSession&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLCmdSession & operator=(const spi_tclBDCLCmdSession&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLCmdSession & operator=(const spi_tclBDCLCmdSession&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLCmdSession & operator=(const spi_tclBDCLCmdSession&);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetStatisticsInfo()
       ***************************************************************************/
      /*!
       * \fn     vSendHUInfo
       * \brief  Sends Statistics information to BDCL device
       * \retval None
       **************************************************************************/
      t_Void vSetStatisticsInfo(const trBdclStatisticsInfo& corfrStatisticsInfo);

      /***************************************************************************
       ** FUNCTION:  t_Bool vRegisterCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterCallbacks()
       * \brief   Registers for interested callbacks with Session Proxy lib
       * \retval  None
       **************************************************************************/
      t_Void vRegisterCallbacks();

      /***************************************************************************
       ** FUNCTION:   void onProtocolVersionMatchStatus()
       ***************************************************************************/
      /*!
       * \fn      onProtocolVersionMatchStatus()
       * \brief   Callback to receive ProtocolVersionMatchStatus response from MD
       * \param   status [IN]: TRUE - if protocol version match is successful, else FALSE
       **************************************************************************/
      virtual void onProtocolVersionMatchStatus(bool status);

      /***************************************************************************
       ** FUNCTION:   void onAuthenticationResponse()
       ***************************************************************************/
      /*!
       * \fn      onAuthenticationResponse()
       * \brief   Callback to receive HU Authentication response from MD
       * \param   status [IN]: TRUE - if authentication is successful, else FALSE
       **************************************************************************/
      virtual void onAuthenticationResponse(bool status);

      /***************************************************************************
       ** FUNCTION:   void onError()
       ***************************************************************************/
      /*!
       * \fn      onError()
       * \brief   Callback to receive errors from ADIT core
       * \param   inErrorCode [IN]: Error code enumeration
       **************************************************************************/
      virtual void onError(tBdclErrorCodes inErrorCode);

      /***************************************************************************
       ** FUNCTION:  static t_Void vOnMDInfoCb(...)
       ***************************************************************************/
      /*!
       * \fn      vOnMDInfoCb()
       * \brief   Callback handler for MD Info message
       * \param   prInfo [IN]: Structure containing BDCL device info
       **************************************************************************/
      static t_Void vOnMDInfoCb(S_MD_INFO* prInfo);

      /***************************************************************************
       ** FUNCTION:  static t_Void vOnModuleStatusCb(...)
       ***************************************************************************/
      /*!
       * \fn      vOnModuleStatusCb()
       * \brief   Callback handler for Module Status Info message
       * \param   prModuleStatusList [IN]: Structure containing status information of
       *             various logical modules in BDCL device
       **************************************************************************/
      static t_Void vOnModuleStatusCb(S_MODULE_STATUS_LIST_MOBILE* prModuleStatusList);

      /***************************************************************************
       ** FUNCTION:  static t_Void vOnExitCb(...)
       ***************************************************************************/
      /*!
       * \fn      vOnExitCb()
       * \brief   Callback handler for MD Exit message
       * \param   none
       **************************************************************************/
      static t_Void vOnExitCb();

      /***************************************************************************
       ** FUNCTION:  static t_Void vOnFeatureConfigRequestCb(...)
       ***************************************************************************/
      /*!
       * \fn      vOnFeatureConfigRequestCb()
       * \brief   Callback to handle FeatureConfigRequest
       * \param   none
       **************************************************************************/
      static t_Void vOnFeatureConfigRequestCb();

      /***************************************************************************
       ** FUNCTION:   tenBdclInitStatus enGetBdclInitState()
       ***************************************************************************/
      /*!
       * \fn      enGetBdclInitState()
       * \brief   Converts tBdclInitStatus to tenBdclInitStatus type
       * \param   enStatus [IN]: BDCL init state enumeration
       **************************************************************************/
      tenBdclInitStatus enGetBdclInitState(tBdclInitStatus enStatus);

      //! Pointer to Session proxy
      t_SptrBDCLSessionProxy m_spoSessionProxy;

      //! Pointer to ADIT Baidu Core endpoint
      t_SptrBDCLCoreEndpoint m_spoCoreEndpoint;

      //! Indicates if device switch request is in progress
      t_Bool m_bInitInProgress;

      //! Stores latest endpoint initialization state
      tenBdclInitStatus m_enInitStatus;

      //! Lock object for tracking session init
      Lock m_oLock;

      //!stores ProtocolStatusTimeOut
      t_U16 m_u16ProtocolStatusTimeOut;

};
#endif //SPI_TCLBDCLCMDSESSION_
