/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdNavigation.cpp
* \brief  Implementation of the Class spi_tclBDCLCmdNavigation
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclBDCLProxyManager.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLNavigationDispatcher.h"
#include "spi_tclBDCLCmdNavigation.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_BDCLWRAPPER
      #include "trcGenProj/Header/spi_tclBDCLCmdNavigation.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:   spi_tclBDCLCmdNavigation()
 ***************************************************************************/
spi_tclBDCLCmdNavigation::spi_tclBDCLCmdNavigation()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::spi_tclBDCLCmdNavigation entered "));
}

/***************************************************************************
 ** FUNCTION:   ~spi_tclBDCLCmdNavigation()
 ***************************************************************************/
spi_tclBDCLCmdNavigation::~spi_tclBDCLCmdNavigation()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::~spi_tclBDCLCmdNavigation entered "));
}

/***************************************************************************
 ** FUNCTION:   t_Bool bInitialize()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdNavigation::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::bInitialize entered "));

   t_Bool bResult = false;
   t_SptrBDCLProxyManager spoProxyManager = spi_tclBDCLProxyManager::getInstance();
   SPI_NORMAL_ASSERT(!spoProxyManager);
   
   if (spoProxyManager)
   {
      m_spoNavigationProxy = spoProxyManager->spoGetNavigationProxyInstance();
   }
   
   if (m_spoNavigationProxy)
   {
      trBdclNavigationCbs rCallbacks;
      rCallbacks.fvOnCarlifeSubscriptionDone =  &spi_tclBDCLCmdNavigation::vOnCarlifeDataSubscribtionDoneCb;
      rCallbacks.fvOnNaviNextTurnInfo =  &spi_tclBDCLCmdNavigation::vOnNaviNextTurnInfoCb;
      rCallbacks.fvOnNaviAssitantGuideInfo = &spi_tclBDCLCmdNavigation::vOnNaviAssitantGuideInfoCb;

      m_spoNavigationProxy->vRegisterNavigationCallbacks(rCallbacks);

      bResult = true;
   }
   ETG_TRACE_USR1(("[DESC]::spi_tclBDCLCmdNavigation::bInitialize left with result = %d ", ETG_ENUM(BOOL, bResult)));
   return bResult;
}

/***************************************************************************
 ** FUNCTION:   t_Void vUninitialize()
 ***************************************************************************/
t_Void spi_tclBDCLCmdNavigation::vUninitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::vUninitialize entered "));
   m_spoNavigationProxy = nullptr;
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnNaviNextTurnInfoCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdNavigation::vOnCarlifeDataSubscribtionDoneCb(S_SUBSCRIBE_MOBILE_CARLIFE_INFO_LIST* prSubscribeInfoList)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::vOnCarlifeDataSubscribtionDoneCb entered"));
   SPI_NORMAL_ASSERT(NULL == prSubscribeInfoList);

   if (NULL != prSubscribeInfoList)
   {
      ETG_TRACE_USR1(("[PARAM]::vOnCarlifeDataSubscribtionDoneCb: Number of modules changed = %d", prSubscribeInfoList->cnt));

      CarLifeDataSubscriptionDoneMsg oCarLifeDataSubscriptionDoneMsg;
      S_MOBILE_CARLIFE_INFO* prCarLifeInfo = prSubscribeInfoList->pMobileCarLifeInfo;
      for (t_U32 u32ListIndex = 0; u32ListIndex < (prSubscribeInfoList->cnt); ++u32ListIndex)
      {
         if (NULL != prCarLifeInfo)
         {
            ETG_TRACE_USR4(("[PARAM]::vOnCarlifeDataSubscribtionDoneCb: ModuleID = %d, SupportFlag = %d, frequency= %d",
                     prCarLifeInfo->moduleID, prCarLifeInfo->supportFlag,prCarLifeInfo->frequency));

            trBdclCarLifeInfo rCarLifeInfo;
            rCarLifeInfo.enCarlifeDataModuleID = static_cast<tenBdclCarLifeDataModuleID>(prCarLifeInfo->moduleID);
            rCarLifeInfo.bSupportFlag = prCarLifeInfo->supportFlag;
            rCarLifeInfo.u32Frequency = prCarLifeInfo->frequency;
            oCarLifeDataSubscriptionDoneMsg.m_pCarLifeInfoList->push_back(rCarLifeInfo);

            prCarLifeInfo = prCarLifeInfo->pNext;
         }
      }//for (t_U32 u32ListIndex = 0; ...)

      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
    	  poMsgQInterface->bWriteMsgToQ(&oCarLifeDataSubscriptionDoneMsg, sizeof(oCarLifeDataSubscriptionDoneMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prSubscribeInfoList)
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnNaviNextTurnInfoCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdNavigation::vOnNaviNextTurnInfoCb(S_NAVI_NEXT_TURN_INFO* prNextTurnInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::vOnNaviNextTurnInfoCb entered"));
   SPI_NORMAL_ASSERT(NULL == prNextTurnInfo);

   if (NULL != prNextTurnInfo)
   {
      ETG_TRACE_USR4(("[PARAM]::vOnNaviNextTurnInfoCb: action = %d",prNextTurnInfo->action));
      ETG_TRACE_USR4(("[PARAM]::vOnNaviNextTurnInfoCb: turnType = %d",prNextTurnInfo->nextTurn));
      ETG_TRACE_USR4(("[PARAM]::vOnNaviNextTurnInfoCb: totalDistance = %u", prNextTurnInfo->totalDistance));
      ETG_TRACE_USR4(("[PARAM]::vOnNaviNextTurnInfoCb: remainDistance = %u", prNextTurnInfo->remainDistance));
      ETG_TRACE_USR4(("[PARAM]::vOnNaviNextTurnInfoCb: roadname size = %d", prNextTurnInfo->roadName.size()));
      ETG_TRACE_USR4(("[PARAM]::vOnNaviNextTurnInfoCb: turnIcon size = %d", prNextTurnInfo->turnIconData.size()));

      NaviNextTurnInfoMsg oNaviNextTurnInfoMsg;
      oNaviNextTurnInfoMsg.m_prNaviNextTurnInfo->enAction = static_cast<tenBdclAction>(prNextTurnInfo->action);
      oNaviNextTurnInfoMsg.m_prNaviNextTurnInfo->enNextTurn = static_cast<tenBdclTurnKind>(prNextTurnInfo->nextTurn);
      oNaviNextTurnInfoMsg.m_prNaviNextTurnInfo->u32TotalDistance = prNextTurnInfo->totalDistance;
      oNaviNextTurnInfoMsg.m_prNaviNextTurnInfo->u32RemainingDistance = prNextTurnInfo->remainDistance;


      if ((0 < prNextTurnInfo->roadName.size()) && (STR_ROADNAME_LENGTH > prNextTurnInfo->roadName.size()))
      {
         memcpy(oNaviNextTurnInfoMsg.m_prNaviNextTurnInfo->cRoadName,
                  prNextTurnInfo->roadName.c_str(),
                  prNextTurnInfo->roadName.size() + 1);
      }

      oNaviNextTurnInfoMsg.m_prNaviNextTurnInfo->u32TurnIconSize = prNextTurnInfo->turnIconData.size();
      if ((0 < prNextTurnInfo->turnIconData.size()) && (STR_ALBUMART_MAX_SIZE > prNextTurnInfo->turnIconData.size()))
      {
         //@Note: memcpy is used instead of strncpy since this string can contain multiple null characters
         memcpy(oNaviNextTurnInfoMsg.m_prNaviNextTurnInfo->cTurnIcon,
                   prNextTurnInfo->turnIconData.data(),
                   prNextTurnInfo->turnIconData.size());
      }

      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
         poMsgQInterface->bWriteMsgToQ(&oNaviNextTurnInfoMsg, sizeof(oNaviNextTurnInfoMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prNextTurnInfo)
   
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::vOnNaviNextTurnInfoCb left"));
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnNaviAssitantGuideInfoCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdNavigation::vOnNaviAssitantGuideInfoCb(S_NAVI_ASSITANT_GUIDE_INFO* prAssistantGuideInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::vOnNaviAssitantGuideInfoCb entered"));
   SPI_NORMAL_ASSERT(NULL == prAssistantGuideInfo);

   if (NULL != prAssistantGuideInfo)
   {
	  NaviAssitantGuideInfoMsg oNaviAssitantGuideInfoMsg;
      ETG_TRACE_USR1(("[PARAM]::vOnNaviAssitantGuideInfoCb: action = %d ", prAssistantGuideInfo->action));
      ETG_TRACE_USR1(("[PARAM]::vOnNaviAssitantGuideInfoCb: assistantType = %d ", prAssistantGuideInfo->assistantType));
      ETG_TRACE_USR1(("[PARAM]::vOnNaviAssitantGuideInfoCb: trafficSignType = %d ", prAssistantGuideInfo->trafficSignType));
      ETG_TRACE_USR1(("[PARAM]::vOnNaviAssitantGuideInfoCb: totalDistance = %d ", prAssistantGuideInfo->totalDistance));
      ETG_TRACE_USR1(("[PARAM]::vOnNaviAssitantGuideInfoCb: remainDistance = %d ", prAssistantGuideInfo->remainDistance));
      ETG_TRACE_USR1(("[PARAM]::vOnNaviAssitantGuideInfoCb: cameraSpeed = %d ", prAssistantGuideInfo->cameraSpeed));
	  
      oNaviAssitantGuideInfoMsg.m_prNaviAssitantGuideInfo->enAction = static_cast<tenBdclAction>(prAssistantGuideInfo->action);
      oNaviAssitantGuideInfoMsg.m_prNaviAssitantGuideInfo->enAssistantType = static_cast<tenBdclAssistantType>(prAssistantGuideInfo->assistantType);
      oNaviAssitantGuideInfoMsg.m_prNaviAssitantGuideInfo->u32TrafficSignType = prAssistantGuideInfo->trafficSignType;
      oNaviAssitantGuideInfoMsg.m_prNaviAssitantGuideInfo->u32TotalDistance = prAssistantGuideInfo->totalDistance;
      oNaviAssitantGuideInfoMsg.m_prNaviAssitantGuideInfo->u32RemainingDistance = prAssistantGuideInfo->remainDistance;
      oNaviAssitantGuideInfoMsg.m_prNaviAssitantGuideInfo->u32CameraSpeed = prAssistantGuideInfo->cameraSpeed;

      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
         poMsgQInterface->bWriteMsgToQ(&oNaviAssitantGuideInfoMsg, sizeof(oNaviAssitantGuideInfoMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prAssistantGuideInfo)
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarLifeDataSubscribe()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdNavigation::bSendCarLifeDataSubscribe(const tBdclCarLifeInfoList& corfrCarLifeInfoList)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::vSendCarLifeDataSubscribe entered"));

   t_Bool bRet = false;
   if (NULL != m_spoNavigationProxy)
   {
      m_spoNavigationProxy->vSendCarLifeDataSubscribe(corfrCarLifeInfoList);
      bRet = true;
   }
   ETG_TRACE_USR2(("[PARAM}::vSendCarLifeDataSubscribe left with bRet = %d",ETG_ENUM(BOOL,bRet)));
   return bRet;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarLifeDataSubscribeStart()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdNavigation::bSendCarLifeDataSubscribeStart(const tBdclCarLifeInfoList& corfrCarLifeInfoStartList)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::bSendCarLifeDataSubscribeStart entered"));

   t_Bool bRet = false;
   if (NULL != m_spoNavigationProxy)
   {
      m_spoNavigationProxy->vSendCarLifeDataSubscribeStart(corfrCarLifeInfoStartList);
      bRet = true;
   }
   ETG_TRACE_USR2(("[PARAM}::bSendCarLifeDataSubscribeStart left with bRet = %d",ETG_ENUM(BOOL,bRet)));
   return bRet;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarLifeDataSubscribeStop()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdNavigation::bSendCarLifeDataSubscribeStop(const tBdclCarLifeInfoList& corfrCarLifeInfoStopList)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdNavigation::bSendCarLifeDataSubscribeStop entered"));

   t_Bool bRet = false;
   if (NULL != m_spoNavigationProxy)
   {
      m_spoNavigationProxy->vSendCarLifeDataSubscribeStop(corfrCarLifeInfoStopList);
      bRet = true;
   }
   ETG_TRACE_USR2(("[PARAM}::bSendCarLifeDataSubscribeStart left with bRet = %d",ETG_ENUM(BOOL,bRet)));
   return bRet;
}

