/***********************************************************************/
/*!
* \file  spi_tclBDCLRespNavigation.h
* \brief BDCL Navigation Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    BDCL Navigation Output Interface
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLRESPNAVIGATION_H_
#define SPI_TCLBDCLRESPNAVIGATION_H_

#include <vector>

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "BDCLTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclBDCLRespNavigation
* \brief BDCL Navigation Output Interface
*
* updates all the registered clients, whenever there is
* an update on BDCL session
*
****************************************************************************/
class spi_tclBDCLRespNavigation:public RespBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespNavigation::spi_tclBDCLRespNavigation()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespNavigation()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLRespNavigation()
       **************************************************************************/
      spi_tclBDCLRespNavigation():RespBase(e16BDCL_NAVIGATION_REGID)
      {
      }
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespNavigation::~spi_tclBDCLRespNavigation()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclBDCLRespNavigation()
       * \brief   Destructor
       * \sa      spi_tclBDCLRespNavigation(RegID enRegId)
       **************************************************************************/
      virtual ~spi_tclBDCLRespNavigation()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespNavigation::vOnCarLifeDataSubscriptionDoneUpdate()
       ***************************************************************************/
      /*!
       * \fn      vOnCarLifeDataSubscriptionDoneUpdate
       * \brief   Triggered when MD sends Carlife Data Subscription Done Message.
       * \param   tBdclCarLifeInfoList [IN]: List with Carlife Subscription Info
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnCarLifeDataSubscriptionDoneUpdate(const tBdclCarLifeInfoList& crfrInfolist)
      {
          SPI_INTENTIONALLY_UNUSED(crfrInfolist);
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespNavigation::vOnNaviNextTurnInfoUpdate()
       ***************************************************************************/
      /*!
       * \fn      vOnNaviNextTurnInfoUpdate
       * \brief   Triggered when BDCL device Navi Next Turn Info Msg
       * \param   crfrInfo [IN]: Structure containing BDCL NaviNextTurnInfo
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnNaviNextTurnInfoUpdate(const trBdclNaviNextTurnInfo& corfrBdclNaviNextTurnInfo)
      {
          SPI_INTENTIONALLY_UNUSED(corfrBdclNaviNextTurnInfo);
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespNavigation::vOnNaviAssitantGuideInfoUpdate()
       ***************************************************************************/
      /*!
       * \fn      vOnNaviAssitantGuideInfoUpdate
       * \brief   Triggered when BDCL devices sends Navi Assitant Guide Info
       * \param   crfrInfo [IN]: Structure containing Navi Assitant Guide Info
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnNaviAssitantGuideInfoUpdate(const trBdclNaviAssitantGuideInfo& corfrNaviAssitantGuideInfo)
      {
          SPI_INTENTIONALLY_UNUSED(corfrNaviAssitantGuideInfo);
      }

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespNavigation::spi_tclBDCLRespNavigation()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespNavigation(
       *                          const spi_tclBDCLRespNavigation& corfoSrc))
       * \brief   Parameterized Constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \sa      spi_tclBDCLRespNavigation(RegID enRegId)
       **************************************************************************/
      spi_tclBDCLRespNavigation(const spi_tclBDCLRespNavigation& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespNavigation& operator=( const spi_tclMLV...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespNavigation& operator=(
       *                          const spi_tclBDCLRespNavigation& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespNavigation(const spi_tclBDCLRespNavigation& otrSrc)
       ***************************************************************************/
      spi_tclBDCLRespNavigation& operator=(const spi_tclBDCLRespNavigation& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/


}; //class spi_tclBDCLRespVideo

#endif // SPI_TCLBDCLRESPNAVIGATION_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
