
/***********************************************************************/
/*!
* \file   spi_tclBDCLMediaDataDispatcher.cpp
* \brief   Message Dispatcher for MediaMetadata  Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for MediaMetadata Messages
AUTHOR:         pok6kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespRegister.h"
#include "spi_tclBDCLRespMediaData.h"
#include "spi_tclBDCLMediaDataDispatcher.h"


//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclBDCLMediaDataDispatcher.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleMediaDataMsg(this);                  \
   }														\
	vDeAllocateMsg();										\
}

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
** FUNCTION:  BDCLMediaDataMsgBase::BDCLMediaDataMsgBase
***************************************************************************/
BDCLMediaDataMsgBase::BDCLMediaDataMsgBase()
{
   ETG_TRACE_USR1(("BDCLMediaDataMsgBase::BDCLMediaDataMsgBase entered "));
   vSetServiceID (e32MODULEID_BDCLMEDIADATA);
}

/***************************************************************************
 ** FUNCTION:  BDCLMetaDataMsg::BDCLMetaDataMsg
 ***************************************************************************/
BDCLMetaDataMsg::BDCLMetaDataMsg() :  m_prBDCLMediaMetadata(NULL)
{
   ETG_TRACE_USR1(("BDCLMetaDataMsg::BDCLMetaDataMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLMetaDataMsg::BDCLMetaDataMsg
 ***************************************************************************/
BDCLMetaDataMsg::~BDCLMetaDataMsg()
{
   m_prBDCLMediaMetadata = NULL;
}
/***************************************************************************
** FUNCTION:  BDCLMetaDataMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLMetaDataMsg, spi_tclBDCLMediaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLMetaDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLMetaDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR4(("BDCLMetaDataMsg::vAllocateMsg entered "));
	m_prBDCLMediaMetadata = new trBdclMediaMetadata;
   SPI_NORMAL_ASSERT(NULL == m_prBDCLMediaMetadata);
}

/***************************************************************************
 ** FUNCTION:  BDCLMetaDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLMetaDataMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prBDCLMediaMetadata);
}
/***************************************************************************
 ** FUNCTION:  BDCLMetaDataMsg::BDCLMetaDataMsg
 ***************************************************************************/
BDCLProgressBarMsg::BDCLProgressBarMsg() :  u32ProgressBarInfo(0)
{
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLMetaDataMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLProgressBarMsg, spi_tclBDCLMediaDataDispatcher);

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMediaDataDispatcher::spi_tclBDCLMediaDataDispatcher
 ***************************************************************************/
spi_tclBDCLMediaDataDispatcher::spi_tclBDCLMediaDataDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLMediaDataDispatcher::spi_tclBDCLMediaDataDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMediaDataDispatcher::~spi_tclBDCLMediaDataDispatcher
 ***************************************************************************/
spi_tclBDCLMediaDataDispatcher::~spi_tclBDCLMediaDataDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLMediaDataDispatcher::~spi_tclBDCLMediaDataDispatcher "));
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLMediaDataDispatcher::vHandleMediaDataMsg(BDCLMetaDataMsg..)
***************************************************************************/
t_Void spi_tclBDCLMediaDataDispatcher::vHandleMediaDataMsg(BDCLMetaDataMsg* poBDCLMetaDataMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLMediaDataDispatcher::vHandleMediaStatusMsg:MediaMetadataStatus entered "));

   if (NULL != poBDCLMetaDataMsg)
   {
      ETG_TRACE_USR1(("spi_tclBDCLMediaDataDispatcher::vHandleMediaStatusMsg:poBDCLMetaDataMsg available!! "));
      CALL_REG_OBJECTS(spi_tclBDCLRespMediaData,
      e16BDCL_MEDIADATA_REGID,
      vMediaMetadataCallback(poBDCLMetaDataMsg->m_prBDCLMediaMetadata));
   } // if (NULL != poBDCLMetaDataMsg)
}


/***************************************************************************
** FUNCTION:  spi_tclBDCLMediaDataDispatcher::vHandleMediaDataMsg(BDCLProgressBarMsg..)
***************************************************************************/
t_Void spi_tclBDCLMediaDataDispatcher::vHandleMediaDataMsg(BDCLProgressBarMsg* poProgressBarInfo)const
{
   ETG_TRACE_USR1(("spi_tclBDCLMediaDataDispatcher::vHandleMediaStatusMsg:ProgressBar Info entered "));

   if (NULL != poProgressBarInfo)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespMediaData,
      e16BDCL_MEDIADATA_REGID,
      vProgressBarCallback(poProgressBarInfo->u32ProgressBarInfo));
   } // if (NULL != poBDCLMetaDataMsg)
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
