/***********************************************************************/
/*!
 * \file  spi_tclBDCLCmdMediaData.cpp
 * \brief  Implementation of the Class spi_tclBDCLCmdMediaData
 *************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
 *************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclBDCLProxyManager.h"
#include "spi_tclBDCLCmdMediaData.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLMediaDataDispatcher.h"
#ifdef FILEWRITE
#include "FileHandler.h"
using namespace spi::io;
#endif
//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_BDCLWRAPPER
#include "trcGenProj/Header/spi_tclBDCLCmdMediaData.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:   spi_tclBDCLCmdMediaData()
 ***************************************************************************/
spi_tclBDCLCmdMediaData::spi_tclBDCLCmdMediaData()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdMediaData::spi_tclBDCLCmdMediaData entered "));
}

/***************************************************************************
 ** FUNCTION:   ~spi_tclBDCLCmdMediaData()
 ***************************************************************************/
spi_tclBDCLCmdMediaData::~spi_tclBDCLCmdMediaData()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdMediaData::~spi_tclBDCLCmdMediaData entered "));

}

/***************************************************************************
 ** FUNCTION:   t_Bool bInitialize()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdMediaData::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdMediaData::bInitialize entered "));

   t_Bool bResult = false;
   t_SptrBDCLProxyManager spoProxyManager = spi_tclBDCLProxyManager::getInstance();
   SPI_NORMAL_ASSERT(!spoProxyManager);

   if (spoProxyManager)
   {
      m_spoMediaDataProxy = spoProxyManager->spoGetMediaDataProxyInstance();
      SPI_NORMAL_ASSERT(!m_spoMediaDataProxy);
   }//if (spoProxyManager)

   if (m_spoMediaDataProxy)
   {
      trBdclMediaDataCbs rMediaDataCbs;
      rMediaDataCbs.fvOnMediaInfo = &spi_tclBDCLCmdMediaData::vMediaInfoCb;
      rMediaDataCbs.fvOnProgressBarInfo = &spi_tclBDCLCmdMediaData::vProgessBarInfoCb;
      m_spoMediaDataProxy->vRegisterMediaDataCallbacks(rMediaDataCbs);
      bResult = true;
   }
   ETG_TRACE_USR1(("[DESC]::spi_tclBDCLCmdMediaData::bInitialize left with result = %d ", ETG_ENUM(BOOL, bResult)));
   return bResult;
}

/***************************************************************************
 ** FUNCTION:   t_Void vUninitialize()
 ***************************************************************************/
t_Void spi_tclBDCLCmdMediaData::vUninitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdMediaData::vUninitialize entered "));
   m_spoMediaDataProxy = nullptr;
}

/***************************************************************************
 ** FUNCTION:   t_Void vMediaInfoCb()
 ***************************************************************************/
t_Void spi_tclBDCLCmdMediaData::vMediaInfoCb(S_MEDIA_INFO* prMediaInfo)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdMediaData::vMediaInfoCb entered "));
   SPI_NORMAL_ASSERT(NULL == prMediaInfo);

   if (NULL != prMediaInfo)
   {
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: source:%s ", prMediaInfo->source.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: song:%s ", prMediaInfo->song.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: artist:%s ", prMediaInfo->artist.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: Album:%s ", prMediaInfo->album.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: songId:%s ", prMediaInfo->songId.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: duration:%d ", prMediaInfo->duration));
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: playlistNum:%d ", prMediaInfo->playlistNum));
      ETG_TRACE_USR4(("[PARAM]::vMediaInfoCb: mode:%d ", prMediaInfo->mode));

      spi_tclBDCLMsgQInterface *poMsgQinterface = spi_tclBDCLMsgQInterface::getInstance();

      if (NULL != poMsgQinterface)
      {
         BDCLMetaDataMsg oMetaDataMsg;

         if (prMediaInfo->source.length() < STR_METADATA_LENGTH)
         {
            memset(oMetaDataMsg.m_prBDCLMediaMetadata->cSource, 0, STR_METADATA_LENGTH);
            strncpy(oMetaDataMsg.m_prBDCLMediaMetadata->cSource, prMediaInfo->source.c_str(), STR_METADATA_LENGTH-1);
         }
         if (prMediaInfo->song.length() < STR_METADATA_LENGTH)
         {
            memset(oMetaDataMsg.m_prBDCLMediaMetadata->cSong, 0, STR_METADATA_LENGTH);
            strncpy(oMetaDataMsg.m_prBDCLMediaMetadata->cSong, prMediaInfo->song.c_str(), STR_METADATA_LENGTH-1);
         }
         if (prMediaInfo->artist.length() < STR_METADATA_LENGTH)
         {
            memset(oMetaDataMsg.m_prBDCLMediaMetadata->cArtist, 0, STR_METADATA_LENGTH);
            strncpy(oMetaDataMsg.m_prBDCLMediaMetadata->cArtist, prMediaInfo->artist.c_str(), STR_METADATA_LENGTH-1);
         }
         if (prMediaInfo->album.length() < STR_METADATA_LENGTH)
         {
            memset(oMetaDataMsg.m_prBDCLMediaMetadata->cAlbum, 0, STR_METADATA_LENGTH);
            strncpy(oMetaDataMsg.m_prBDCLMediaMetadata->cAlbum, prMediaInfo->album.c_str(), STR_METADATA_LENGTH-1);
         }
         if (prMediaInfo->songId.length() < STR_METADATA_LENGTH)
         {
            memset(oMetaDataMsg.m_prBDCLMediaMetadata->cSongID, 0, STR_METADATA_LENGTH);
            strncpy(oMetaDataMsg.m_prBDCLMediaMetadata->cSongID, prMediaInfo->songId.c_str(), STR_METADATA_LENGTH-1);
         }

         tU32 u32SizeofAlbumArt = static_cast<tU32> (prMediaInfo->albumArt.size());
         oMetaDataMsg.m_prBDCLMediaMetadata->sImageSize = u32SizeofAlbumArt;

         if ((u32SizeofAlbumArt > 0) && (u32SizeofAlbumArt < STR_ALBUMART_MAX_SIZE))
         {
            memcpy(oMetaDataMsg.m_prBDCLMediaMetadata->cAlbumArt, prMediaInfo->albumArt.c_str(), u32SizeofAlbumArt);
         }
         //This code is added for debugging purpose. define FILEWRITE before use
         #ifdef FILEWRITE
         t_Bool bFileExists = false;
         {
            FileHandler oFileHandler("/var/opt/bosch/dynamic/spi/CmdMediadata.txt", SPI_EN_RDONLY);
            bFileExists = (oFileHandler.bIsValid());
         }
         if (!bFileExists)
         {
            FileHandler oFileHandler("/var/opt/bosch/dynamic/spi/CmdMediadata.txt", SPI_EN_WRONLY);
            ETG_TRACE_USR4(("Writing turn icon data to file"));
            const signed char* pChar = (t_SString)(prMediaInfo->albumArt.data());
            oFileHandler.bFWrite(pChar, u32SizeofAlbumArt);
         }
         #endif
         oMetaDataMsg.m_prBDCLMediaMetadata->u32Duration = prMediaInfo->duration;
         oMetaDataMsg.m_prBDCLMediaMetadata->u32PlayListNumber = prMediaInfo->playlistNum;
         oMetaDataMsg.m_prBDCLMediaMetadata->enPlayMode = static_cast<tenBdclPlayMode> (prMediaInfo->mode);

         poMsgQinterface->bWriteMsgToQ(&oMetaDataMsg, sizeof(oMetaDataMsg));
      }//if (NULL != poMsgQinterface)
   }
} 

/***************************************************************************
 ** FUNCTION:   t_Void vProgessBarInfoCb()
 ***************************************************************************/
t_Void spi_tclBDCLCmdMediaData::vProgessBarInfoCb(S_MEDIA_PROGRESS_BAR* prProgressBarInfo)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdMediaData::vProgessBarInfoCb entered "));
   SPI_NORMAL_ASSERT(NULL == prProgressBarInfo);

   if (NULL != prProgressBarInfo)
   {
      ETG_TRACE_USR4(("[PARAM]::vProgessBarInfoCb: Progress Bar Info = %d ", prProgressBarInfo->progressBar));

      spi_tclBDCLMsgQInterface *poMsgQinterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQinterface)
      {
         BDCLProgressBarMsg oProgressBarMsg;
         oProgressBarMsg.u32ProgressBarInfo = prProgressBarInfo->progressBar;
         poMsgQinterface->bWriteMsgToQ(&oProgressBarMsg, sizeof(oProgressBarMsg));
      }//if (NULL != poMsgQinterface)
   }
}
