/***********************************************************************/
/*!
* \file  spi_tclBDCLSessionProxyIntf.h
* \brief  Implementation of the Class spi_tclBDCLSessionProxyIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         tch5kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBDCLSESSIONPROXYINTF_
#define SPI_TCLBDCLSESSIONPROXYINTF_

#include "BaseTypes.h"
#include "BDCLTypes.h"

class spi_tclBDCLSessionProxyIntf
{

   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLSessionProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLSessionProxyIntf()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLSessionProxyIntf()
       **************************************************************************/
      spi_tclBDCLSessionProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLSessionProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLSessionProxyIntf()
       * \brief   Destructor
       * \sa      spi_tclBDCLSessionProxyIntf()
       **************************************************************************/
      virtual ~spi_tclBDCLSessionProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void vRegisterSessionCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterSessionCallbacks()
       * \brief   Interface to register callbacks to Session events
       * \param   rSessionCbs [IN]: Contains Session callback
       **************************************************************************/
      virtual t_Void vRegisterSessionCallbacks(trBdclSessionCbs rSessionCbs) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void vSendHUInfo()
       ***************************************************************************/
      /*!
       * \fn      vSendHUInfo()
       * \brief   Sends HU info to BDCL device
       * \param   corfrHUInfo [IN]: Structure containing HU info
       **************************************************************************/
      virtual t_Void vSendHUInfo(const trBdclHUInfo& corfrHUInfo) = 0;

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCmdModuleControl()
       ***************************************************************************/
      /*!
       * \fn      vSendCmdModuleControl
       * \brief   Sends a Command Module Control message to BDCL device
       * \param   u32ModuleID [IN]: Indicates Module ID
       * \param   u32StatusID [IN]: Status of the module
       **************************************************************************/
      virtual t_Void vSendCmdModuleControl(t_U32 u32ModuleID, t_U32 u32StatusID) = 0;


      /***************************************************************************
       ** FUNCTION:   t_Void vSendFeatureConfigList()
       ***************************************************************************/
      /*!
       * \fn      vSendFeatureConfigList
       * \brief   Sends Feature configuration information to BDCL device
       * \param   corfrFeatConfigList[IN]: Indicates feature config info
       **************************************************************************/
      virtual t_Void vSendFeatureConfigList(const tBdclFeatureConfigList& corfrFeatConfigList) = 0;

};
#endif //SPI_TCLBDCLSESSIONPROXYINTF_
