/***********************************************************************/
/*!
* \file  spi_tclBDCLNavigationProxyIntf.h
* \brief  Implementation of the Class spi_tclBDCLNavigationProxyIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBDCLNAVIGATIONPROXYINTF_
#define SPI_TCLBDCLNAVIGATIONPROXYINTF_

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"

class spi_tclBDCLNavigationProxyIntf
{

   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLNavigationProxyIntf()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLNavigationProxyIntf()
       **************************************************************************/
      spi_tclBDCLNavigationProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLNavigationProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLNavigationProxyIntf()
       * \brief   Destructor
       * \sa      spi_tclBDCLNavigationProxyIntf()
       **************************************************************************/
      virtual ~spi_tclBDCLNavigationProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void vRegisterNavigationCallbacks(trBdclNavigationCbs rNavigationCbs)
       ***************************************************************************/
      /*!
       * \fn      vRegisterNavigationCallbacks
       * \brief
       * \param   rNavigationCbs [IN]: Contains Navigation callback pointers
       **************************************************************************/
      virtual t_Void vRegisterNavigationCallbacks(trBdclNavigationCbs rNavigationCbs) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribe(tBdclCarLifeInfoList rCarlifeInfoList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribe
       * \brief   To send Carlife Subscription message to BDCL on MD.
       * \param   rCarLifeInfoList [IN]: Contains list of Car Life Module info
       **************************************************************************/
      virtual t_Void vSendCarLifeDataSubscribe(const tBdclCarLifeInfoList& corfrCarLifeInfoList) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribeStart(tBdclCarLifeInfoList rCarlifeInfoStartList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStart
       * \brief   To send Carlife Subscription Start message to BDCL on MD.
       * \param   rCarLifeInfoStartList [IN]: Contains list of Car Life Module info
       **************************************************************************/
      virtual t_Void vSendCarLifeDataSubscribeStart(const tBdclCarLifeInfoList& corfrCarLifeInfoStartList) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribeStop(tBdclCarLifeInfoList rCarlifeInfoStartList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStop
       * \brief   To send Carlife Subscription Stop message to BDCL on MD.
       * \param   rCarLifeInfoStopList [IN]: Contains list of Car Life Module info
       **************************************************************************/
      virtual t_Void vSendCarLifeDataSubscribeStop(const tBdclCarLifeInfoList& corfrCarLifeInfoStopList) = 0;
};
#endif //SPI_TCLBDCLSESSIONPROXYINTF_
