/***********************************************************************/
/*!
* \file  spi_tclBDCLBluetoothProxyIntf.h
* \brief  Implementation of the Class spi_tclBDCLBluetoothProxyIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBDCLBLUETOOTHPROXYINTF_
#define SPI_TCLBDCLBLUETOOTHPROXYINTF_

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"

class spi_tclBDCLBluetoothProxyIntf
{

   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLBluetoothProxyIntf()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLBluetoothProxyIntf()
       **************************************************************************/
      spi_tclBDCLBluetoothProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLBluetoothProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLBluetoothProxyIntf()
       * \brief   Destructor
       * \sa      spi_tclBDCLBluetoothProxyIntf()
       **************************************************************************/
      virtual ~spi_tclBDCLBluetoothProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void vRegisterBTCallbacks(trBDCLBluetoothCbs rBluetoothCbs)
       ***************************************************************************/
      /*!
       * \fn      vRegisterBTCallbacks
       * \brief   Interface to register callbacks to BT events
       * \param   rSessionCbs [IN]: Contains Session callback pointers
       **************************************************************************/
      virtual t_Void vRegisterBTCallbacks(trBdclBluetoothCbs rBluetoothCbs) = 0;

      /***************************************************************************
       ** FUNCTION:t_Void vSendHUBTOOBInfo(trBdclBluetoothOOBInfo rOOBInfo)
       ***************************************************************************/
      /*!
       * \fn      vSendHUBTOOBInfo
       * \brief   Called to send OOB info to MD
       * \param   rOOBInfo [IN] : Contains OOB info
       **************************************************************************/
      virtual t_Void vSendHUBTOOBInfo(trBdclBluetoothOOBInfo* rOOBInfo) = 0;

      /***************************************************************************
       ** FUNCTION:t_Void vSendBTHfpIndication(trBdclBluetoothHFPIndication )
       ***************************************************************************/
      /*!
       * \fn     vSendBTHfpIndication
       * \brief  Called to send HFP Indication to MD
       * \param  rHfpIndication [IN] : Contains HFP Indication  info
       **************************************************************************/
      virtual t_Void vSendBTHfpIndication(trBdclBluetoothHFPIndication* rHfpIndicationInfo) = 0;

      /***************************************************************************
       ** FUNCTION:t_Void vSendBTHfpConnection(trBDCLHfpConnectionInfo* rHfpConnInfo)
       ***************************************************************************/
      /*!
       * \fn     vSendBTHfpConnection
       * \brief  Called to send HFP Connection Info to MD
       * \param  rHfpConnInfo [IN] : Contains HFP Connection info
       **************************************************************************/
      virtual t_Void vSendBTHfpConnection(trBdclBluetoothHFPConn* rHfpConnInfo) = 0;

      /***************************************************************************
       ** FUNCTION:t_Void vSendBTHfpResponse(trBDCLHfpResponseInfo rHfpRespInfo)
       ***************************************************************************/
      /*!
       * \fn     vSendBTHfpResponse
       * \brief  Called to send HFP Response Info to MD
       * \param  rHfpRespInfo [IN] : Contains HFP Response info
       **************************************************************************/
      virtual t_Void vSendBTHfpResponse(trBdclBluetoothHFPResponse* rHfpRespInfo) = 0;

      /*********************************************************************************************
       ** FUNCTION:t_Void vSendBTHfpStatusResponse(trBDCLHfpStatusResponseInfo rHfpStatusRespInfo)
       *********************************************************************************************/
      /*!
       * \fn     vSendBTHfpStatusResponse
       * \brief  Called to send HFP Status Response Info to MD
       * \param  rHfpStatusRespInfo [IN] : Contains HFP Status Response info
       **************************************************************************/
      virtual t_Void vSendBTHfpStatusResponse(trBdclBluetoothHFPStatusResponse* rHfpStatusRespInfo) = 0;

      /*********************************************************************************************
       ** FUNCTION:t_Void vSendBTStartIdentifyRequest(t_String strAddress)
       *********************************************************************************************/
      /*!
       * \fn     vSendBTStartIdentifyRequest
       * \brief  Called to send Start Identify Request msg
       * \param  strAddress [IN] : Contains BT Address
       **************************************************************************/
      virtual t_Void vSendBTStartIdentifyRequest(t_String strAddress) = 0;

};
#endif //SPI_TCLBDCLBLUETOOTHPROXYINTF_
