/***********************************************************************/
/*!
* \file   spi_tclBDCLAudioProxyIntf.h
* \brief  Implementation of the Class spi_tclBDCLAudioProxyIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBDCLAUDIOPROXYINTF_
#define SPI_TCLBDCLAUDIOPROXYINTF_


#include "BaseTypes.h"
#include "BDCL_WrapperTypes.h"

//! Forward declarations

class spi_tclBDCLAudioProxyIntf
{

   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAudioProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioProxyIntf()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLAudioProxyIntf()
       **************************************************************************/
      spi_tclBDCLAudioProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLAudioProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLAudioProxyIntf()
       * \brief   Destructor
       * \sa      spi_tclBDCLAudioProxyIntf()
       **************************************************************************/
      virtual ~spi_tclBDCLAudioProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterVRCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterVRCallbacks()
       * \brief   Interface to register for VR callbacks with BDCL stack
       * \param   rVoiceRecCbs [IN]: Structure containing VR callbacks
       **************************************************************************/
      virtual t_Void vRegisterVRCallbacks(trBdclVoiceRecognitionCbs rVoiceRecCbs) = 0;

};
#endif //SPI_TCLBDCLAUDIOPROXYINTF_
