/***********************************************************************/
/*!
* \file  spi_tclBDCLProxyManager.cpp
* \brief  Implementation of the Class spi_tclBDCLProxyManager
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
18.05.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "spi_tclBDCLLibProxy.h"
#include "spi_tclBDCLProxyManager.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_BDCLWRAPPER
      #include "trcGenProj/Header/spi_tclBDCLProxyManager.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:   spi_tclBDCLProxyManager()
 ***************************************************************************/
spi_tclBDCLProxyManager::spi_tclBDCLProxyManager()
{
   ETG_TRACE_USR1(("spi_tclBDCLProxyManager::spi_tclBDCLProxyManager entered "));
}

/***************************************************************************
 ** FUNCTION:   spi_tclBDCLProxyManager()
 ***************************************************************************/
spi_tclBDCLProxyManager::~spi_tclBDCLProxyManager()
{
   ETG_TRACE_USR1(("spi_tclBDCLProxyManager::~spi_tclBDCLProxyManager entered "));
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCoreDataIntf spoGetCoreDataIntf()
 ***************************************************************************/
t_SptrBDCLCoreDataIntf spi_tclBDCLProxyManager::spoGetCoreDataIntf()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLAudioProxy spoGetAudioProxyInstance()
 ***************************************************************************/
t_SptrBDCLAudioProxy spi_tclBDCLProxyManager::spoGetAudioProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLBluetoothProxy spoGetBluetoothProxyInstance()
 ***************************************************************************/
t_SptrBDCLBluetoothProxy spi_tclBDCLProxyManager::spoGetBluetoothProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCarDataProxy spoGetCarDataProxyInstance()
 ***************************************************************************/
t_SptrBDCLCarDataProxy spi_tclBDCLProxyManager::spoGetCarDataProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLInputProxy spoGetInputProxyInstance()
 ***************************************************************************/
t_SptrBDCLInputProxy spi_tclBDCLProxyManager::spoGetInputProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLSessionProxy spoGetSessionProxyInstance()
 ***************************************************************************/
t_SptrBDCLSessionProxy spi_tclBDCLProxyManager::spoGetSessionProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLVideoProxy spoGetVideoProxyInstance()
 ***************************************************************************/
t_SptrBDCLVideoProxy spi_tclBDCLProxyManager::spoGetVideoProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLMediaDataProxy spoGetMediaDataProxyInstance()
 ***************************************************************************/
t_SptrBDCLMediaDataProxy spi_tclBDCLProxyManager::spoGetMediaDataProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLNavigationProxy spoGetNavigationProxyInstance()
 ***************************************************************************/
t_SptrBDCLNavigationProxy spi_tclBDCLProxyManager::spoGetNavigationProxyInstance()
{
   return spoGetLibProxyInstance();
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLLibProxy spoGetLibProxyInstance()
 ***************************************************************************/
t_SptrBDCLLibProxy spi_tclBDCLProxyManager::spoGetLibProxyInstance()
{
   t_SptrBDCLLibProxy spoLibProxy = m_wpoLibProxy.lock();
   if (!spoLibProxy)
   {
      ETG_TRACE_USR2(("[DESC] spi_tclBDCLProxyManager::spoGetLibProxyInstance: Creating new LibProxy instance "));
      spoLibProxy = t_SptrBDCLLibProxy(new spi_tclBDCLLibProxy);
      m_wpoLibProxy = spoLibProxy;
   }
   return spoLibProxy;
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
