/***********************************************************************/
/*!
* \file  spi_tclBDCLProxyManager.h
* \brief  Implementation of the Class spi_tclBDCLProxyManager
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
18.05.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

#ifndef SPI_TCLBDCLPROXYMANAGERINTF_
#define SPI_TCLBDCLPROXYMANAGERINTF_

#include <memory>

#include "SharedSingleton.h"
#include "spi_tclBDCLCoreDataIntf.h"
#include "spi_tclBDCLAudioProxyIntf.h"
#include "spi_tclBDCLBluetoothProxyIntf.h"
#include "spi_tclBDCLCarDataProxyIntf.h"
#include "spi_tclBDCLInputProxyIntf.h"
#include "spi_tclBDCLMediaDataProxyIntf.h"
#include "spi_tclBDCLNavigationProxyIntf.h"
#include "spi_tclBDCLSessionProxyIntf.h"
#include "spi_tclBDCLVideoProxyIntf.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Forward declarations
class spi_tclBDCLProxyManager;
class spi_tclBDCLLibProxy;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::shared_ptr< spi_tclBDCLProxyManager >          t_SptrBDCLProxyManager;
typedef std::shared_ptr< spi_tclBDCLLibProxy >              t_SptrBDCLLibProxy;
typedef std::weak_ptr< spi_tclBDCLLibProxy >                t_WptrBDCLLibProxy;
typedef std::shared_ptr< spi_tclBDCLCoreDataIntf >          t_SptrBDCLCoreDataIntf;
typedef std::shared_ptr< spi_tclBDCLAudioProxyIntf >        t_SptrBDCLAudioProxy;
typedef std::shared_ptr< spi_tclBDCLBluetoothProxyIntf >    t_SptrBDCLBluetoothProxy;
typedef std::shared_ptr< spi_tclBDCLCarDataProxyIntf >      t_SptrBDCLCarDataProxy;
typedef std::shared_ptr< spi_tclBDCLInputProxyIntf >        t_SptrBDCLInputProxy;
typedef std::shared_ptr< spi_tclBDCLMediaDataProxyIntf >    t_SptrBDCLMediaDataProxy;
typedef std::shared_ptr< spi_tclBDCLNavigationProxyIntf >   t_SptrBDCLNavigationProxy;
typedef std::shared_ptr< spi_tclBDCLSessionProxyIntf >      t_SptrBDCLSessionProxy;
typedef std::shared_ptr< spi_tclBDCLVideoProxyIntf >        t_SptrBDCLVideoProxy;


class spi_tclBDCLProxyManager :
   public SharedSingleton< spi_tclBDCLProxyManager >
{

public:

      /***************************************************************************
       ** FUNCTION:    spi_tclBDCLProxyManager()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLProxyManager()
       * \brief   Constructor
       **************************************************************************/
      spi_tclBDCLProxyManager();

      /***************************************************************************
       ** FUNCTION:    ~spi_tclBDCLProxyManager()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLProxyManager()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclBDCLProxyManager();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCoreDataIntf spoGetCoreDataIntf()
       ***************************************************************************/
      /*!
       * \fn      spoGetCoreDataIntf()
       * \brief   Get pointer to core data interface
       **************************************************************************/
      t_SptrBDCLCoreDataIntf spoGetCoreDataIntf();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLAudioProxy spoGetAudioProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetAudioProxyInstance()
       * \brief   Get Audio proxy class's instance
       **************************************************************************/
      t_SptrBDCLAudioProxy spoGetAudioProxyInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLBluetoothProxy spoGetBluetoothProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetBluetoothProxyInstance()
       * \brief   Get Bluetooth proxy class's instance
       **************************************************************************/
      t_SptrBDCLBluetoothProxy spoGetBluetoothProxyInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCarDataProxy spoGetCarDataProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCarDataProxyInstance()
       * \brief   Get CarData proxy class's instance
       **************************************************************************/
      t_SptrBDCLCarDataProxy spoGetCarDataProxyInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLInputProxy spoGetInputProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetInputProxyInstance()
       * \brief   Get Input proxy class's instance
       **************************************************************************/
      t_SptrBDCLInputProxy spoGetInputProxyInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLMediaDataProxy spoGetMediaDataProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetMediaDataProxyInstance()
       * \brief   Get MediaData proxy class's instance
       **************************************************************************/
      t_SptrBDCLMediaDataProxy spoGetMediaDataProxyInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLNavigationProxy spoGetNavigationProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetNavigationProxyInstance()
       * \brief   Get Navigation proxy class's instance
       **************************************************************************/
       t_SptrBDCLNavigationProxy spoGetNavigationProxyInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLSessionProxy spoGetSessionProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetSessionProxyInstance()
       * \brief   Get Session proxy class's instance
       **************************************************************************/
      t_SptrBDCLSessionProxy spoGetSessionProxyInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLVideoProxy spoGetVideoProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetVideoProxyInstance()
       * \brief   Get Video proxy class's instance
       **************************************************************************/
      t_SptrBDCLVideoProxy spoGetVideoProxyInstance();

private:

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLLibProxy spoGetLibProxyInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetLibProxyInstance()
       * \brief   Using the weak pointer in manager class, creates & returns a new instance
       *          of LibProxy if a shared pointer to the object does not already exist.
       *          Else, returns a shared pointer to the LibProxy object.
       **************************************************************************/
      t_SptrBDCLLibProxy spoGetLibProxyInstance();

      //! LibProxy command class pointer
      t_WptrBDCLLibProxy m_wpoLibProxy;
};

#endif //SPI_TCLBDCLPROXYMANAGERINTF_
