/***********************************************************************/
/*!
 * \file  spi_tclBDCLMsgQInterface.h
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for BDCL Wrapper
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
 threading model for BDCL Wrapper
 AUTHOR:         pok6kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLBDCLMSGQINTERFACE_H_
#define SPI_TCLBDCLMSGQINTERFACE_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "MsgQThreader.h"
#include "spi_tclBDCLMsgQThreadable.h"
#include "GenericSingleton.h"

using namespace shl::thread;

/****************************************************************************/
/*!
 * \class spi_tclBDCLMsgQInterface
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for BDCL Wrapper
 ****************************************************************************/
class spi_tclBDCLMsgQInterface: public GenericSingleton<spi_tclBDCLMsgQInterface>
{
   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQInterface::spi_tclMySPINMsgQInterface()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINMsgQInterface()
       * \brief   Default Constructor
       * \sa      ~spi_tclMySPINMsgQInterface()
       **************************************************************************/
      spi_tclBDCLMsgQInterface();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMsgQInterface::~spi_tclBDCLMsgQInterface()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLMsgQInterface()
       * \brief   Destructor
       * \sa      spi_tclBDCLMsgQInterface()
       **************************************************************************/
      ~spi_tclBDCLMsgQInterface();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMsgQInterface::bWriteMsgToQ
       ***************************************************************************/
      /*!
       * \fn      bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
       * \brief   Write Msg to Q for dispatching the message by a seperate thread
       * \param prMsgBase : Pointer to Base Message type
       * \param u32MsgSize :  size of the message to be written to the MsgQ
       * \retval t_Bool
       **************************************************************************/
      t_Bool bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclBDCLMsgQInterface> ;

   private:
   
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMsgQInterface(const spi_tclBDCLMsgQInterface...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLMsgQInterface(
       *                             const spi_tclBDCLMsgQInterface& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLMsgQInterface()
       ***************************************************************************/
       spi_tclBDCLMsgQInterface(const spi_tclBDCLMsgQInterface& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMsgQInterface& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLMsgQInterface& operator=(
       *                          const spi_tclBDCLMsgQInterface& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLMsgQInterface(const spi_tclBDCLMsgQInterface& otrSrc)
       ***************************************************************************/
       spi_tclBDCLMsgQInterface& operator=(const spi_tclBDCLMsgQInterface& corfoSrc);   

      //! Pointer to the overridden MsgQThreadable class
      spi_tclBDCLMsgQThreadable *m_poBDCLMsgQThreadable;

      //! pointer to MsgQThreader
      MsgQThreader *m_poBDCLMsgQThreader;

};

#endif /* SPI_TCLBDCLMSGQINTERFACE_H_ */
