/***********************************************************************/
/*!
* \file  spi_tclBDCLManager.h
* \brief  Implementation of the Class spi_tclBDCLManager
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLMANAGER_
#define SPI_TCLBDCLMANAGER_

#include <memory>

#include "BaseTypes.h"
#include "RespRegister.h"
#include "SharedSingleton.h"
#include "spi_tclBDCLCmdAudio.h"
#include "spi_tclBDCLCmdBluetooth.h"
#include "spi_tclBDCLCmdCarData.h"
#include "spi_tclBDCLCmdInput.h"
#include "spi_tclBDCLCmdMediaData.h"
#include "spi_tclBDCLCmdNavigation.h"
#include "spi_tclBDCLCmdSession.h"
#include "spi_tclBDCLCmdVideo.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Forward declarations
class spi_tclBDCLManager;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::shared_ptr< spi_tclBDCLManager >         t_SptrBDCLManager;

typedef std::shared_ptr< spi_tclBDCLCmdAudio >        t_SptrBDCLCmdAudio;
typedef std::shared_ptr< spi_tclBDCLCmdBluetooth >    t_SptrBDCLCmdBluetooth;
typedef std::shared_ptr< spi_tclBDCLCmdCarData >      t_SptrBDCLCmdCarData;
typedef std::shared_ptr< spi_tclBDCLCmdInput >        t_SptrBDCLCmdInput;
typedef std::shared_ptr< spi_tclBDCLCmdMediaData >    t_SptrBDCLCmdMediaData;
typedef std::shared_ptr< spi_tclBDCLCmdNavigation >   t_SptrBDCLCmdNavigation;
typedef std::shared_ptr< spi_tclBDCLCmdSession >      t_SptrBDCLCmdSession;
typedef std::shared_ptr< spi_tclBDCLCmdVideo >        t_SptrBDCLCmdVideo;


/*!
 * \class spi_tclBDCLManager
 * \brief Manager class  to provide interface for SPI to interact with
 *        BDCLWrapper classes
 *
 */
class spi_tclBDCLManager :
   public SharedSingleton< spi_tclBDCLManager >
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLManager()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLManager()
       * \brief   Destructor
       * \sa      spi_tclBDCLManager()
       **************************************************************************/
      virtual ~spi_tclBDCLManager();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdAudio spoGetCmdAudioInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdAudioInstance()
       * \brief   Get Audio command class's instance
       **************************************************************************/
      t_SptrBDCLCmdAudio spoGetCmdAudioInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdBluetooth spoGetCmdBluetoothInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdBluetoothInstance()
       * \brief   Get Bluetooth command class's instance
       **************************************************************************/
      t_SptrBDCLCmdBluetooth spoGetCmdBluetoothInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdCarData spoGetCmdCarDataInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdCarDataInstance()
       * \brief   Get CarData command class's instance
       **************************************************************************/
      t_SptrBDCLCmdCarData spoGetCmdCarDataInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdInput spoGetCmdInputInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdInputInstance()
       * \brief   Get Input command class's instance
       **************************************************************************/
      t_SptrBDCLCmdInput spoGetCmdInputInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdMediaData spoGetCmdMediaDataInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdMediaDataInstance()
       * \brief   Get MediaData command class's instance
       **************************************************************************/
      t_SptrBDCLCmdMediaData spoGetCmdMediaDataInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdMediaData spoGetCmdNavigationInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdNavigationInstance()
       * \brief   Get Navigation command class's instance
       **************************************************************************/
      t_SptrBDCLCmdNavigation spoGetCmdNavigationInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdSession spoGetCmdSessionInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdSessionInstance()
       * \brief   Get Session command class's instance
       **************************************************************************/
      t_SptrBDCLCmdSession spoGetCmdSessionInstance();

      /***************************************************************************
       ** FUNCTION:    t_SptrBDCLCmdVideo spoGetCmdVideoInstance()
       ***************************************************************************/
      /*!
       * \fn      spoGetCmdVideoInstance()
       * \brief   Get Video command class's instance
       **************************************************************************/
      t_SptrBDCLCmdVideo spoGetCmdVideoInstance();

      /***************************************************************************
       ** FUNCTION:  t_Bool bRegisterObject(RespBase *poRespBase)
       ***************************************************************************/
      /*!
       * \fn       t_Bool bRegisterObject(RespBase *poRespBase)
       * \brief    Registers the response class object
       * \ret      returns true on success
       **************************************************************************/
      t_Bool bRegisterObject(RespBase *poRespBase);

      /***************************************************************************
       ** FUNCTION:  t_Bool bUnRegisterObject(RespBase *poRespBase)
       ***************************************************************************/
      /*!
       * \fn       t_Bool bUnRegisterObject(RespBase *poRespBase)
       * \brief    Unregisters the response class object
       * \ret      returns true on success
       **************************************************************************/
      t_Bool bUnRegisterObject(RespBase *poRespBase);

      friend class SharedSingleton < spi_tclBDCLManager > ;

   private:

      /***************************************************************************
       *******************************PRIVATE************************************
       **************************************************************************/

      /***************************************************************************
       ** FUNCTION:   spi_tclBDCLManager()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLManager()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLManager()
       **************************************************************************/
      spi_tclBDCLManager();


      //! Audio command class pointer
      t_SptrBDCLCmdAudio m_spoCmdAudio;

      //! Bluetooth command class pointer
      t_SptrBDCLCmdBluetooth m_spoCmdBluetooth;

      //! CarData command class pointer
      t_SptrBDCLCmdCarData m_spoCmdCarData;

      //! Input command class pointer
      t_SptrBDCLCmdInput m_spoCmdInput;

      //! MediaData command class pointer
      t_SptrBDCLCmdMediaData m_spoCmdMediaData;

      //! Navigation command class pointer
      t_SptrBDCLCmdNavigation m_spoCmdNavigation;

      //! Session command class pointer
      t_SptrBDCLCmdSession m_spoCmdSession;

      //! Video command class pointer
      t_SptrBDCLCmdVideo m_spoCmdVideo;


};
#endif //SPI_TCLBDCLMANAGER_
