/***********************************************************************/
/*!
 * \file  spi_tclBDCLCmdCarData.h
 * \brief  Implementation of the Class spi_tclBDCLCmdCarData
 *************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
 *************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "spi_tclBDCLCmdCarData.h"
#include "spi_tclBDCLProxyManager.h"
#include "SPITypes.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLCarDataDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_BDCLWRAPPER
#include "trcGenProj/Header/spi_tclBDCLCmdCarData.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:   spi_tclBDCLCmdCarData()
 ***************************************************************************/
spi_tclBDCLCmdCarData::spi_tclBDCLCmdCarData()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdCarData::spi_tclBDCLCmdCarData entered "));
}

/***************************************************************************
 ** FUNCTION:   ~spi_tclBDCLCmdCarData()
 ***************************************************************************/
spi_tclBDCLCmdCarData::~spi_tclBDCLCmdCarData()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdCarData::~spi_tclBDCLCmdCarData entered "));

}

/***************************************************************************
 ** FUNCTION:   t_Bool bInitialize()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdCarData::bInitialize()  entered "));

   t_Bool bResult = false;
   t_SptrBDCLProxyManager spoProxyManager = spi_tclBDCLProxyManager::getInstance();
   SPI_NORMAL_ASSERT(!spoProxyManager);

   if (spoProxyManager)
   {
      m_spoCarDataProxy = spoProxyManager->spoGetCarDataProxyInstance();
   }

   if (m_spoCarDataProxy)
   {
      trBdclCarDataCbs rCarDataCbs;
      rCarDataCbs.fvOnCarDataSubscribe = &spi_tclBDCLCmdCarData::vCarDataSubscribeCallback;
      rCarDataCbs.fvOnCarDataSubcribeStart = &spi_tclBDCLCmdCarData::vCarDataSubcribeStartCallback;
      rCarDataCbs.fvOnCarDataSubscribeStop = &spi_tclBDCLCmdCarData::vCarDataSubscribeStopCallback;

      m_spoCarDataProxy->vRegisterCarDataCallbacks(rCarDataCbs);

      bResult = true;
   }

   return bResult;
}

/***************************************************************************
 ** FUNCTION:   t_Void vUninitialize()
 ***************************************************************************/
t_Void spi_tclBDCLCmdCarData::vUninitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdCarData::vUninitialize entered "));
   m_spoCarDataProxy = nullptr;
}

/***************************************************************************
 ** FUNCTION:   t_Void vCarDataSubscribeCallback()
 ***************************************************************************/
t_Void spi_tclBDCLCmdCarData::vCarDataSubscribeCallback(S_VEHICLE_INFO_LIST *poContext)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vCarDataSubscribeCallback entered "));
   SPI_NORMAL_ASSERT(NULL == poContext);

   tBdclCarDataInfoList vecCarDataInfoList;

   if (NULL != poContext)
   {
      ETG_TRACE_USR2(("[PARAM]::vCarDataSubscribeCallback: Number of modules Requested = %d", poContext->cnt));

      S_VEHICLE_INFO* prVehicleInfo = poContext->pVehicleInfo;
      for (t_U32 u32ListIndex = 0; u32ListIndex < (poContext->cnt); ++u32ListIndex)
      {
         if (NULL != prVehicleInfo)
         {
            ETG_TRACE_USR4(("[PARAM]::vCarDataSubscribeCallback: ModuleID = %d, SupportFlag = %d, frequency= %d",
                     prVehicleInfo->moduleID, prVehicleInfo->supportFlag,prVehicleInfo->frequency));

            trBdclCarDataInfo rCarDataInfo;
            rCarDataInfo.enCarDataModuleID = static_cast<tenBdclCarDataModuleID>(prVehicleInfo->moduleID);
            rCarDataInfo.s32SupportFlag = prVehicleInfo->supportFlag;
            rCarDataInfo.u32Frequency = prVehicleInfo->frequency;
            vecCarDataInfoList.push_back(rCarDataInfo);

            prVehicleInfo = prVehicleInfo->pNext;
         }
      }//for (t_U32 u32ListIndex = 0; ...)
   }//if (NULL != prMobileStatusList)
   else
   {
      ETG_TRACE_USR2(("[DESC]::vCarDataSubscribeCallback: Empty Message received"));
      // poContext is NULL. NULL is sent by BDCL technology itself.
      // This(NULL == poContext) means that BDCL has not requested any type of car data module update.
      // As per discussion with BAIDU, Its a bug from there side which needs to be resolved.
      // But meanwhile Bosch needs to update GPS whenever NULL is received.
      // So, This block is work around for this anomaly.
      // If BDCL removes this anomaly behavior from technology, This block could be removed.

         trBdclCarDataInfo rCarDataInfo;
         rCarDataInfo.enCarDataModuleID = e8CAR_DATA_GPS;
         rCarDataInfo.s32SupportFlag = 1;
         rCarDataInfo.u32Frequency = 1;  //The update frequency is at least 1 Hz.
         vecCarDataInfoList.push_back(rCarDataInfo);
   }

   spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
   if ((NULL != poMsgQInterface) && (!vecCarDataInfoList.empty()))
   {
      BDCLCarDataSubscribeMsg oCarDataSubscribeMsg;
      *(oCarDataSubscribeMsg.m_pCarDataSubscriptionList) = vecCarDataInfoList;

      poMsgQInterface->bWriteMsgToQ(&oCarDataSubscribeMsg, sizeof(oCarDataSubscribeMsg));
   }//if (NULL != poMsgQinterface)
}


/***************************************************************************
 ** FUNCTION:   t_Void vCarDataSubcribeStartCallback()
 ***************************************************************************/
t_Void spi_tclBDCLCmdCarData::vCarDataSubcribeStartCallback(S_VEHICLE_INFO_LIST *poContext)
{
   ETG_TRACE_USR1((" spi_tclBDCLCmdCarData::vCarDataSubcribeStartCallback entered "));
   SPI_NORMAL_ASSERT(NULL == poContext);

   if (NULL != poContext)
   {
      ETG_TRACE_USR1(("[PARAM]::vCarDataSubcribeStartCallback: Number of modules changed = %d", poContext->cnt));

      tBdclCarDataInfoList carDataInfoList;
      if (0 == (poContext->cnt))
      {
         trBdclCarDataInfo rCarDataInfo;
         rCarDataInfo.enCarDataModuleID = e8CAR_DATA_GPS;
         rCarDataInfo.s32SupportFlag = 1;
         rCarDataInfo.u32Frequency = 1;  //The update frequency is at least 1 Hz.
         carDataInfoList.push_back(rCarDataInfo);

         ETG_TRACE_USR4(("[PARAM]::vCarDataSubcribeStartCallback: (0 == (poContext->cnt)) ModuleID = %d, SupportFlag = %d, frequency= %d",
                  rCarDataInfo.enCarDataModuleID, rCarDataInfo.s32SupportFlag,rCarDataInfo.u32Frequency));
      }
      else
      {
         S_VEHICLE_INFO* prVehicleInfo = poContext->pVehicleInfo;
         for (t_U32 u32ListIndex = 0; u32ListIndex < (poContext->cnt); ++u32ListIndex)
         {
            if (NULL != prVehicleInfo)
            {
               ETG_TRACE_USR4(("[PARAM]::vCarDataSubcribeStartCallback: ModuleID = %d, SupportFlag = %d, frequency= %d",
                        prVehicleInfo->moduleID, prVehicleInfo->supportFlag,prVehicleInfo->frequency));

               trBdclCarDataInfo rCarDataInfo;
               rCarDataInfo.enCarDataModuleID = static_cast<tenBdclCarDataModuleID>(prVehicleInfo->moduleID);
               rCarDataInfo.s32SupportFlag = prVehicleInfo->supportFlag;
               rCarDataInfo.u32Frequency = prVehicleInfo->frequency;
               carDataInfoList.push_back(rCarDataInfo);

               prVehicleInfo = prVehicleInfo->pNext;
            }
         }//for (t_U32 u32ListIndex = 0; ...)
      }
      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if ((NULL != poMsgQInterface) && (!carDataInfoList.empty()))
      {
         BDCLCarDataSubscribeStartMsg oCarDataSubscribeStartMsg;
         *(oCarDataSubscribeStartMsg.m_pCarDataSubscriptionStartList) = carDataInfoList;

         poMsgQInterface->bWriteMsgToQ(&oCarDataSubscribeStartMsg, sizeof(oCarDataSubscribeStartMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prMobileStatusList)
}


/***************************************************************************
 ** FUNCTION:   t_Void vCarDataSubscribeStopCallback()
 ***************************************************************************/
t_Void spi_tclBDCLCmdCarData::vCarDataSubscribeStopCallback(S_VEHICLE_INFO_LIST *poContext)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vCarDataSubcribeStartCallback entered "));
   SPI_NORMAL_ASSERT(NULL == poContext);

   if (NULL != poContext)
   {
      ETG_TRACE_USR1(("[PARAM]::vCarDataSubcribeStartCallback: Number of modules changed = %d", poContext->cnt));

      tBdclCarDataInfoList carDataInfoList;

      S_VEHICLE_INFO* prVehicleInfo = poContext->pVehicleInfo;
      for (t_U32 u32ListIndex = 0; u32ListIndex < (poContext->cnt); ++u32ListIndex)
      {
         if (NULL != prVehicleInfo)
         {
            ETG_TRACE_USR4(("[PARAM]::vCarDataSubcribeStartCallback: ModuleID = %d, SupportFlag = %d, frequency= %d",
                     prVehicleInfo->moduleID, prVehicleInfo->supportFlag,prVehicleInfo->frequency));

            trBdclCarDataInfo rCarDataInfo;
            rCarDataInfo.enCarDataModuleID = static_cast<tenBdclCarDataModuleID>(prVehicleInfo->moduleID);
            rCarDataInfo.s32SupportFlag = prVehicleInfo->supportFlag;
            rCarDataInfo.u32Frequency = prVehicleInfo->frequency;
            carDataInfoList.push_back(rCarDataInfo);

            prVehicleInfo = prVehicleInfo->pNext;
         }
      }//for (t_U32 u32ListIndex = 0; ...)

      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if ((NULL != poMsgQInterface) && (!carDataInfoList.empty()))
      {
         BDCLCarDataSubscribeStopMsg oCarDataSubscribeStopMsg;
         *(oCarDataSubscribeStopMsg.m_pCarDataSubscriptionStopList) = carDataInfoList;

         poMsgQInterface->bWriteMsgToQ(&oCarDataSubscribeStopMsg, sizeof(oCarDataSubscribeStopMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prMobileStatusList)
}//TODO copy the vector logic into common function..

/***************************************************************************
 ** FUNCTION:   t_Bool bSendGearInfo()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bSendGearInfo(t_S32 s32Gear)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vSendGearInfo entered with Gear Positon:%d",s32Gear));

   tenBdclGearState enGearState = static_cast<tenBdclGearState>(s32Gear);
   if (NULL != m_spoCarDataProxy)
   {
      m_spoCarDataProxy->vSendCarGearState(enGearState);
      return true;
   }
   else
      return false;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarAcceleration()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bSendCarAcceleration(trAccSensorData rCarAcceleration)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vSendAccelerationInfo entered with accX:%d,accY:%d,accZ:%d",rCarAcceleration.fAccX,rCarAcceleration.fAccY,rCarAcceleration.fAccZ));

   if (NULL != m_spoCarDataProxy)
   {
      m_spoCarDataProxy->vSendCarAcceleration(rCarAcceleration);
      return true;
   }
   else
      return false;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarVelocity()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bSendCarVelocity(trBdclCarVelocity rCarVelocity)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vSendVelocityInfo entered with speed:%d",rCarVelocity.u32speed));
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vSendVelocityInfo entered with timeStamp:%s",std::to_string(rCarVelocity.u64timestamp).c_str()));
   if (NULL != m_spoCarDataProxy)
   {
      m_spoCarDataProxy->vSendCarVelocity(rCarVelocity);
      return true;
   }
   else
      return false;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarOil()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bSendCarOil(trBdclCarOil rCarOil)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vSendVelocityInfo entered with level:%d,range:%d,LowFuelWarning:%d",rCarOil.s32level,rCarOil.s32range,rCarOil.bLowFuelWarning));
   if (NULL != m_spoCarDataProxy)
   {
      m_spoCarDataProxy->vSendCarOil(rCarOil);
      return true;
   }
   else
      return false;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarGyro()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bSendCarGyro(trGyroSensorData rCarGyro)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::vSendCarGyro entered with fGyroX:%d,fGyroY:%d,fGyroZ:%d",rCarGyro.fGyroX,rCarGyro.fGyroY,rCarGyro.fGyroZ));
   if (NULL != m_spoCarDataProxy)
   {
       m_spoCarDataProxy->vSendCarGyro(rCarGyro);
       return true;
   }
  else
       return false;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendCarGPS()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bSendCarGPS(trBdclCarGPS rCarGPS)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::bSendCarGPS entered" ));
   if (NULL != m_spoCarDataProxy)
   {
      m_spoCarDataProxy->vSendCarGPS(rCarGPS);
      return true;
   }
   else
      return false;
}

/***************************************************************************
 ** FUNCTION:   t_Bool bSendDataSubscribeDone()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdCarData::bSendDataSubscribeDone(const tBdclCarDataInfoList& rCarDataInfoList)
{
   ETG_TRACE_USR1((" spi_tclBdclCmdDataService::bSendDataSubscribeDone entered "));

   if (NULL != m_spoCarDataProxy)
   {
      m_spoCarDataProxy->vSendDataSubscribeDone(rCarDataInfoList);
      return true;
   }
   else
      return false;
}
