
/***********************************************************************/
/*!
 * \file   spi_tclBDCLCarDataDispatcher.cpp
 * \brief   Message Dispatcher for Cardata  Messages
 *************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Cardata Messages
AUTHOR:         pok6kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification

\endverbatim
 *************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "spi_tclBDCLRespCarData.h"
#include "spi_tclBDCLCarDataDispatcher.h"


//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclBDCLCarDataDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
         t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
         {                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleCarDataMsg(this);                  \
   }														\
   vDeAllocateMsg();										\
         }

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:  BDCLCarDataMsgBase::BDCLCarDataMsgBase
 ***************************************************************************/
BDCLCarDataMsgBase::BDCLCarDataMsgBase()
{
   ETG_TRACE_USR1(("BDCLCarDataMsgBase::BDCLCarDataMsgBase entered "));
   vSetServiceID (e32MODULEID_BDCLCARDATA);
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeMsg::BDCLCarDataSubscribeMsg
 ***************************************************************************/
BDCLCarDataSubscribeMsg::BDCLCarDataSubscribeMsg() :  m_pCarDataSubscriptionList(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeMsg::BDCLCarDataSubscribeMsg
 ***************************************************************************/
BDCLCarDataSubscribeMsg::~BDCLCarDataSubscribeMsg()
{
   m_pCarDataSubscriptionList = NULL;
}
/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLCarDataSubscribeMsg, spi_tclBDCLCarDataDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLCarDataSubscribeMsg::vAllocateMsg()
{
   m_pCarDataSubscriptionList = new tBdclCarDataInfoList;
   SPI_NORMAL_ASSERT(NULL == m_pCarDataSubscriptionList);
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLCarDataSubscribeMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_pCarDataSubscriptionList);
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::BDCLCarDataSubscribeStartMsg
 ***************************************************************************/
BDCLCarDataSubscribeStartMsg::BDCLCarDataSubscribeStartMsg() :  m_pCarDataSubscriptionStartList(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::BDCLCarDataSubscribeStartMsg
 ***************************************************************************/
BDCLCarDataSubscribeStartMsg::~BDCLCarDataSubscribeStartMsg()
{
   m_pCarDataSubscriptionStartList = NULL;
}
/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLCarDataSubscribeStartMsg, spi_tclBDCLCarDataDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLCarDataSubscribeStartMsg::vAllocateMsg()
{
   m_pCarDataSubscriptionStartList = new tBdclCarDataInfoList;
   SPI_NORMAL_ASSERT(NULL == m_pCarDataSubscriptionStartList);
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLCarDataSubscribeStartMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_pCarDataSubscriptionStartList);
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStopMsg::BDCLCarDataSubscribeStopMsg
 ***************************************************************************/
BDCLCarDataSubscribeStopMsg::BDCLCarDataSubscribeStopMsg() :  m_pCarDataSubscriptionStopList(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::BDCLCarDataSubscribeStartMsg
 ***************************************************************************/
BDCLCarDataSubscribeStopMsg::~BDCLCarDataSubscribeStopMsg()
{
   m_pCarDataSubscriptionStopList = NULL;
}
/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLCarDataSubscribeStopMsg, spi_tclBDCLCarDataDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLCarDataSubscribeStopMsg::vAllocateMsg()
{
   m_pCarDataSubscriptionStopList = new tBdclCarDataInfoList;
   SPI_NORMAL_ASSERT(NULL == m_pCarDataSubscriptionStopList);
}

/***************************************************************************
 ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLCarDataSubscribeStopMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_pCarDataSubscriptionStopList);
}


/***************************************************************************
 ** FUNCTION:  spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeMsg..)
 ***************************************************************************/
t_Void spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeMsg* poBDCLCarDataSubscribeMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg:for CarData Subscription entered "));

   if (NULL != poBDCLCarDataSubscribeMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespCarData,
               e16BDCL_CARDATA_REGID,
               vCarDataSubscriptionCallback(*poBDCLCarDataSubscribeMsg->m_pCarDataSubscriptionList));
   } // if (NULL != poBDCLMetaDataMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeStartMsg..)
 ***************************************************************************/
t_Void spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeStartMsg* poBDCLCarDataSubscribeStartMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg:for CarData Subscription Start "));

   if (NULL != poBDCLCarDataSubscribeStartMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespCarData,
               e16BDCL_CARDATA_REGID,
               vCarDataSubscriptionStartCallback(*poBDCLCarDataSubscribeStartMsg->m_pCarDataSubscriptionStartList));
   } // if (NULL != poBDCLMetaDataMsg)
}
/***************************************************************************
 ** FUNCTION:  spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeStartMsg..)
 ***************************************************************************/
t_Void spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeStopMsg* poBDCLCarDataSubscribeStopMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg:for CarData Subscription Start "));

   if (NULL != poBDCLCarDataSubscribeStopMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespCarData,
               e16BDCL_CARDATA_REGID,
               vCarDataSubscriptionStopCallback(*poBDCLCarDataSubscribeStopMsg->m_pCarDataSubscriptionStopList));
   } // if (NULL != poBDCLMetaDataMsg)
}


///////////////////////////////////////////////////////////////////////////////
// <EOF>
